/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.SummonTeamTaskScoreboardMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.Nullable;

public class TeamTaskScoreboardEntity
extends HangingEntity {
    private int width;
    private int height;

    public TeamTaskScoreboardEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public TeamTaskScoreboardEntity(Level level, BlockPos pos, Direction direction) {
        super(ModEntities.TEAM_TASK_SCOREBOARD, level, pos);
        this.calculateWidthAndHeightAndMoveCenter(direction);
        this.m_6022_(direction);
    }

    public TeamTaskScoreboardEntity(Level level, BlockPos pos, Vec3 position, Direction direction, int width, int height) {
        super(ModEntities.TEAM_TASK_SCOREBOARD, level, pos);
        this.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.width = width;
        this.height = height;
        this.m_6022_(direction);
    }

    private void calculateWidthAndHeightAndMoveCenter(Direction direction) {
        this.width = 0;
        this.height = 0;
        BlockPos blockpos = this.f_31698_.m_142300_(direction.m_122424_());
        Direction counterClockwiseDirection = direction.m_122428_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int[] heights = new int[4];
        block0: for (int i = 0; i < 4; ++i) {
            heights[i] = 0;
            for (int j = 0; j < 4; ++j) {
                mutablePos.m_122190_((Vec3i)blockpos).m_122175_(counterClockwiseDirection, i).m_122175_(Direction.UP, j);
                BlockState blockstate = this.f_19853_.m_8055_((BlockPos)mutablePos);
                BlockPos blockPosInFront = mutablePos.m_141952_(direction.m_122436_());
                BlockState blockstateInFront = this.f_19853_.m_8055_(blockPosInFront);
                if (!blockstateInFront.m_60795_() || !this.f_19853_.m_45772_(new AABB(blockPosInFront)) || !Block.m_49863_((LevelReader)this.f_19853_, (BlockPos)mutablePos, (Direction)direction) && !blockstate.m_60767_().m_76333_() && !DiodeBlock.m_52586_((BlockState)blockstate)) continue block0;
                heights[i] = j + 1;
            }
        }
        this.width = 16;
        this.height = 16;
        int maxSurface = 0;
        int curHeight = heights[0];
        for (int i = 0; i < heights.length; ++i) {
            int surface;
            if (heights[i] < curHeight) {
                curHeight = heights[i];
            }
            if ((surface = curHeight * (i + 1)) == 0) break;
            if (surface <= maxSurface) continue;
            maxSurface = surface;
            this.width = (i + 1) * 16;
            this.height = curHeight * 16;
        }
        Vec3i centerOffsetNormal = counterClockwiseDirection.m_122436_();
        BlockPos secondCorner = this.f_31698_.m_5484_(counterClockwiseDirection, this.width / 16).m_5484_(Direction.UP, this.height / 16);
        this.m_6034_((double)(this.m_31748_().m_123341_() + (counterClockwiseDirection.m_122429_() < 0 ? 1 : 0)) + (double)(secondCorner.m_123341_() - this.f_31698_.m_123341_()) / 2.0 + (double)(direction.m_122429_() < 0 ? 1 : 0) + (double)direction.m_122429_() * 0.5 / 16.0, (double)this.m_31748_().m_123342_() + (double)this.height / 16.0 / 2.0, (double)(this.m_31748_().m_123343_() + (counterClockwiseDirection.m_122431_() < 0 ? 1 : 0)) + (double)(secondCorner.m_123343_() - this.f_31698_.m_123343_()) / 2.0 + (double)(direction.m_122431_() < 0 ? 1 : 0) + (double)direction.m_122431_() * 0.5 / 16.0);
    }

    public boolean m_7088_() {
        if (!this.f_19853_.m_45786_((Entity)this)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int k = 0; k < this.width / 16; ++k) {
            for (int l = 0; l < this.height / 16; ++l) {
                int x = (int)(this.f_31699_.m_122434_() == Direction.Axis.Z ? this.m_20182_().m_7096_() - (double)(this.width / 16) / 2.0 + (double)k : (double)(Math.round(this.m_20182_().m_7096_()) + (long)(this.f_31699_.m_122424_().m_122429_() < 0 ? -1 : 0)));
                int y = (int)(this.m_20182_().m_7098_() - (double)(this.height / 16) / 2.0) + l;
                int z = (int)(this.f_31699_.m_122434_() == Direction.Axis.X ? this.m_20182_().m_7094_() - (double)(this.width / 16) / 2.0 + (double)k : (double)(Math.round(this.m_20182_().m_7094_()) + (long)(this.f_31699_.m_122424_().m_122431_() < 0 ? -1 : 0)));
                mutablePos.m_122178_(x, y, z);
                BlockState blockstate = this.f_19853_.m_8055_((BlockPos)mutablePos);
                if (Block.m_49863_((LevelReader)this.f_19853_, (BlockPos)mutablePos, (Direction)this.f_31699_) || blockstate.m_60767_().m_76333_() || DiodeBlock.m_52586_((BlockState)blockstate)) continue;
                return false;
            }
        }
        return this.f_19853_.m_6249_((Entity)this, this.m_142469_(), f_31697_).isEmpty();
    }

    public void m_6034_(double pX, double pY, double pZ) {
        this.f_31698_ = new BlockPos(pX, pY, pZ);
        this.m_20343_(pX, pY, pZ);
        this.m_7087_();
        this.f_19812_ = true;
    }

    protected void m_7087_() {
        if (this.f_31699_ != null) {
            double widthX = this.m_7076_();
            double height = this.m_7068_();
            double widthZ = this.m_7076_();
            if (this.f_31699_.m_122434_() == Direction.Axis.Z) {
                widthZ = 1.0;
            } else {
                widthX = 1.0;
            }
            this.m_20011_(new AABB(this.m_20182_().m_7096_() - (widthX /= 32.0), this.m_20182_().m_7098_() - (height /= 32.0), this.m_20182_().m_7094_() - (widthZ /= 32.0), this.m_20182_().m_7096_() + widthX, this.m_20182_().m_7098_() + height, this.m_20182_().m_7094_() + widthZ));
        }
    }

    public boolean m_5829_() {
        return true;
    }

    public int m_7076_() {
        return this.width;
    }

    public int m_7068_() {
        return this.height;
    }

    public void m_5553_(@Nullable Entity pBrokenEntity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (pBrokenEntity instanceof Player) {
                Player player = (Player)pBrokenEntity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19998_((ItemLike)ModItems.TEAM_TASK_SCOREBOARD);
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public Packet<?> m_5654_() {
        return ModNetwork.CHANNEL.toVanillaPacket((Object)new SummonTeamTaskScoreboardMessage(this), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Width", this.width);
        tag.m_128405_("Height", this.height);
        tag.m_128344_("Direction", (byte)this.f_31699_.m_122416_());
    }

    public void m_7378_(CompoundTag tag) {
        this.width = tag.m_128451_("Width");
        this.height = tag.m_128451_("Height");
        this.f_31699_ = Direction.m_122407_((int)tag.m_128445_("Direction"));
        super.m_7378_(tag);
        this.m_6022_(this.f_31699_);
    }
}

