/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.block.entity.RoyaleDrafterControllerTileEntity;
import iskallia.vault.container.RoyaleDraftContainer;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class TommyEntity
extends Mob {
    private static final EntityDataAccessor<BlockPos> TOMMY_POS = SynchedEntityData.m_135353_(TommyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public TommyEntity(EntityType<? extends Mob> type, Level world) {
        super(type, world);
        this.m_20331_(true);
        this.m_20242_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TOMMY_POS, (Object)BlockPos.f_121853_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_ = new GoalSelector(this.f_19853_.m_46658_());
        this.f_21346_ = new GoalSelector(this.f_19853_.m_46658_());
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void setTommyPos(BlockPos pos) {
        this.f_19804_.m_135381_(TOMMY_POS, (Object)pos);
    }

    public BlockPos getTommyPos() {
        return (BlockPos)this.f_19804_.m_135370_(TOMMY_POS);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_21455_(true, false);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (!this.isValid()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean isValid() {
        if (!this.f_19853_.isAreaLoaded(this.getTommyPos(), 1)) {
            return false;
        }
        if (this.m_20238_(Vec3.m_82512_((Vec3i)this.getTommyPos())) > 4.0) {
            return false;
        }
        BlockEntity te = this.f_19853_.m_7702_(this.getTommyPos());
        if (!(te instanceof RoyaleDrafterControllerTileEntity)) {
            return false;
        }
        return ((RoyaleDrafterControllerTileEntity)te).getMonitoredEntityId() == this.m_142049_();
    }

    @Nullable
    public RoyaleDrafterControllerTileEntity getControllerTile() {
        return (RoyaleDrafterControllerTileEntity)this.f_19853_.m_7702_(this.getTommyPos());
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            final RoyaleDrafterControllerTileEntity te = this.getControllerTile();
            if (te == null) {
                return InteractionResult.FAIL;
            }
            te.generatePlayerIfNotExists(player);
            if (te.getTab(player.m_142081_()) == -1) {
                return InteractionResult.FAIL;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent("Royale Draft");
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new RoyaleDraftContainer(windowId, playerInventory, TommyEntity.this.m_142049_(), te.getPresets(player.m_142081_()), te.getBlueTrinketPresets(player.m_142081_()), te.getRedTrinketPresets(player.m_142081_()), te.getLoot(player.m_142081_()), te.m_58899_());
                }
            }, buf -> {
                buf.writeInt(this.m_142049_());
                buf.m_178352_(te.getPresets(player.m_142081_()).keySet(), FriendlyByteBuf::m_130070_);
                te.getPresets(player.m_142081_()).forEach((key, value) -> {
                    buf.m_130070_(key);
                    buf.m_178355_(value, FriendlyByteBuf::m_130070_, FriendlyByteBuf::writeInt);
                });
                buf.m_178352_(te.getBlueTrinketPresets(player.m_142081_()), FriendlyByteBuf::m_130085_);
                buf.m_178352_(te.getRedTrinketPresets(player.m_142081_()), FriendlyByteBuf::m_130085_);
                buf.m_178352_(te.getLoot(player.m_142081_()), (buffer, loot) -> buffer.m_178352_((Collection)loot, FriendlyByteBuf::m_130055_));
                buf.m_130064_(te.m_58899_());
            });
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12506_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }
}

