/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.damage.DamageOverTimeHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ToxicGrenadeEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ToxicGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(ToxicGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(ToxicGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> POISON_TICKS = SynchedEntityData.m_135353_(ToxicGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 prevVelocity = Vec3.f_82478_;
    private float roll;
    private float oRoll;

    public ToxicGrenadeEntity(EntityType<? extends ToxicGrenadeEntity> type, Level level) {
        super(type, level);
    }

    public ToxicGrenadeEntity(Level level, LivingEntity thrower, float damage, float radius, int durationTicks, int poisonTicks) {
        super(ModEntities.TOXIC_GRENADE, thrower, level);
        this.m_5602_((Entity)thrower);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
        this.f_19804_.m_135381_(DURATION, (Object)durationTicks);
        this.f_19804_.m_135381_(POISON_TICKS, (Object)poisonTicks);
    }

    public float getRoll(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oRoll, (float)this.roll);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DURATION, (Object)0);
        this.f_19804_.m_135372_(POISON_TICKS, (Object)0);
    }

    protected Item m_7881_() {
        return Items.f_41852_;
    }

    public void m_8119_() {
        this.oRoll = this.roll;
        this.prevVelocity = this.m_20184_();
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        if (motion.m_82556_() > 1.0E-7) {
            double d0 = motion.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)d0) * 57.29577951308232));
            this.roll = (float)((double)this.roll + motion.m_82553_() * 20.0);
        }
        if (!this.f_19853_.f_46443_) {
            int duration = (Integer)this.f_19804_.m_135370_(DURATION);
            if (duration > 0 && this.f_19797_ >= duration) {
                this.explode();
            }
        } else if (this.f_19797_ % 4 == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        this.bounce(result.m_82450_().m_82546_(this.m_20182_()).m_82541_().m_82490_(-1.0));
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Vec3 normal = new Vec3((double)result.m_82434_().m_122429_(), (double)result.m_82434_().m_122430_(), (double)result.m_82434_().m_122431_());
        this.bounce(normal);
    }

    private void bounce(Vec3 normal) {
        Vec3 motion = this.prevVelocity.m_82556_() == 0.0 ? this.m_20184_() : this.prevVelocity;
        double dot = motion.m_82526_(normal);
        Vec3 reflect = motion.m_82546_(normal.m_82490_(2.0 * dot));
        reflect = new Vec3(reflect.f_82479_ * 0.6, reflect.f_82480_ * 0.2, reflect.f_82481_ * 0.6);
        reflect = reflect.m_82520_(0.0, 0.12, 0.0);
        this.m_20256_(reflect);
    }

    private void explode() {
        LivingEntity entity2;
        Entity owner = this.m_37282_();
        if (!(owner instanceof ServerPlayer)) {
            this.m_146870_();
            return;
        }
        ServerPlayer player = (ServerPlayer)owner;
        float radius = ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
        float damage = ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
        int poisonTicks = (Integer)this.f_19804_.m_135370_(POISON_TICKS);
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaEffectCloud.m_19718_((LivingEntity)player);
        areaEffectCloud.m_19712_(radius);
        areaEffectCloud.m_19732_(-0.5f);
        areaEffectCloud.m_19740_(0);
        areaEffectCloud.m_19734_(5);
        areaEffectCloud.m_19722_(Potions.f_43598_);
        areaEffectCloud.m_19738_(0.0f);
        areaEffectCloud.m_19714_(6195767);
        areaEffectCloud.m_19724_((ParticleOptions)ModParticles.NOVA_DOT.get());
        this.f_19853_.m_7967_((Entity)areaEffectCloud);
        DamageSource source = DamageSource.m_19344_((Player)player);
        List targets = this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82400_((double)radius), e -> e != player && !(e instanceof Player));
        for (LivingEntity entity2 : targets) {
            DamageOverTimeHelper.invalidateAll(entity2);
            ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_EFFECT_ATTACKING.runIfNotSet(() -> DamageOverTimeHelper.applyDamageOverTime(entity2, source, damage, poisonTicks, ActiveFlags.IS_POISON_NOVA_ATTACKING))));
            entity2.m_7292_(new MobEffectInstance(ModEffects.NOVA_DOT, poisonTicks, 0, false, true, false));
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12436_, SoundSource.PLAYERS, 0.2f, 1.0f);
        entity2 = this.f_19853_;
        if (entity2 instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)entity2;
            for (int i = 0; i < 10; ++i) {
                double offsetX = (this.f_19796_.nextDouble() - 0.5) * (double)radius * 0.5;
                double offsetY = this.f_19796_.nextDouble() * 1.0;
                double offsetZ = (this.f_19796_.nextDouble() - 0.5) * (double)radius * 0.5;
                server.m_8767_((ParticleOptions)ParticleTypes.f_175833_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.m_146870_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("damage", ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue());
        tag.m_128350_("radius", ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue());
        tag.m_128405_("duration", ((Integer)this.f_19804_.m_135370_(DURATION)).intValue());
        tag.m_128405_("poisonTicks", ((Integer)this.f_19804_.m_135370_(POISON_TICKS)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(tag.m_128457_("damage")));
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(tag.m_128457_("radius")));
        this.f_19804_.m_135381_(DURATION, (Object)tag.m_128451_("duration"));
        this.f_19804_.m_135381_(POISON_TICKS, (Object)tag.m_128451_("poisonTicks"));
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }
}

