/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEntities;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class VaultDamageNumberEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int MAX_AGE = 35;
    private final Collection<UUID> targetPlayers = new HashSet<UUID>();
    public int age;
    private float number = 0.0f;
    protected float speed = 1.0f;
    public float dy = 0.0f;
    public float prevDy = 0.0f;
    public DamageType color = DamageType.GENERIC;
    public float dx = 0.0f;
    public float prevDx = 0.0f;
    private float speedX = 0.0f;
    public float fadeout = -1.0f;
    public float prevFadeout = -1.0f;
    private int type = -1;
    protected final Random rand = new Random();
    private final List<Float> list = List.of(Float.valueOf(0.0f), Float.valueOf(-0.25f), Float.valueOf(0.12f), Float.valueOf(-0.12f), Float.valueOf(0.25f));
    private Entity parentEntity = null;
    private UUID parentId = null;
    private double parentOffsetX = 0.0;
    private double parentOffsetY = 0.0;
    private double parentOffsetZ = 0.0;

    public VaultDamageNumberEntity(PlayMessages.SpawnEntity packet, Level world) {
        this(ModEntities.VAULT_DAMAGE_NUMBER, world);
    }

    public VaultDamageNumberEntity(EntityType<? extends VaultDamageNumberEntity> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public VaultDamageNumberEntity(float number, DamageType color, int type, Level world, Collection<UUID> playersThatCanSee) {
        this(ModEntities.VAULT_DAMAGE_NUMBER, world);
        this.number = number;
        this.color = color;
        this.type = type;
        this.targetPlayers.clear();
        this.targetPlayers.addAll(playersThatCanSee);
    }

    public boolean canPlayerSee(@Nullable Player p) {
        return p == null || this.targetPlayers.contains(p.m_142081_());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0);
    }

    public void setParentEntity(Entity parent) {
        this.parentEntity = parent;
        this.parentId = parent.m_142081_();
        this.parentOffsetX = this.m_20185_() - parent.m_20185_();
        this.parentOffsetY = this.m_20186_() - parent.m_20186_();
        this.parentOffsetZ = this.m_20189_() - parent.m_20189_();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.number);
        buffer.writeInt(this.color.ordinal());
        buffer.writeInt(this.type);
        buffer.writeInt(this.targetPlayers.size());
        this.targetPlayers.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130077_(arg_0));
        buffer.writeBoolean(this.parentId != null);
        if (this.parentId != null) {
            buffer.m_130077_(this.parentId);
            buffer.writeDouble(this.parentOffsetX);
            buffer.writeDouble(this.parentOffsetY);
            buffer.writeDouble(this.parentOffsetZ);
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        int i;
        this.number = buffer.readFloat();
        int colorId = buffer.readInt();
        if (colorId >= 0 && colorId < DamageType.values().length) {
            this.color = DamageType.values()[colorId];
        }
        this.speedX = (i = buffer.readInt()) != -1 ? this.list.get(i % this.list.size()).floatValue() : this.list.get(this.rand.nextInt(this.list.size())).floatValue();
        int size = buffer.readInt();
        this.targetPlayers.clear();
        for (int j = 0; j < size; ++j) {
            this.targetPlayers.add(buffer.m_130259_());
        }
        boolean hasParent = buffer.readBoolean();
        if (hasParent) {
            this.parentId = buffer.m_130259_();
            this.parentOffsetX = buffer.readDouble();
            this.parentOffsetY = buffer.readDouble();
            this.parentOffsetZ = buffer.readDouble();
        }
    }

    public void m_7378_(CompoundTag compound) {
        this.number = compound.m_128457_("Number");
        int colorId = compound.m_128451_("Type");
        if (colorId >= 0 && colorId < DamageType.values().length) {
            this.color = DamageType.values()[colorId];
        }
        this.age = compound.m_128451_("Age");
        if (compound.m_128403_("ParentId")) {
            this.parentId = compound.m_128342_("ParentId");
            this.parentOffsetX = compound.m_128459_("ParentOffsetX");
            this.parentOffsetY = compound.m_128459_("ParentOffsetY");
            this.parentOffsetZ = compound.m_128459_("ParentOffsetZ");
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128350_("Number", this.number);
        compound.m_128405_("Type", this.color.ordinal());
        compound.m_128405_("Age", this.age);
        if (this.parentId != null) {
            compound.m_128362_("ParentId", this.parentId);
            compound.m_128347_("ParentOffsetX", this.parentOffsetX);
            compound.m_128347_("ParentOffsetY", this.parentOffsetY);
            compound.m_128347_("ParentOffsetZ", this.parentOffsetZ);
        }
    }

    protected void m_8097_() {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        if (this.age++ > 35 || this.m_20186_() < -64.0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.parentEntity == null && this.parentId != null) {
            for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82400_(32.0))) {
                if (!entity.m_142081_().equals(this.parentId)) continue;
                this.parentEntity = entity;
                break;
            }
        }
        if (this.parentEntity != null && this.parentEntity.m_6084_()) {
            double newX = this.parentEntity.m_20185_() + this.parentOffsetX;
            double newY = this.parentEntity.m_20186_() + this.parentOffsetY;
            double newZ = this.parentEntity.m_20189_() + this.parentOffsetZ;
            this.m_6034_(newX, newY, newZ);
        }
        if (this.f_19853_.f_46443_) {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.age > 35.0f - length ? (35.0f - (float)this.age) / length : 1.0f;
            this.prevDy = this.dy;
            this.dy += this.speed;
            this.prevDx = this.dx;
            this.dx += this.speedX;
            if (Math.sqrt(Math.pow((double)this.dx * 1.5, 2.0) + Math.pow(this.dy - 1.0f, 2.0)) < 0.8999999999999999) {
                this.speed /= 2.0f;
            } else {
                this.speed = 0.0f;
                this.speedX = 0.0f;
            }
        }
    }

    public float getNumber() {
        return this.number;
    }

    public boolean m_142535_(float p_146828_, float p_146829_, DamageSource p_146830_) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public static enum DamageType {
        GENERIC(15223354),
        FIRE(11035173),
        MAGIC(0xCC00FF),
        PROJECTILE(15223354),
        EXPLOSION(15223354),
        FALL(15223354),
        DROWNING(24831),
        POISON(7334234),
        CHAINING(6119096),
        THORNS(0xC55757),
        CRITICAL(0x8B0000),
        DOT(16738816),
        AOE(15319925),
        REFLECT(0xFFB00F),
        TOTEM(0xD80000),
        CHARMED(16711883),
        EFFECT(1681124),
        JAVELIN(0xD80000),
        SMITE(16711883),
        SMITE_BASE(16711883),
        FIRESHOT(16743168),
        GLACIAL(8973822),
        AP(16711883);

        private final int defaultColor;

        private DamageType(int defaultColor) {
            this.defaultColor = defaultColor;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }

        public Color getDefaultColorObject() {
            return new Color(this.defaultColor);
        }

        public static DamageType fromDamageSource(DamageSource source) {
            if (source.m_19384_()) {
                return FIRE;
            }
            if (source.m_19387_()) {
                return MAGIC;
            }
            if (source.m_19360_()) {
                return PROJECTILE;
            }
            if (source.m_19372_()) {
                return EXPLOSION;
            }
            if (source == DamageSource.f_19315_) {
                return FALL;
            }
            if (source == DamageSource.f_19312_) {
                return DROWNING;
            }
            if (ActiveFlags.IS_POISON_NOVA_ATTACKING.isSet()) {
                return POISON;
            }
            if (ActiveFlags.IS_THORNS_REFLECTING.isSet()) {
                return THORNS;
            }
            if (ActiveFlags.IS_CHAINING_ATTACKING.isSet()) {
                return CHAINING;
            }
            if (ActiveFlags.IS_REFLECT_ATTACKING.isSet()) {
                return REFLECT;
            }
            if (ActiveFlags.IS_FIRESHOT_ATTACKING.isSet()) {
                return FIRESHOT;
            }
            if (ActiveFlags.IS_GLACIAL_SHATTER_ATTACKING.isSet()) {
                return GLACIAL;
            }
            if (ActiveFlags.IS_TOTEM_ATTACKING.isSet()) {
                return TOTEM;
            }
            if (ActiveFlags.IS_CHARMED_ATTACKING.isSet()) {
                return CHARMED;
            }
            if (ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
                return EFFECT;
            }
            if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
                return JAVELIN;
            }
            if (ActiveFlags.IS_SMITE_BASE_ATTACKING.isSet()) {
                return SMITE_BASE;
            }
            if (ActiveFlags.IS_SMITE_ATTACKING.isSet()) {
                return SMITE;
            }
            if (ActiveFlags.IS_DOT_ATTACKING.isSet()) {
                return DOT;
            }
            if (ActiveFlags.IS_AOE_ATTACKING.isSet()) {
                return AOE;
            }
            if (ActiveFlags.IS_AP_ATTACKING.isSet()) {
                return AP;
            }
            return GENERIC;
        }

        @OnlyIn(value=Dist.CLIENT)
        public Color getColour() {
            return ((IVaultOptions)Minecraft.m_91087_().f_91066_).getDamageTypeColour(this);
        }

        public String getFormattedName() {
            String name = this.name().toLowerCase(Locale.ROOT);
            StringBuilder formattedName = new StringBuilder();
            for (String part : name.split("_")) {
                if (!formattedName.isEmpty()) {
                    formattedName.append(" ");
                }
                formattedName.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            return formattedName.toString();
        }
    }
}

