/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEntities;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class VaultGrenade
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(VaultGrenade.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(VaultGrenade.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(VaultGrenade.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 prevVelocity = Vec3.f_82478_;
    private float roll;
    private float oRoll;

    public VaultGrenade(EntityType<? extends VaultGrenade> type, Level level) {
        super(type, level);
    }

    public VaultGrenade(Level level, LivingEntity thrower, float damage, float radius, int duration) {
        super(ModEntities.GRENADE, thrower, level);
        this.m_5602_((Entity)thrower);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
        this.f_19804_.m_135381_(DURATION, (Object)duration);
    }

    public float getRoll(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oRoll, (float)this.roll);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DURATION, (Object)0);
    }

    protected Item m_7881_() {
        return Items.f_41852_;
    }

    public void m_8119_() {
        this.oRoll = this.roll;
        this.prevVelocity = this.m_20184_();
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        if (motion.m_82556_() > 1.0E-7) {
            double d0 = motion.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)d0) * 57.29577951308232));
            this.roll = (float)((double)this.roll + motion.m_82553_() * 20.0);
        }
        if (!this.f_19853_.f_46443_) {
            int d = (Integer)this.f_19804_.m_135370_(DURATION);
            if (d > 0 && this.f_19797_ >= d) {
                this.explode();
            }
        } else if (this.f_19797_ % 4 == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        this.bounce(result.m_82450_().m_82546_(this.m_20182_()).m_82541_().m_82490_(-1.0), result.m_82450_());
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Vec3 normal = new Vec3((double)result.m_82434_().m_122429_(), (double)result.m_82434_().m_122430_(), (double)result.m_82434_().m_122431_());
        this.bounce(normal, result.m_82450_());
    }

    private void bounce(Vec3 normal, Vec3 hitPos) {
        Vec3 motion = this.prevVelocity.m_82556_() == 0.0 ? this.m_20184_() : this.prevVelocity;
        double dot = motion.m_82526_(normal);
        Vec3 reflect = motion.m_82546_(normal.m_82490_(2.0 * dot));
        reflect = new Vec3(reflect.f_82479_ * 0.6, reflect.f_82480_ * 0.2, reflect.f_82481_ * 0.6);
        reflect = reflect.m_82520_(0.0, 0.12, 0.0);
        this.m_20256_(reflect);
    }

    private void explode() {
        Entity owner = this.m_37282_();
        if (!(owner instanceof ServerPlayer)) {
            this.m_146870_();
            return;
        }
        ServerPlayer player = (ServerPlayer)owner;
        float radius = ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
        float damage = ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
        DamageSource source = DamageSource.m_19344_((Player)player);
        this.createSafeExplosion(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), radius);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.m_146870_();
    }

    private void createSafeExplosion(ServerPlayer player, double x, double y, double z, float radius) {
        List entities = this.f_19853_.m_45976_(Entity.class, this.m_142469_().m_82400_((double)radius));
        DamageSource explosionSource = DamageSource.m_19373_((LivingEntity)player);
        for (Entity entity : entities) {
            LivingEntity living;
            double distance;
            if (entity == player || entity instanceof ArmorStand || entity instanceof HangingEntity || entity instanceof Player || entity instanceof PetEntity || entity instanceof ItemEntity || (distance = (double)entity.m_20270_((Entity)this)) > (double)radius) continue;
            Vec3 direction = entity.m_20182_().m_82492_(x, y, z).m_82541_();
            double knockbackStrength = (1.0 - distance / (double)radius) * 0.5;
            entity.m_20256_(entity.m_20184_().m_82520_(direction.f_82479_ * knockbackStrength, direction.f_82480_ * knockbackStrength * 0.5, direction.f_82481_ * knockbackStrength));
            if (!(entity instanceof LivingEntity) || !player.m_6779_(living = (LivingEntity)entity)) continue;
            float explosionDamage = ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
            ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> living.m_6469_(explosionSource, explosionDamage)));
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("damage", ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue());
        tag.m_128350_("radius", ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue());
        tag.m_128405_("duration", ((Integer)this.f_19804_.m_135370_(DURATION)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(tag.m_128457_("damage")));
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(tag.m_128457_("radius")));
        this.f_19804_.m_135381_(DURATION, (Object)tag.m_128451_("duration"));
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }
}

