/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.VaultStormEntity;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.MiscUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class VaultStormArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Float> ID_DAMAGE = SynchedEntityData.m_135353_(VaultStormArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> THROWER_UUID = SynchedEntityData.m_135353_(VaultStormArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> ID_TYPE = SynchedEntityData.m_135353_(VaultStormArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ALLOW_PVP = SynchedEntityData.m_135353_(VaultStormArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean grounded;
    private int life;
    public Vec3 prevDeltaMovement = new Vec3(0.0, 0.0, 0.0);
    private float radius;
    private int duration;
    private int intervalTicks;
    private float percentAbilityPowerDealt;
    private boolean leftOwner;
    private boolean hasBeenShot;
    private int slowDuration;
    private int frostbiteDuration;
    private int amplifier;
    private int intervalHypothermiaTicks;
    private float frostbiteChance;
    private float percentAbilityPowerDealtMin;
    private float percentAbilityPowerDealtMax;

    public VaultStormArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public VaultStormArrow(Level level, LivingEntity thrower) {
        super(ModEntities.STORM_ARROW, thrower, level);
        this.m_5602_((Entity)thrower);
        this.f_19804_.m_135381_(THROWER_UUID, Optional.of(thrower.m_142081_()));
    }

    public void setSlowDuration(int slowDuration) {
        this.slowDuration = slowDuration;
    }

    public void setFrostbiteDuration(int frostbiteDuration) {
        this.frostbiteDuration = frostbiteDuration;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setFrostbiteChance(float frostbiteChance) {
        this.frostbiteChance = frostbiteChance;
    }

    public void setIntervalHypothermiaTicks(int intervalHypothermiaTicks) {
        this.intervalHypothermiaTicks = intervalHypothermiaTicks;
    }

    private int getSlowDuration() {
        return this.slowDuration;
    }

    public int getFrostbiteDuration() {
        return this.frostbiteDuration;
    }

    private int getAmplifier() {
        return this.amplifier;
    }

    private int getIntervalHypothermiaTicks() {
        return this.intervalHypothermiaTicks;
    }

    private float getFrostbiteChance() {
        return this.frostbiteChance;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setAllowPvP(boolean allow) {
        this.f_19804_.m_135381_(ALLOW_PVP, (Object)allow);
    }

    public boolean allowsPvP() {
        return (Boolean)this.f_19804_.m_135370_(ALLOW_PVP);
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setIntervalTicks(int intervalTicks) {
        this.intervalTicks = intervalTicks;
    }

    public void setAbilityPowerPercent(float percentAbilityPowerDealt) {
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
    }

    public void setAbilityPowerPercentRange(float min, float max) {
        this.percentAbilityPowerDealtMin = min;
        this.percentAbilityPowerDealtMax = max;
    }

    public void setStormArrowType(int id) {
        this.setStormArrowType(StormType.byId(id));
    }

    public void setStormArrowType(StormType type) {
        this.f_19804_.m_135381_(ID_TYPE, (Object)type.ordinal());
    }

    public StormType getStormArrowType() {
        return StormType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ID_TYPE, (Object)0);
        this.f_19804_.m_135372_(THROWER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ALLOW_PVP, (Object)false);
    }

    public byte m_36796_() {
        return 0;
    }

    private boolean shouldFall() {
        return this.f_36703_ && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.f_36703_ = false;
        Vec3 vec3 = this.m_20184_();
        this.life = 0;
    }

    private boolean checkLeftOwner() {
        Entity entity = this.m_37282_();
        if (entity != null) {
            for (Entity entity1 : this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), p_37272_ -> !p_37272_.m_5833_() && p_37272_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_20068_() {
        return super.m_20068_();
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (this.f_36704_ > 4) {
            this.grounded = true;
        }
        if (this.f_19853_.m_5776_() && !this.grounded && this.f_19797_ > 2) {
            for (int i = 0; i < 2; ++i) {
                ParticleEngine pm = Minecraft.m_91087_().f_91061_;
                Particle particle = pm.m_107370_((ParticleOptions)ModParticles.ENDER_ANCHOR.get(), this.m_20182_().f_82479_ + this.m_20184_().f_82479_ / (double)i, this.m_20182_().f_82480_ + this.m_20184_().f_82480_ / (double)i, this.m_20182_().f_82481_ + this.m_20184_().f_82481_ / (double)i, 0.0, 0.0, 0.0);
                if (particle != null) {
                    if (this.getStormArrowType() == StormType.BASE) {
                        particle.m_107253_(1.0f, 0.9f, 0.0f);
                    } else if (this.getStormArrowType() == StormType.BLIZZARD) {
                        particle.m_107253_(0.6f, 0.7f, 0.9f);
                    }
                    particle.m_6569_(0.75f);
                }
                if ((particle = pm.m_107370_((ParticleOptions)ModParticles.ENDER_ANCHOR.get(), this.m_20182_().f_82479_ + this.m_20184_().f_82479_ / (double)i, this.m_20182_().f_82480_ + this.m_20184_().f_82480_ / (double)i, this.m_20182_().f_82481_ + this.m_20184_().f_82481_ / (double)i, 0.0, 0.0, 0.0)) == null) continue;
                if (this.getStormArrowType() == StormType.BASE) {
                    particle.m_107253_(1.0f, 0.9f, 0.9f);
                } else if (this.getStormArrowType() == StormType.BLIZZARD) {
                    particle.m_107253_(0.7f, 0.8f, 1.0f);
                }
                particle.m_6569_(0.35f);
            }
        }
        this.prevDeltaMovement = this.m_20184_();
        this.m_6075_();
        if (!this.hasBeenShot) {
            this.m_146855_(GameEvent.f_157778_, this.m_37282_(), this.m_142538_());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        boolean flag = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_142538_())).m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.shouldFall()) {
                this.startFalling();
            } else if (!this.f_19853_.f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            Vec3 vec33;
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_146910_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_37282_();
                    boolean allowPvP = this.allowsPvP();
                    if (!allowPvP && entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(VaultStormArrow.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(VaultStormArrow.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            float f1 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f2 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.m_6882_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.025f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    @NotNull
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos, float radius) {
        AABB aabb = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        return world.m_45976_(LivingEntity.class, aabb);
    }

    protected void m_6532_(@NotNull HitResult result) {
        VaultStormEntity storm = new VaultStormEntity(this.f_19853_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 8.0, this.m_20182_().f_82481_, this.radius, this.duration, this.m_37282_(), this.percentAbilityPowerDealtMin, this.percentAbilityPowerDealtMax, this.intervalTicks);
        storm.setAllowPvP(this.allowsPvP());
        storm.setStormArrowType(this.getStormArrowType());
        if (this.getStormArrowType() == StormType.BLIZZARD) {
            storm.setAmplifier(this.getAmplifier());
            storm.setSlowDuration(this.getSlowDuration());
            storm.setFrostbiteDuration(this.getFrostbiteDuration());
            storm.setFrostbiteChance(this.getFrostbiteChance());
            storm.setIntervalHypothermiaTicks(this.getIntervalHypothermiaTicks());
        }
        this.f_19853_.m_7967_((Entity)storm);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        super.m_6532_(result);
    }

    protected boolean m_5603_(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        boolean allowPvP = this.allowsPvP();
        return super.m_5603_(entity) && (!(entity instanceof Player) || allowPvP) && !(entity instanceof EternalEntity) && !(entity instanceof PetEntity);
    }

    public void m_20321_(boolean pDownwards) {
        super.m_20321_(pDownwards);
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.grounded ? null : super.m_6351_(pStartVec, pEndVec);
    }

    public Packet<?> m_5654_() {
        return super.m_5654_();
    }

    protected void m_5790_(EntityHitResult pResult) {
    }

    protected void m_7761_(LivingEntity pLiving) {
        super.m_7761_(pLiving);
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        super.m_8060_(p_36755_);
    }

    protected boolean m_142470_(Player p_150196_) {
        return false;
    }

    protected ItemStack m_7941_() {
        return null;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11685_;
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        if (pSound == this.m_7239_()) {
            return;
        }
        super.m_5496_(pSound, pVolume, pPitch);
    }

    public void m_6123_(Player pEntity) {
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        Entity entity = this.f_19853_.m_6815_(pPacket.m_131509_());
        if (entity != null) {
            this.m_5602_(entity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.grounded = pCompound.m_128471_("Grounded");
        if (pCompound.m_128441_("type")) {
            this.setStormArrowType(pCompound.m_128451_("type"));
        }
        if (pCompound.m_128441_("slowDuration")) {
            this.slowDuration = pCompound.m_128451_("slowDuration");
        }
        if (pCompound.m_128441_("frostbiteDuration")) {
            this.frostbiteDuration = pCompound.m_128451_("frostbiteDuration");
        }
        if (pCompound.m_128441_("amplifier")) {
            this.amplifier = pCompound.m_128451_("amplifier");
        }
        if (pCompound.m_128441_("intervalHypothermiaTicks")) {
            this.intervalHypothermiaTicks = pCompound.m_128451_("intervalHypothermiaTicks");
        }
        if (pCompound.m_128441_("frostbiteChance")) {
            this.frostbiteChance = pCompound.m_128457_("frostbiteChance");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Grounded", this.grounded);
        pCompound.m_128405_("type", this.getStormArrowType().ordinal());
        pCompound.m_128405_("slowDuration", this.slowDuration);
        pCompound.m_128405_("frostbiteDuration", this.frostbiteDuration);
        pCompound.m_128405_("amplifier", this.amplifier);
        pCompound.m_128405_("intervalHypothermiaTicks", this.intervalHypothermiaTicks);
        pCompound.m_128350_("frostbiteChance", this.frostbiteChance);
    }

    protected void m_6901_() {
        ++this.life;
        if (this.life >= 20) {
            this.m_146870_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public static enum StormType {
        BASE,
        BLIZZARD;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static StormType byId(int id) {
            return MiscUtils.getEnumEntry(StormType.class, id);
        }
    }
}

