/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.google.common.collect.Lists;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.mana.Mana;
import iskallia.vault.mana.ManaAction;
import iskallia.vault.network.message.ClientboundHunterPositionsMessage;
import iskallia.vault.network.message.ClientboundSightParticlesFromJavelinMessage;
import iskallia.vault.skill.ability.effect.JavelinAbility;
import iskallia.vault.skill.ability.effect.JavelinPiercingAbility;
import iskallia.vault.skill.ability.effect.JavelinScatterAbility;
import iskallia.vault.skill.ability.effect.JavelinSightAbility;
import iskallia.vault.skill.ability.effect.spi.AbstractJavelinAbility;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.world.data.PlayerAbilitiesData;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public class VaultThrownJavelin
extends AbstractArrow {
    private static final EntityDataAccessor<Float> ID_DAMAGE = SynchedEntityData.m_135353_(VaultThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> THROWER_UUID = SynchedEntityData.m_135353_(VaultThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> ID_TYPE = SynchedEntityData.m_135353_(VaultThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(VaultThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ID_BOUNCES = SynchedEntityData.m_135353_(VaultThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_GHOST = SynchedEntityData.m_135353_(VaultThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALLOW_PVP = SynchedEntityData.m_135353_(VaultThrownJavelin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static int MAX_AGE = 120;
    private boolean grounded = false;
    private boolean hasHitBlock = false;
    private boolean maxPierced = false;
    private int life;
    public Vec3 prevDeltaMovement = new Vec3(0.0, 0.0, 0.0);
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    private LivingEntity thrower = null;
    private int bounceCount = 0;
    private static ArrayAdapter<TilePredicate> KEYS = Adapters.ofArray(TilePredicate[]::new, Adapters.TILE_PREDICATE);

    public VaultThrownJavelin(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public VaultThrownJavelin(Level level, LivingEntity thrower) {
        super(ModEntities.THROWN_JAVELIN, thrower, level);
        this.thrower = thrower;
        this.f_19804_.m_135381_(THROWER_UUID, Optional.of(thrower.m_142081_()));
    }

    public void setType(int id) {
        this.setType(JavelinType.byId(id));
    }

    public void setType(JavelinType type) {
        this.f_19804_.m_135381_(ID_TYPE, (Object)type.ordinal());
    }

    public JavelinType getJavelinType() {
        return JavelinType.byId((Integer)this.f_19804_.m_135370_(ID_TYPE));
    }

    public boolean getIsGhost() {
        return (Boolean)this.f_19804_.m_135370_(IS_GHOST);
    }

    public void setIsGhost() {
        this.f_19804_.m_135381_(IS_GHOST, (Object)true);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(ID_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setAllowPvP(boolean allow) {
        this.f_19804_.m_135381_(ALLOW_PVP, (Object)allow);
    }

    public boolean allowsPvP() {
        return (Boolean)this.f_19804_.m_135370_(ALLOW_PVP);
    }

    public VaultThrownJavelin createBouncingJavelin(Level level, LivingEntity thrower, int bounceCount) {
        if (thrower == null) {
            return null;
        }
        VaultThrownJavelin javelin = new VaultThrownJavelin(level, thrower);
        javelin.bounceCount = bounceCount;
        javelin.f_19804_.m_135381_(ID_BOUNCES, (Object)bounceCount);
        javelin.f_19804_.m_135381_(IS_GHOST, (Object)((Boolean)this.f_19804_.m_135370_(IS_GHOST)));
        javelin.f_19804_.m_135381_(ALLOW_PVP, (Object)((Boolean)this.f_19804_.m_135370_(ALLOW_PVP)));
        javelin.piercingIgnoreEntityIds = this.piercingIgnoreEntityIds;
        javelin.piercedAndKilledEntities = this.piercedAndKilledEntities;
        javelin.maxPierced = this.maxPierced;
        javelin.setDamage(this.getDamage());
        return javelin;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ID_TYPE, (Object)0);
        this.f_19804_.m_135372_(ID_BOUNCES, (Object)0);
        this.f_19804_.m_135372_(IS_GHOST, (Object)false);
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(THROWER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ALLOW_PVP, (Object)false);
    }

    public byte m_36796_() {
        Player player;
        if (((Optional)this.f_19804_.m_135370_(THROWER_UUID)).isPresent() && (player = this.f_19853_.m_46003_((UUID)((Optional)this.f_19804_.m_135370_(THROWER_UUID)).get())) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbilityTree abilities = PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities((Player)serverPlayer);
            Iterator<AbstractJavelinAbility> iterator = abilities.getAll(JavelinPiercingAbility.class, Skill::isUnlocked).iterator();
            if (iterator.hasNext()) {
                JavelinPiercingAbility ability = iterator.next();
                return (byte)ability.getPiercing();
            }
            iterator = abilities.getAll(JavelinScatterAbility.class, Skill::isUnlocked).iterator();
            if (iterator.hasNext()) {
                JavelinScatterAbility ability = (JavelinScatterAbility)iterator.next();
                return (byte)ability.getPiercing();
            }
        }
        return 0;
    }

    public UUID getThrowerUUID() {
        if (((Optional)this.f_19804_.m_135370_(THROWER_UUID)).isPresent()) {
            return (UUID)((Optional)this.f_19804_.m_135370_(THROWER_UUID)).get();
        }
        return null;
    }

    public Player getThrower() {
        if (((Optional)this.f_19804_.m_135370_(THROWER_UUID)).isPresent()) {
            return this.f_19853_.m_46003_((UUID)((Optional)this.f_19804_.m_135370_(THROWER_UUID)).get());
        }
        return null;
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public static boolean hasLineOfSight(Entity p_147185_, Player thrower) {
        if (p_147185_.f_19853_ != thrower.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(thrower.m_20185_(), thrower.m_20188_(), thrower.m_20189_());
        Vec3 vec31 = new Vec3(p_147185_.m_20185_(), p_147185_.m_20188_(), p_147185_.m_20189_());
        double theta = Math.atan2(p_147185_.m_20189_() - thrower.m_20189_(), p_147185_.m_20185_() - thrower.m_20185_());
        double angle1 = Math.toDegrees(theta - Math.toRadians(90.0));
        double angle2 = thrower.m_146908_();
        double diff = (angle2 - angle1 + 180.0) % 360.0 - 180.0;
        diff = Math.abs(diff < -180.0 ? diff + 360.0 : diff);
        if (diff > 75.0) {
            return false;
        }
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return thrower.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)thrower)).m_6662_() == HitResult.Type.MISS;
    }

    private void startFalling() {
        this.f_36703_ = false;
        Vec3 vec3 = this.m_20184_();
        this.m_20256_(vec3.m_82542_((double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f)));
        this.life = 0;
    }

    private boolean shouldFall() {
        return this.f_36703_ && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (this.f_36704_ > 4) {
            this.grounded = true;
        }
        if (this.f_19853_.m_5776_() && !this.grounded && (this.f_19797_ > 1 || (Integer)this.f_19804_.m_135370_(ID_BOUNCES) > 0)) {
            this.particleTrail();
        }
        this.prevDeltaMovement = this.m_20184_();
        boolean flag = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_142538_())).m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.f_36696_ != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.f_19853_.f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            Vec3 vec33;
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_146910_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                        this.m_8060_(hitresult);
                        this.f_19812_ = true;
                    }
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_37282_();
                    boolean allowPvP = this.allowsPvP();
                    if (!allowPvP && entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(VaultThrownJavelin.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(VaultThrownJavelin.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            float f1 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f2 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.m_6882_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
        if (!this.f_37246_) {
            this.f_37246_ = this.checkLeftOwner();
        }
        super.m_6075_();
    }

    private boolean checkLeftOwner() {
        Entity entity = this.m_37282_();
        if (entity != null) {
            for (Entity entity1 : this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), p_37272_ -> !p_37272_.m_5833_() && p_37272_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    public int getBounceMax() {
        ServerPlayer player;
        AbilityTree abilities;
        Iterator<JavelinScatterAbility> iterator;
        LivingEntity livingEntity = this.thrower;
        if (livingEntity instanceof ServerPlayer && (iterator = (abilities = PlayerAbilitiesData.get((player = (ServerPlayer)livingEntity).m_183503_()).getAbilities((Player)player)).getAll(JavelinScatterAbility.class, Skill::isUnlocked).iterator()).hasNext()) {
            JavelinScatterAbility ability = iterator.next();
            return (byte)ability.getNumberOfBounces();
        }
        return 3;
    }

    public int getNumberOfJavelins() {
        ServerPlayer player;
        AbilityTree abilities;
        Iterator<JavelinScatterAbility> iterator;
        Player player2 = this.getThrower();
        if (player2 instanceof ServerPlayer && (iterator = (abilities = PlayerAbilitiesData.get((player = (ServerPlayer)player2).m_183503_()).getAbilities((Player)player)).getAll(JavelinScatterAbility.class, Skill::isUnlocked).iterator()).hasNext()) {
            JavelinScatterAbility ability = iterator.next();
            return (byte)ability.getNumberOfJavelins();
        }
        return 3;
    }

    public int getSightRadius() {
        ServerPlayer player;
        AbilityTree abilities;
        Iterator<JavelinSightAbility> iterator;
        Player player2 = this.getThrower();
        if (player2 instanceof ServerPlayer && (iterator = (abilities = PlayerAbilitiesData.get((player = (ServerPlayer)player2).m_183503_()).getAbilities((Player)player)).getAll(JavelinSightAbility.class, Skill::isUnlocked).iterator()).hasNext()) {
            JavelinSightAbility ability = iterator.next();
            return Math.round(ability.getRadius((Entity)player));
        }
        return 10;
    }

    public int getSightDuration() {
        ServerPlayer player;
        AbilityTree abilities;
        Iterator<JavelinSightAbility> iterator;
        Player player2 = this.getThrower();
        if (player2 instanceof ServerPlayer && (iterator = (abilities = PlayerAbilitiesData.get((player = (ServerPlayer)player2).m_183503_()).getAbilities((Player)player)).getAll(JavelinSightAbility.class, Skill::isUnlocked).iterator()).hasNext()) {
            JavelinSightAbility ability = iterator.next();
            return ability.getEffectDuration((LivingEntity)player);
        }
        return 40;
    }

    public float getKnockbackValue() {
        ServerPlayer player;
        AbilityTree abilities;
        Iterator<JavelinAbility> iterator;
        Player player2 = this.getThrower();
        if (player2 instanceof ServerPlayer && (iterator = (abilities = PlayerAbilitiesData.get((player = (ServerPlayer)player2).m_183503_()).getAbilities((Player)player)).getAll(JavelinAbility.class, Skill::isUnlocked).iterator()).hasNext()) {
            JavelinAbility ability = iterator.next();
            return ability.getKnockback();
        }
        return 0.0f;
    }

    public void ricochet(Vec3 normal, int numRicochets, Level world) {
        Vec3 motion = this.prevDeltaMovement;
        for (int i = 0; i < numRicochets; ++i) {
            double dot = motion.m_82526_(normal) * 1.5;
            Vec3 reflect = motion.m_82546_(normal.m_82559_(new Vec3(dot, dot, dot))).m_82520_(0.0, (double)0.15f, 0.0);
            float randomFactor = 0.15f;
            float angle = (float)i / (float)numRicochets * 360.0f;
            Vec3 direction = new Vec3(Math.cos(Math.toRadians(angle)) / 5.0, (double)0.15f, Math.sin(Math.toRadians(angle)) / 5.0).m_82541_();
            float pitch = (float)((double)randomFactor * (Math.random() - 0.5)) * 2.0f;
            float yaw = (float)((double)randomFactor * (Math.random() - 0.5)) * 2.0f;
            float roll = (float)((double)randomFactor * (Math.random() - 0.5)) * 2.0f;
            Vec3 result = direction.m_82490_(0.5).m_82549_(reflect).m_82541_();
            result = result.m_82496_(pitch).m_82524_(yaw).m_82535_(Math.abs(roll));
            VaultThrownJavelin thrownJavelin = this.createBouncingJavelin(world, (LivingEntity)this.getThrower(), this.bounceCount + 1);
            if (thrownJavelin == null) {
                return;
            }
            thrownJavelin.m_6034_(this.m_20182_().m_7096_() + result.m_82541_().f_82479_ / 5.0, this.m_20182_().m_7098_() + result.m_82541_().f_82480_ / 5.0, this.m_20182_().m_7094_() + result.m_82541_().f_82481_ / 5.0);
            thrownJavelin.m_20256_(result);
            double d0 = result.m_165924_();
            thrownJavelin.f_19860_ = (float)(Mth.m_14136_((double)result.f_82480_, (double)d0) * 57.2957763671875);
            thrownJavelin.f_19859_ = (float)(Mth.m_14136_((double)result.f_82479_, (double)result.f_82481_) * 57.2957763671875);
            thrownJavelin.m_37283_();
            thrownJavelin.setType(this.getJavelinType().ordinal());
            thrownJavelin.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            thrownJavelin.f_19797_ = this.f_19797_;
            world.m_7967_((Entity)thrownJavelin);
        }
    }

    private void particleTrail() {
        ParticleEngine pm = Minecraft.m_91087_().f_91061_;
        Vec3 offset = new Vec3(this.f_19796_.nextDouble() / 25.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), 0.0, this.f_19796_.nextDouble() / 25.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1));
        Vec3 direction = this.m_20184_().m_82541_().m_82490_((double)0.15f);
        pm.m_107370_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().f_82479_ + offset.f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_ + offset.f_82481_, direction.f_82479_, direction.f_82480_, direction.f_82481_);
    }

    private void ricochetSide(float damageMult) {
        VaultThrownJavelin ricochet;
        Vec3 motion = this.m_20184_();
        Vec3 side = motion.m_82537_(new Vec3(0.0, 1.0, 0.0));
        side = side.m_82556_() < 1.0E-5 ? new Vec3(1.0, 0.0, 0.0).m_82490_(motion.m_82553_()) : side.m_82541_().m_82490_(motion.m_82553_());
        if (this.f_19796_.nextBoolean()) {
            side = side.m_82490_(-1.0);
        }
        if ((ricochet = this.createBouncingJavelin(this.f_19853_, (LivingEntity)this.getThrower(), this.bounceCount)) == null) {
            return;
        }
        ricochet.m_146884_(this.m_20182_());
        ricochet.m_20256_(side);
        double d0 = side.m_165924_();
        ricochet.f_19860_ = (float)(Mth.m_14136_((double)side.f_82480_, (double)d0) * 57.2957763671875);
        ricochet.f_19859_ = (float)(Mth.m_14136_((double)side.f_82479_, (double)side.f_82481_) * 57.2957763671875);
        ricochet.m_37283_();
        ricochet.setType(this.getJavelinType().ordinal());
        ricochet.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        ricochet.f_19797_ = this.f_19797_;
        ricochet.setDamage(this.getDamage() * damageMult);
        this.f_19853_.m_7967_((Entity)ricochet);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected boolean m_5603_(Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.m_20147_()) {
            return false;
        }
        boolean allowPvP = this.allowsPvP();
        return !(!super.m_5603_(entity) || this.piercingIgnoreEntityIds != null && this.piercingIgnoreEntityIds.contains(entity.m_142049_()) || entity instanceof Player && !allowPvP || entity instanceof EternalEntity || entity instanceof PetEntity);
    }

    public void m_20321_(boolean pDownwards) {
        super.m_20321_(pDownwards);
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.grounded || this.maxPierced ? null : super.m_6351_(pStartVec, pEndVec);
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        Player player;
        LivingEntity livingentity;
        Player entity1;
        if (this.maxPierced || this.grounded) {
            return;
        }
        Entity entity = pResult.m_82443_();
        if (entity.equals((Object)(entity1 = this.getThrower()))) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity2 = (LivingEntity)entity;
            if (this.m_36796_() > 0) {
                if (this.piercingIgnoreEntityIds == null) {
                    this.piercingIgnoreEntityIds = new IntOpenHashSet(30);
                }
                if (this.piercedAndKilledEntities == null) {
                    this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)30);
                }
                if (this.piercingIgnoreEntityIds.size() >= this.m_36796_() + 1) {
                    this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
                    this.maxPierced = true;
                    return;
                }
                if (!this.piercingIgnoreEntityIds.contains(entity.m_142049_())) {
                    this.piercingIgnoreEntityIds.add(entity.m_142049_());
                }
            } else {
                this.maxPierced = true;
            }
        }
        SoundEvent soundevent = SoundEvents.f_12514_;
        ActiveFlags.IS_JAVELIN_ATTACKING.runIfNotSet(() -> this.lambda$onHitEntity$3((Entity)entity1, entity));
        if (!entity.m_6084_() && this.piercedAndKilledEntities != null && entity instanceof LivingEntity && !this.piercedAndKilledEntities.contains(livingentity = (LivingEntity)entity)) {
            this.piercedAndKilledEntities.add((Entity)livingentity);
        }
        if (!this.maxPierced && this.getJavelinType() == JavelinType.PIERCING && (player = this.getThrower()) instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            EtchingHelper.getEtchings((LivingEntity)sPlayer, EtchingGearAttributes.PIERCING_JAVELIN_RICOCHET).stream().findFirst().ifPresent(stack -> this.ricochetSide(((Float)stack.getValue()).floatValue()));
        }
        this.m_5496_(soundevent, 1.0f, 0.75f);
    }

    protected void m_7761_(LivingEntity pLiving) {
        super.m_7761_(pLiving);
        pLiving.f_19802_ = 0;
        if (this.getJavelinType() == JavelinType.BASE) {
            EntityHelper.knockbackIgnoreResist(pLiving, (LivingEntity)this.getThrower(), this.getKnockbackValue());
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (this.bounceCount >= this.getBounceMax() || this.thrower == null) {
            return;
        }
        BlockPos blockPos = result.m_82425_();
        BlockState state = this.f_19853_.m_8055_(blockPos);
        if (state.m_60767_() != Material.f_76296_) {
            Player player;
            Vec3 motion = this.prevDeltaMovement;
            if (this.getJavelinType() == JavelinType.SIGHT && !this.hasHitBlock && (player = this.getThrower()) instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                float radius = this.getSightRadius();
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundSightParticlesFromJavelinMessage(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, this.getSightRadius(), 0.0, 0.0));
                ServerLevel sLevel = sPlayer.m_183503_();
                BlockPos offset = this.m_142538_();
                int spacing = 5;
                for (int delay = 0; delay < 60 / spacing; ++delay) {
                    float rad = radius * Math.min(1.0f, (float)(delay + delay) / (60.0f / (float)spacing));
                    ServerScheduler.INSTANCE.schedule(delay * spacing, () -> {
                        List<HunterAbility.HighlightPosition> positions = HunterAbility.selectPositions(sLevel, offset, (double)rad);
                        ModNetwork.CHANNEL.sendTo((Object)new ClientboundHunterPositionsMessage(positions, this.getSightDuration()), sPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                        List nearbyEntities = sLevel.m_6443_(LivingEntity.class, AABBHelper.create(this.m_20182_(), rad), p_186450_ -> true);
                        for (LivingEntity nearbyEntity : nearbyEntities) {
                            nearbyEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, this.getSightDuration(), 0, true, false));
                        }
                    });
                }
            }
            if (this.getJavelinType() == JavelinType.SCATTER) {
                Direction face = result.m_82434_();
                Vec3 normal = new Vec3((double)face.m_122436_().m_123341_(), (double)face.m_122436_().m_123342_(), (double)face.m_122436_().m_123343_());
                if (this.bounceCount > 0) {
                    double dot = motion.m_82526_(normal) * 1.5;
                    Vec3 reflect = motion.m_82546_(normal.m_82559_(new Vec3(dot, dot, dot))).m_82520_(0.0, (double)0.1f, 0.0);
                    VaultThrownJavelin thrownJavelin = this.createBouncingJavelin(this.f_19853_, this.thrower, this.bounceCount + 1);
                    if (thrownJavelin == null) {
                        return;
                    }
                    thrownJavelin.m_6034_(result.m_82450_().m_7096_() + reflect.m_82541_().f_82479_ / 5.0, result.m_82450_().m_7098_() + reflect.m_82541_().f_82480_ / 5.0, result.m_82450_().m_7094_() + reflect.m_82541_().f_82481_ / 5.0);
                    thrownJavelin.m_20256_(reflect);
                    double d0 = reflect.m_165924_();
                    thrownJavelin.f_19860_ = (float)(Mth.m_14136_((double)reflect.f_82480_, (double)d0) * 57.2957763671875);
                    thrownJavelin.f_19859_ = (float)(Mth.m_14136_((double)reflect.f_82479_, (double)reflect.f_82481_) * 57.2957763671875);
                    thrownJavelin.m_37283_();
                    thrownJavelin.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                    thrownJavelin.setType(this.getJavelinType().ordinal());
                    thrownJavelin.f_19797_ = this.f_19797_;
                    this.f_19853_.m_7967_((Entity)thrownJavelin);
                } else {
                    this.ricochet(normal, this.getNumberOfJavelins(), this.f_19853_);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.resetPiercedEntities();
        this.hasHitBlock = true;
    }

    protected boolean m_142470_(Player p_150196_) {
        return super.m_142470_(p_150196_) || this.m_36797_() && this.m_150171_((Entity)p_150196_) && p_150196_.m_150109_().m_36054_(this.m_7941_());
    }

    protected ItemStack m_7941_() {
        return null;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_37282_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.grounded = pCompound.m_128471_("Grounded");
        this.hasHitBlock = pCompound.m_128471_("HasHitBlock");
        if (pCompound.m_128441_("Damage")) {
            this.setDamage(pCompound.m_128457_("Damage"));
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Grounded", this.grounded);
        pCompound.m_128379_("HasHitBlock", this.hasHitBlock);
        pCompound.m_128350_("Damage", this.getDamage());
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
        this.life = age;
    }

    public void m_6901_() {
        if (this.grounded) {
            this.setAge(this.life + 1);
            if (this.life >= MAX_AGE) {
                this.m_146870_();
            }
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    private /* synthetic */ void lambda$onHitEntity$3(Entity entity1, Entity entity) {
        Player player;
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        UUID thrower = this.getThrowerUUID();
        if (thrower != null && (player = this.f_19853_.m_46003_(thrower)) != null) {
            damagesource = DamageSource.m_19344_((Player)player);
        }
        if (entity.m_6469_(damagesource, this.getDamage())) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                this.m_7761_(livingentity1);
                if (this.getJavelinType() == JavelinType.SCATTER && entity1 instanceof ServerPlayer) {
                    ServerPlayer sPlayer = (ServerPlayer)entity1;
                    EtchingHelper.getEtchings((LivingEntity)sPlayer, EtchingGearAttributes.SCATTER_MANA).stream().findFirst().ifPresent(stack -> {
                        int mana = (Integer)stack.getValue();
                        if (mana > 0) {
                            Mana.increase((Player)sPlayer, ManaAction.PLAYER_ACTION, mana);
                        }
                    });
                }
            }
        }
    }

    public static enum JavelinType {
        BASE,
        SCATTER,
        PIERCING,
        SIGHT;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static JavelinType byId(int id) {
            return MiscUtils.getEnumEntry(JavelinType.class, id);
        }
    }
}

