/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import iskallia.vault.entity.champion.OnHitApplyPotionAffix;
import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import iskallia.vault.init.ModEffects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EliteDrownedEntity
extends Drowned
implements EliteModifierImmunity {
    private final OnHitApplyPotionAffix manaStealOnHit = new OnHitApplyPotionAffix("Mana Stealing", ModEffects.MANA_STEAL, 40, 1, 1.0f);
    private long lastRangedAttackTime;
    private Drowned.DrownedAttackGoal meleeAttack;

    public EliteDrownedEntity(EntityType<? extends Drowned> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(1, (Goal)new PutTridentInHandGoal(this, 80, 120));
        this.f_21345_.m_25352_(2, (Goal)new Drowned.DrownedTridentAttackGoal((RangedAttackMob)this, 1.0, 20, 10.0f));
        this.meleeAttack = new Drowned.DrownedAttackGoal((Drowned)this, 1.0, false);
        this.f_21345_.m_25352_(3, (Goal)this.meleeAttack);
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Drowned.class}).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EliteDrownedEntity)this).m_32395_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        if (potionEffect.m_19544_() == ModEffects.GLACIAL_SHATTER) {
            return false;
        }
        return super.m_7301_(potionEffect);
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof EliteDrownedEntity) {
            EliteDrownedEntity eliteDrowned = (EliteDrownedEntity)entity;
            entity = event.getEntityLiving();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                eliteDrowned.manaStealOnHit.onChampionHitPlayer((LivingEntity)eliteDrowned, player, event.getAmount());
            }
        }
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        super.m_6504_(pTarget, pDistanceFactor);
        this.lastRangedAttackTime = this.f_19853_.m_46467_();
    }

    static class PutTridentInHandGoal
    extends Goal {
        private final EliteDrownedEntity drowned;
        private final int triggerIntervalMin;
        private final int triggerIntervalMax;
        private long nextTriggerTime;
        private boolean putTridentInHand;

        public PutTridentInHandGoal(EliteDrownedEntity drowned, int triggerIntervalMin, int triggerIntervalMax) {
            this.drowned = drowned;
            this.triggerIntervalMin = triggerIntervalMin;
            this.triggerIntervalMax = triggerIntervalMax;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8056_() {
            this.nextTriggerTime = this.drowned.f_19853_.m_46467_() + (long)this.drowned.m_21187_().nextInt(this.triggerIntervalMax - this.triggerIntervalMin) + (long)this.triggerIntervalMin;
        }

        public void m_8037_() {
            if (!this.putTridentInHand && this.nextTriggerTime <= this.drowned.f_19853_.m_46467_()) {
                this.putTridentInHand = true;
                this.drowned.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42713_));
                this.drowned.meleeAttack.m_8041_();
            } else if (this.putTridentInHand && this.drowned.lastRangedAttackTime > this.nextTriggerTime) {
                this.putTridentInHand = false;
                this.drowned.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                this.nextTriggerTime = this.drowned.f_19853_.m_46467_() + (long)this.drowned.m_21187_().nextInt(this.triggerIntervalMax - this.triggerIntervalMin) + (long)this.triggerIntervalMin;
            }
        }
    }
}

