/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import iskallia.vault.entity.entity.elite.EndervexEntity;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class EliteEndermanEntity
extends EnderMan
implements EliteModifierImmunity {
    public EliteEndermanEntity(EntityType<EliteEndermanEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EndermanFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new EndermanLeaveBlockGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new EndermanLookForPlayerGoal(this, arg_0 -> ((EliteEndermanEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        if (potionEffect.m_19544_() == ModEffects.GLACIAL_SHATTER) {
            return false;
        }
        return super.m_7301_(potionEffect);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        EndervexEntity endervex;
        if (this.f_19853_.f_46443_) {
            return super.m_6469_(pSource, pAmount);
        }
        int prevOrnamentCount = this.getVisibleOrnamentCount();
        float prevHealth = this.m_21223_();
        boolean hurt = super.m_6469_(pSource, pAmount);
        int ornamentCount = this.getVisibleOrnamentCount();
        float health = this.m_21223_();
        if (prevOrnamentCount != ornamentCount && health < prevHealth && (endervex = (EndervexEntity)ModEntities.ENDERVEX.m_20615_(this.f_19853_)) != null) {
            if (this.m_21532_()) {
                endervex.m_21530_();
            }
            endervex.m_20256_(new Vec3(0.0, 0.35, 0.0));
            endervex.m_20219_(this.m_20182_());
            this.f_19853_.m_7967_((Entity)endervex);
            endervex.m_5496_(SoundEvents.f_11868_, 10.0f, 0.95f + endervex.m_21187_().nextFloat() * 0.1f);
            endervex.m_33994_((Mob)this);
        }
        return hurt;
    }

    public static int getVisibleOrnamentCount(double healthRate) {
        if (healthRate > 0.75) {
            return 3;
        }
        if (healthRate > 0.5) {
            return 2;
        }
        if (healthRate > 0.25) {
            return 1;
        }
        return 0;
    }

    public int getVisibleOrnamentCount() {
        return EliteEndermanEntity.getVisibleOrnamentCount(this.m_21223_() / this.m_21233_());
    }

    boolean m_32534_(Player pPlayer) {
        ItemStack itemstack = (ItemStack)pPlayer.m_150109_().f_35975_.get(3);
        if (ForgeHooks.shouldSuppressEnderManAnger((EnderMan)this, (Player)pPlayer, (ItemStack)itemstack)) {
            return false;
        }
        Vec3 vec3 = pPlayer.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - pPlayer.m_20185_(), this.m_20188_() - pPlayer.m_20188_(), this.m_20189_() - pPlayer.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? pPlayer.m_142582_((Entity)this) : false;
    }

    boolean m_32500_(Entity p_32501_) {
        Vec3 vec3 = new Vec3(this.m_20185_() - p_32501_.m_20185_(), this.m_20227_(0.5) - p_32501_.m_20188_(), this.m_20189_() - p_32501_.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.nextInt(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    static class EndermanFreezeWhenLookedAt
    extends Goal {
        private final EliteEndermanEntity enderman;
        @Nullable
        private LivingEntity target;

        public EndermanFreezeWhenLookedAt(EliteEndermanEntity p_32550_) {
            this.enderman = p_32550_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.enderman.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.m_32534_((Player)this.target);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.enderman.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }

    static class EndermanLeaveBlockGoal
    extends Goal {
        private final EnderMan enderman;

        public EndermanLeaveBlockGoal(EnderMan p_32556_) {
            this.enderman = p_32556_;
        }

        public boolean m_8036_() {
            if (this.enderman.m_32530_() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.enderman.f_19853_, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.m_21187_().nextInt(EndermanLeaveBlockGoal.m_186073_((int)2000)) == 0;
        }

        public void m_8037_() {
            Random random = this.enderman.m_21187_();
            Level level = this.enderman.f_19853_;
            int i = Mth.m_14107_((double)(this.enderman.m_20185_() - 1.0 + random.nextDouble() * 2.0));
            int j = Mth.m_14107_((double)(this.enderman.m_20186_() + random.nextDouble() * 2.0));
            int k = Mth.m_14107_((double)(this.enderman.m_20189_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = level.m_8055_(blockpos);
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate1 = level.m_8055_(blockpos1);
            BlockState blockstate2 = this.enderman.m_32530_();
            if (blockstate2 != null && this.canPlaceBlock(level, blockpos, blockstate2 = Block.m_49931_((BlockState)blockstate2, (LevelAccessor)this.enderman.f_19853_, (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                level.m_7731_(blockpos, blockstate2, 3);
                level.m_142346_((Entity)this.enderman, GameEvent.f_157797_, blockpos);
                this.enderman.m_32521_((BlockState)null);
            }
        }

        private boolean canPlaceBlock(Level p_32559_, BlockPos p_32560_, BlockState p_32561_, BlockState p_32562_, BlockState p_32563_, BlockPos p_32564_) {
            return p_32562_.m_60795_() && !p_32563_.m_60795_() && !p_32563_.m_60713_(Blocks.f_50752_) && !p_32563_.m_204336_(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST) && p_32563_.m_60838_((BlockGetter)p_32559_, p_32564_) && p_32561_.m_60710_((LevelReader)p_32559_, p_32560_) && p_32559_.m_45933_((Entity)this.enderman, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)p_32560_))).isEmpty();
        }
    }

    static class EndermanLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EliteEndermanEntity enderman;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public EndermanLookForPlayerGoal(EliteEndermanEntity p_32573_, @Nullable Predicate<LivingEntity> p_32574_) {
            super((Mob)p_32573_, Player.class, 10, false, false, p_32574_);
            this.enderman = p_32573_;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_32578_ -> p_32573_.m_32534_((Player)p_32578_));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderman.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.teleportTime = 0;
            this.enderman.m_32533_();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.enderman.m_32534_(this.pendingTarget)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.m_32534_((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.m_32529_();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= this.m_183277_(30) && this.enderman.m_32500_((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

