/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import iskallia.vault.entity.entity.elite.ScarabEntity;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EliteHuskEntity
extends Husk
implements EliteModifierImmunity {
    protected int scarabSpawnCooldownTicks = 60;

    public EliteHuskEntity(EntityType<? extends Husk> entityType, Level world) {
        super(entityType, world);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            BlockState blockState = new BlockState(Blocks.f_49992_, ImmutableMap.of(), MapCodec.unit((Object)this.m_20075_()));
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, blockState), this.m_20208_(0.9), this.m_20186_() + (double)1.9f, this.m_20262_(0.9), 0.0, 0.01, 0.0);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        this.scarabSpawnCooldownTicks = Math.max(this.scarabSpawnCooldownTicks - 1, 0);
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        if (potionEffect.m_19544_() == ModEffects.GLACIAL_SHATTER) {
            return false;
        }
        return super.m_7301_(potionEffect);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (this.f_19853_.f_46443_) {
            return hurt;
        }
        if (hurt && this.scarabSpawnCooldownTicks == 0) {
            this.scarabSpawnCooldownTicks = this.f_19796_.nextInt(60, 100);
            int count = this.f_19796_.nextInt(2, 4);
            for (int i = 0; i < count; ++i) {
                ScarabEntity scarab = (ScarabEntity)ModEntities.SCARAB.m_20615_(this.f_19853_);
                if (scarab == null) continue;
                if (this.m_21532_()) {
                    scarab.m_21530_();
                }
                Vec3 offset = new Vec3(1.0, 0.0, 0.0).m_82524_((float)((double)i * (Math.PI * 2) / (double)count));
                scarab.m_20256_(offset.m_82520_(0.0, 1.5, 0.0));
                scarab.m_20219_(this.m_20182_());
                scarab.setOwner(this.m_142081_());
                this.f_19853_.m_7967_((Entity)scarab);
                scarab.m_5496_(SoundEvents.f_11868_, 10.0f, 0.95f + scarab.m_21187_().nextFloat() * 0.1f);
            }
        }
        return hurt;
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        this.f_19853_.m_45976_(ScarabEntity.class, this.m_142469_().m_82400_(128.0)).forEach(e -> e.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19380_().m_19381_().m_19382_(), e.m_21223_()));
    }
}

