/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import com.google.common.base.Preconditions;
import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import iskallia.vault.init.ModAttributes;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;

public class EliteSkeleton
extends Skeleton
implements EliteModifierImmunity {
    private long lastAttackTime = 0L;

    public EliteSkeleton(EntityType<? extends Skeleton> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new TurnVanishFuryGoal(this, 100, 300));
    }

    public boolean m_7327_(Entity entity) {
        boolean result = super.m_7327_(entity);
        if (result) {
            this.lastAttackTime = this.f_19853_.m_46467_();
        }
        return result;
    }

    private static class TurnVanishFuryGoal
    extends Goal {
        private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier("Speed modifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        private static final AttributeModifier CRIT_CHANCE_MODIFIER = new AttributeModifier("Crit chance modifier", 1.0, AttributeModifier.Operation.ADDITION);
        private final EliteSkeleton skeleton;
        private final int vanishIntervalMin;
        private final int vanishIntervalMax;
        private int cooldown;
        private boolean removedModifiers = true;
        private long lastVanishTime = 0L;

        public TurnVanishFuryGoal(EliteSkeleton skeleton, int vanishIntervalMin, int vanishIntervalMax) {
            this.skeleton = skeleton;
            this.vanishIntervalMin = vanishIntervalMin;
            this.vanishIntervalMax = vanishIntervalMax;
            this.cooldown = skeleton.m_21187_().nextInt(vanishIntervalMax - vanishIntervalMin) + vanishIntervalMin;
        }

        public boolean m_8036_() {
            return !this.removedModifiers || this.cooldown-- <= 0;
        }

        public void m_8056_() {
            AttributeInstance critChanceAttribute;
            this.removedModifiers = false;
            this.skeleton.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 100, 0, false, false));
            AttributeMap attributes = this.skeleton.m_21204_();
            AttributeInstance speedAttribute = (AttributeInstance)Preconditions.checkNotNull((Object)attributes.m_22146_(Attributes.f_22279_), (Object)"Elite Skeleton missing movement_speed attribute");
            if (!speedAttribute.m_22109_(SPEED_MODIFIER)) {
                speedAttribute.m_22118_(SPEED_MODIFIER);
            }
            if (!(critChanceAttribute = (AttributeInstance)Preconditions.checkNotNull((Object)attributes.m_22146_(ModAttributes.CRIT_CHANCE), (Object)"Elite Skeleton missing crit_chance attribute")).m_22109_(CRIT_CHANCE_MODIFIER)) {
                critChanceAttribute.m_22118_(CRIT_CHANCE_MODIFIER);
            }
            Random random = this.skeleton.m_21187_();
            this.cooldown = random.nextInt(this.vanishIntervalMax - this.vanishIntervalMin) + this.vanishIntervalMin;
            this.lastVanishTime = this.skeleton.f_19853_.m_46467_();
            Level level = this.skeleton.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x = this.skeleton.m_20185_();
                double y = this.skeleton.m_20186_();
                double z = this.skeleton.m_20189_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x - 0.5, y, z - 0.5, 10, 1.0, 2.0, 1.0, 0.0);
                serverLevel.m_6269_(null, (Entity)this.skeleton, SoundEvents.f_12053_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }

        public void m_8037_() {
            Level level;
            AttributeMap attributes = this.skeleton.m_21204_();
            AttributeInstance critChanceAttribute = (AttributeInstance)Preconditions.checkNotNull((Object)attributes.m_22146_(ModAttributes.CRIT_CHANCE), (Object)"Elite Skeleton missing crit_chance attribute");
            if (this.skeleton.lastAttackTime > this.lastVanishTime && critChanceAttribute.m_22109_(CRIT_CHANCE_MODIFIER)) {
                critChanceAttribute.m_22130_(CRIT_CHANCE_MODIFIER);
            }
            if (this.skeleton.m_21023_(MobEffects.f_19609_) && (level = this.skeleton.m_183503_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnCloudParticles(serverLevel);
            }
            if (!this.skeleton.m_21023_(MobEffects.f_19609_)) {
                critChanceAttribute.m_22130_(CRIT_CHANCE_MODIFIER);
                ((AttributeInstance)Preconditions.checkNotNull((Object)attributes.m_22146_(Attributes.f_22279_), (Object)"Elite Skeleton missing movement_speed attribute")).m_22130_(SPEED_MODIFIER);
                this.removedModifiers = true;
            }
        }

        private void spawnCloudParticles(ServerLevel serverLevel) {
            double x = this.skeleton.m_20185_();
            double y = this.skeleton.m_20186_() + 0.5;
            double z = this.skeleton.m_20189_();
            Random random = this.skeleton.m_21187_();
            for (int i = 0; i < 2; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * 0.5;
                double offsetY = random.nextDouble();
                double offsetZ = (random.nextDouble() - 0.5) * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.01, 0.01, 0.01, 0.01);
            }
        }
    }
}

