/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import iskallia.vault.entity.champion.PotionAuraAffix;
import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import iskallia.vault.init.ModEffects;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EliteWitchEntity
extends Witch
implements EliteModifierImmunity {
    private final PotionAuraAffix manaStealAura = new PotionAuraAffix("Mana Steal Aura", ModEffects.MANA_STEAL, 20, 1, 5, PotionAuraAffix.Target.PLAYER);
    private final PotionAuraAffix poisonAura = new PotionAuraAffix("Poison Aura", MobEffects.f_19614_, 20, 1, 8, PotionAuraAffix.Target.PLAYER);
    private final List<PotionAuraAffix> auras = List.of(this.manaStealAura, this.poisonAura);

    public EliteWitchEntity(EntityType<? extends Witch> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.auras.forEach(aura -> aura.tick((LivingEntity)this));
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        if (potionEffect.m_19544_() == ModEffects.GLACIAL_SHATTER) {
            return false;
        }
        return super.m_7301_(potionEffect);
    }

    public List<PotionAuraAffix> getAuras() {
        return this.auras;
    }

    public void m_6504_(LivingEntity target, float pDistanceFactor) {
        if (!this.m_34161_()) {
            Vec3 vec3 = target.m_20184_();
            double xDiff = target.m_20185_() + vec3.f_82479_ - this.m_20185_();
            double yDiff = target.m_20188_() - (double)1.1f - this.m_20186_();
            double zDiff = target.m_20189_() + vec3.f_82481_ - this.m_20189_();
            double distance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            List<Object> mobEffects = List.of(new MobEffectInstance(MobEffects.f_19602_, 1, Math.max(1, (int)(target.m_21233_() / 20.0f))));
            if (target instanceof Raider) {
                mobEffects = target.m_21223_() <= 4.0f ? Potions.f_43623_.m_43488_() : Potions.f_43587_.m_43488_();
                this.m_6710_(null);
            } else if (this.f_19796_.nextFloat() < 0.5f && !target.m_21023_(MobEffects.f_19610_)) {
                mobEffects = List.of(new MobEffectInstance(MobEffects.f_19610_, 40, 0));
            }
            ThrownPotion thrownpotion = new ThrownPotion(this.f_19853_, (LivingEntity)this);
            ItemStack potionItem = PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), mobEffects);
            potionItem.m_41784_().m_128405_("CustomPotionColor", PotionUtils.m_43564_(mobEffects));
            thrownpotion.m_37446_(potionItem);
            thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
            thrownpotion.m_6686_(xDiff, yDiff + distance * 0.2, zDiff, 0.75f, 8.0f);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.nextFloat() * 0.4f);
            }
            this.f_19853_.m_7967_((Entity)thrownpotion);
        }
    }
}

