/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import iskallia.vault.init.ModEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class EliteWitherSkeleton
extends WitherSkeleton
implements EliteModifierImmunity {
    protected int shootTicks;

    public EliteWitherSkeleton(EntityType<? extends WitherSkeleton> entityType, Level level) {
        super(entityType, level);
        this.shootTicks = this.f_19796_.nextInt(60, 100);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(1.0), this.m_20186_() + (double)2.9f, this.m_20262_(1.0), 0.0, 0.01, 0.0);
        }
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_21195_(MobEffects.f_19615_);
                livingEntity.m_7292_(new MobEffectInstance(ModEffects.CORRUPTION, 300));
            }
            return true;
        }
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            if (this.shootTicks == 0) {
                for (int headIndex = 0; headIndex < 2; ++headIndex) {
                    BlockPos targetPos = target.m_146901_();
                    float healthRate = this.m_21223_() / this.m_21233_();
                    this.performRangedAttack(headIndex, targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), (double)healthRate >= 0.5);
                }
                this.shootTicks = this.f_19796_.nextInt(60, 100);
            } else {
                --this.shootTicks;
            }
        }
    }

    private double getHeadX(int pHead) {
        if (pHead <= 0) {
            return this.m_20185_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return this.m_20185_() + (double)f1 * 1.3;
    }

    private double getHeadY(int pHead) {
        return pHead <= 0 ? this.m_20186_() + 3.0 : this.m_20186_() + 2.2;
    }

    private double getHeadZ(int pHead) {
        if (pHead <= 0) {
            return this.m_20189_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return this.m_20189_() + (double)f1 * 1.3;
    }

    public void m_6504_(@NotNull LivingEntity pTarget, float pDistanceFactor) {
        this.performRangedAttack(0, pTarget);
    }

    private void performRangedAttack(int pHead, LivingEntity pTarget) {
        this.performRangedAttack(pHead, pTarget.m_20185_(), pTarget.m_20186_() + (double)pTarget.m_20192_() * 0.5, pTarget.m_20189_(), pHead == 0 && this.f_19796_.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int pHead, double pX, double pY, double pZ, boolean pInvulnerable) {
        if (!this.m_20067_()) {
            this.f_19853_.m_5898_((Player)null, 1024, this.m_142538_(), 0);
        }
        double d0 = this.getHeadX(pHead);
        double d1 = this.getHeadY(pHead);
        double d2 = this.getHeadZ(pHead);
        double d3 = pX - d0;
        double d4 = pY - d1;
        double d5 = pZ - d2;
        EliteWitherSkull projectile = new EliteWitherSkull(this.f_19853_, (LivingEntity)this, d3, d4, d5);
        projectile.m_5602_((Entity)this);
        if (pInvulnerable) {
            projectile.m_37629_(true);
        }
        projectile.m_20343_(d0, d1, d2);
        this.f_19853_.m_7967_((Entity)projectile);
    }

    public static class EliteWitherSkull
    extends WitherSkull {
        public EliteWitherSkull(Level world, LivingEntity p_37610_, double p_37611_, double p_37612_, double p_37613_) {
            super(world, p_37610_, p_37611_, p_37612_, p_37613_);
        }

        protected void m_6532_(@NotNull HitResult pResult) {
            HitResult.Type hitresult$type = pResult.m_6662_();
            if (hitresult$type == HitResult.Type.ENTITY) {
                this.m_5790_((EntityHitResult)pResult);
            } else if (hitresult$type == HitResult.Type.BLOCK) {
                this.m_8060_((BlockHitResult)pResult);
            }
            if (hitresult$type != HitResult.Type.MISS) {
                this.m_146852_(GameEvent.f_157777_, this.m_37282_());
            }
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, false, Explosion.BlockInteraction.NONE);
                this.m_146870_();
            }
        }

        protected void m_5790_(EntityHitResult pResult) {
            if (!this.f_19853_.f_46443_) {
                boolean wasHurt;
                LivingEntity livingEntity;
                Entity entity = pResult.m_82443_();
                Entity owner = this.m_37282_();
                if (owner instanceof LivingEntity) {
                    livingEntity = (LivingEntity)owner;
                    wasHurt = entity.m_6469_(DamageSource.m_19355_((WitherSkull)this, (Entity)livingEntity), 8.0f);
                    if (wasHurt) {
                        if (entity.m_6084_()) {
                            this.m_19970_(livingEntity, entity);
                        } else {
                            livingEntity.m_5634_(5.0f);
                        }
                    }
                } else {
                    wasHurt = entity.m_6469_(DamageSource.f_19319_, 5.0f);
                }
                if (wasHurt && entity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    livingEntity.m_147207_(new MobEffectInstance(ModEffects.CORRUPTION, 300, 1), this.m_150173_());
                }
            }
        }
    }
}

