/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import iskallia.vault.entity.champion.LeechOnHitAffix;
import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class EliteZombieEntity
extends Zombie
implements EliteModifierImmunity {
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier("Speed modifier", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final LeechOnHitAffix leechOnHit = new LeechOnHitAffix("Leeching", 5.0f);
    private static final int MAX_TOTAL_MINIONS = 30;
    private static final int MAX_MINIONS_PER_SPAWN = 7;
    private static final int SPAWN_RADIUS = 10;
    private static final int MAX_CHALLENGE_RADIUS = 17;
    private static final int NUMBER_OF_SPAWN_TRIES = 5;
    private static final int SPAWN_COOLDOWN_TICKS = 600;
    private static final float SPAWN_CHANCE = 0.1f;
    private Set<UUID> minionIds = new HashSet<UUID>();
    private BlockPos controllerPos;
    private long lastMinionsDiedTime = 0L;
    private boolean hadMinionsLastTick = false;

    public EliteZombieEntity(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        if (potionEffect.m_19544_() == ModEffects.GLACIAL_SHATTER) {
            return false;
        }
        return super.m_7301_(potionEffect);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Level level;
        boolean wasHurt = super.m_6469_(pSource, pAmount);
        if (wasHurt && this.m_21223_() > 0.0f && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19796_.nextFloat() < 0.1f && this.canSpawnMinions()) {
                this.spawnMinions(serverLevel);
            }
        }
        return wasHurt;
    }

    private boolean canSpawnMinions() {
        return !this.isInCooldown() && this.minionIds.size() < 30;
    }

    private boolean isInCooldown() {
        return this.f_19853_.m_46467_() - this.lastMinionsDiedTime < 600L;
    }

    public void m_8119_() {
        ServerLevel serverLevel;
        block5: {
            block4: {
                super.m_8119_();
                Level level = this.f_19853_;
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (this.f_19853_.m_46467_() % 10L == 0L && !this.m_21525_()) break block5;
            }
            return;
        }
        this.checkMinionsAlive(serverLevel);
        if (this.hadMinionsLastTick && this.minionIds.isEmpty()) {
            this.lastMinionsDiedTime = this.f_19853_.m_46467_();
        }
        this.hadMinionsLastTick = !this.minionIds.isEmpty();
        this.applySupportEffects();
    }

    private void applySupportEffects() {
        if (!this.minionIds.isEmpty()) {
            this.m_7292_(new MobEffectInstance(ModEffects.IMMORTALITY, 20, 0, true, false));
        } else {
            this.m_21195_(ModEffects.IMMORTALITY);
        }
        AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
        if (this.minionIds.isEmpty() && movementSpeedAttribute.m_22109_(SPEED_MODIFIER)) {
            movementSpeedAttribute.m_22130_(SPEED_MODIFIER);
        } else if (!this.minionIds.isEmpty() && !movementSpeedAttribute.m_22109_(SPEED_MODIFIER)) {
            movementSpeedAttribute.m_22118_(SPEED_MODIFIER);
        }
    }

    private void spawnMinions(ServerLevel serverLevel) {
        int maxToSpawn = Math.min(30 - this.minionIds.size(), 7);
        int minToSpawn = (int)Math.round((double)maxToSpawn / 4.0);
        int numberToSpawn = minToSpawn + serverLevel.m_5822_().nextInt(maxToSpawn - minToSpawn + 1);
        BlockPos centerPos = this.controllerPos != null ? this.controllerPos : this.m_142538_();
        block0: for (int i = 0; i < numberToSpawn; ++i) {
            for (int j = 0; j < 5; ++j) {
                double angle = this.f_19796_.nextDouble() * Math.PI * 2.0;
                float distance = this.f_19796_.nextFloat() * 10.0f;
                double x = this.m_20185_() + Math.cos(angle) * (double)distance;
                double z = this.m_20189_() + Math.sin(angle) * (double)distance;
                if (this.controllerPos != null) {
                    double xDiff = x - ((double)this.controllerPos.m_123341_() + 0.5);
                    double zDiff = z - ((double)this.controllerPos.m_123343_() + 0.5);
                    if (Math.abs(xDiff) > 17.0 || Math.abs(zDiff) > 17.0) {
                        double magnitude = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                        double normalizedX = xDiff / magnitude;
                        double normalizedZ = zDiff / magnitude;
                        x = (double)this.controllerPos.m_123341_() + 0.5 + normalizedX * 17.0;
                        z = (double)this.controllerPos.m_123343_() + 0.5 + normalizedZ * 17.0;
                    }
                }
                double y = this.m_20186_();
                while (serverLevel.m_8055_(new BlockPos(x, y - 1.0, z)).m_60795_()) {
                    y -= 1.0;
                }
                Zombie raisedZombie = (Zombie)ModEntities.RAISED_ZOMBIE.m_20615_((Level)serverLevel);
                raisedZombie.m_6863_(true);
                raisedZombie.m_6034_(x, y, z);
                if (!serverLevel.m_45786_((Entity)raisedZombie)) continue;
                raisedZombie.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(raisedZombie.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                raisedZombie.m_19880_().add("no_champion");
                serverLevel.m_7967_((Entity)raisedZombie);
                this.minionIds.add(raisedZombie.m_142081_());
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 10, 0.5, 0.5, 0.5, 0.0);
                List list = serverLevel.m_6443_(Chicken.class, this.m_142469_().m_82377_(2.0, 2.0, 2.0), EntitySelector.f_20404_);
                if (!list.isEmpty()) {
                    Chicken chicken = (Chicken)list.get(0);
                    chicken.m_28273_(true);
                    raisedZombie.m_20329_((Entity)chicken);
                    raisedZombie.m_146884_(chicken.m_20182_());
                    continue block0;
                }
                Chicken chicken = (Chicken)ModEntities.RAISED_ZOMBIE_CHICKEN.m_20615_((Level)serverLevel);
                chicken.m_21051_(Attributes.f_22279_).m_22100_(raisedZombie.m_21172_(Attributes.f_22279_) * 1.5);
                chicken.m_7678_(raisedZombie.m_20185_(), raisedZombie.m_20186_(), raisedZombie.m_20189_(), raisedZombie.m_146908_(), 0.0f);
                chicken.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(raisedZombie.m_20097_()), MobSpawnType.JOCKEY, null, null);
                chicken.m_28273_(true);
                raisedZombie.m_20329_((Entity)chicken);
                serverLevel.m_7967_((Entity)chicken);
                continue block0;
            }
        }
    }

    private void checkMinionsAlive(ServerLevel serverLevel) {
        this.minionIds.removeIf(minionId -> serverLevel.m_8791_(minionId) == null);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return null;
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof EliteZombieEntity) {
            EliteZombieEntity eliteZombie = (EliteZombieEntity)entity;
            entity = event.getEntityLiving();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                eliteZombie.leechOnHit.onChampionHitPlayer((LivingEntity)eliteZombie, player, event.getAmount());
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("MinionIds", (Tag)this.minionIds.stream().map(NbtUtils::m_129226_).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
        if (this.controllerPos != null) {
            tag.m_128365_("ControllerPos", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        tag.m_128356_("LastMinionsDiedTime", this.lastMinionsDiedTime);
        tag.m_128379_("HadMinionsLastTick", this.hadMinionsLastTick);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.minionIds.clear();
        tag.m_128437_("MinionIds", 11).forEach(nbt -> this.minionIds.add(NbtUtils.m_129233_((Tag)nbt)));
        if (tag.m_128441_("ControllerPos")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPos"));
        }
        if (tag.m_128441_("LastMinionsDiedTime")) {
            this.lastMinionsDiedTime = tag.m_128454_("LastMinionsDiedTime");
        }
        if (tag.m_128441_("HadMinionsLastTick")) {
            this.hadMinionsLastTick = tag.m_128471_("HadMinionsLastTick");
        }
    }
}

