/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.elite;

import iskallia.vault.entity.entity.elite.EliteModifierImmunity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ScarabEntity
extends FlyingMob
implements IAnimatable,
EliteModifierImmunity {
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(ScarabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    Vec3 moveTargetPoint = Vec3.f_82478_;
    BlockPos anchorPoint = BlockPos.f_121853_;
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    @Nullable
    UUID ownerId;
    protected static final AnimationBuilder WALKING_ANIM = new AnimationBuilder().addAnimation("animation.scarab.walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder FLYING_ANIM = new AnimationBuilder().addAnimation("animation.scarab.flying", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public ScarabEntity(EntityType<ScarabEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.f_21342_ = new PhantomMoveControl((Mob)this);
        this.f_21365_ = new PhantomLookControl((Mob)this);
    }

    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    protected BodyRotationControl m_7560_() {
        return new PhantomBodyRotationControl((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PhantomAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new PhantomSweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new PhantomCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new PhantomAttackPlayerTargetGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
    }

    public void setPhantomSize(int pSize) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)pSize, (int)0, (int)64));
    }

    private void updatePhantomSizeInfo() {
        this.m_6210_();
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(6 + this.getPhantomSize()));
    }

    public int getPhantomSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.35f;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (ID_SIZE.equals(pKey)) {
            this.updatePhantomSizeInfo();
        }
        super.m_7350_(pKey);
    }

    public int getUniqueFlapTickOffset() {
        return this.m_142049_() * 3;
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.anchorPoint = this.m_142538_().m_6630_(2);
        this.setPhantomSize(0);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(pCompound.m_128451_("AX"), pCompound.m_128451_("AY"), pCompound.m_128451_("AZ"));
        }
        this.setPhantomSize(pCompound.m_128451_("Size"));
        if (pCompound.m_128403_("Owner")) {
            this.ownerId = pCompound.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("AX", this.anchorPoint.m_123341_());
        pCompound.m_128405_("AY", this.anchorPoint.m_123342_());
        pCompound.m_128405_("AZ", this.anchorPoint.m_123343_());
        pCompound.m_128405_("Size", this.getPhantomSize());
        if (this.ownerId != null) {
            pCompound.m_128362_("Owner", this.ownerId);
        }
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12191_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6549_(EntityType<?> pType) {
        return true;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        int i = this.getPhantomSize();
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        float f = (entitydimensions.f_20377_ + 0.2f * (float)i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 10.0f, this::walkingAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Flying", 10.0f, this::flyingAnimController));
    }

    private PlayState walkingAnimController(AnimationEvent<ScarabEntity> event) {
        BlockState blockState = this.f_19853_.m_8055_(this.m_20097_());
        if (blockState.m_60734_() != Blocks.f_50016_ && event.isMoving()) {
            event.getController().setAnimation(WALKING_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState flyingAnimController(AnimationEvent<ScarabEntity> event) {
        if (this.m_142039_()) {
            event.getController().setAnimation(FLYING_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    public UUID getOwner() {
        return this.ownerId;
    }

    public void setOwner(UUID ownerId) {
        this.ownerId = ownerId;
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class PhantomMoveControl
    extends MoveControl {
        private float speed;

        public PhantomMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void m_8126_() {
            if (ScarabEntity.this.f_19862_) {
                ScarabEntity.this.m_146922_(ScarabEntity.this.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = ScarabEntity.this.moveTargetPoint.f_82479_ - ScarabEntity.this.m_20185_();
            double d1 = ScarabEntity.this.moveTargetPoint.f_82480_ - ScarabEntity.this.m_20186_();
            double d2 = ScarabEntity.this.moveTargetPoint.f_82481_ - ScarabEntity.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = ScarabEntity.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(ScarabEntity.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                ScarabEntity.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                ScarabEntity.this.f_20883_ = ScarabEntity.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)ScarabEntity.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                ScarabEntity.this.m_146926_(f4);
                float f5 = ScarabEntity.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = ScarabEntity.this.m_20184_();
                ScarabEntity.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class PhantomLookControl
    extends LookControl {
        public PhantomLookControl(Mob p_33235_) {
            super(p_33235_);
        }

        public void m_8128_() {
        }
    }

    class PhantomBodyRotationControl
    extends BodyRotationControl {
        public PhantomBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void m_8121_() {
            ScarabEntity.this.f_20885_ = ScarabEntity.this.f_20883_;
            ScarabEntity.this.f_20883_ = ScarabEntity.this.m_146908_();
        }
    }

    class PhantomAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        PhantomAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = ScarabEntity.this.m_5448_();
            return livingentity != null ? ScarabEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            ScarabEntity.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            ScarabEntity.this.anchorPoint = ScarabEntity.this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, ScarabEntity.this.anchorPoint).m_6630_(10 + ScarabEntity.this.f_19796_.nextInt(20));
        }

        public void m_8037_() {
            if (ScarabEntity.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    ScarabEntity.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + ScarabEntity.this.f_19796_.nextInt(4)) * 20);
                    ScarabEntity.this.m_5496_(SoundEvents.f_12191_, 10.0f, 0.95f + ScarabEntity.this.f_19796_.nextFloat() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            ScarabEntity.this.anchorPoint = ScarabEntity.this.m_5448_().m_142538_().m_6630_(4 + ScarabEntity.this.f_19796_.nextInt(10));
            if (ScarabEntity.this.anchorPoint.m_123342_() < ScarabEntity.this.f_19853_.m_5736_()) {
                ScarabEntity.this.anchorPoint = new BlockPos(ScarabEntity.this.anchorPoint.m_123341_(), ScarabEntity.this.f_19853_.m_5736_() + 1, ScarabEntity.this.anchorPoint.m_123343_());
            }
        }
    }

    class PhantomSweepAttackGoal
    extends PhantomMoveTargetGoal {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        PhantomSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return ScarabEntity.this.m_5448_() != null && ScarabEntity.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = ScarabEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (ScarabEntity.this.f_19797_ > this.catSearchTick) {
                this.catSearchTick = ScarabEntity.this.f_19797_ + 20;
                List list = ScarabEntity.this.f_19853_.m_6443_(Cat.class, ScarabEntity.this.m_142469_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            ScarabEntity.this.m_6710_(null);
            ScarabEntity.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = ScarabEntity.this.m_5448_();
            if (livingentity != null) {
                ScarabEntity.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (ScarabEntity.this.m_142469_().m_82400_((double)0.2f).m_82381_(livingentity.m_142469_())) {
                    ScarabEntity.this.m_7327_((Entity)livingentity);
                    ScarabEntity.this.attackPhase = AttackPhase.CIRCLE;
                    if (!ScarabEntity.this.m_20067_()) {
                        ScarabEntity.this.f_19853_.m_46796_(1039, ScarabEntity.this.m_142538_(), 0);
                    }
                } else if (ScarabEntity.this.f_19862_ || ScarabEntity.this.f_20916_ > 0) {
                    ScarabEntity.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class PhantomCircleAroundAnchorGoal
    extends PhantomMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        PhantomCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return ScarabEntity.this.m_5448_() == null || ScarabEntity.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f;
            this.height = -4.0f;
            this.clockwise = ScarabEntity.this.f_19796_.nextBoolean() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (ScarabEntity.this.f_19796_.nextInt(this.m_183277_(350)) == 0) {
                this.height = -4.0f + ScarabEntity.this.f_19796_.nextFloat() * 9.0f;
            }
            if (ScarabEntity.this.f_19796_.nextInt(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (ScarabEntity.this.f_19796_.nextInt(this.m_183277_(450)) == 0) {
                this.angle = ScarabEntity.this.f_19796_.nextFloat() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (ScarabEntity.this.moveTargetPoint.f_82480_ < ScarabEntity.this.m_20186_() && !ScarabEntity.this.f_19853_.m_46859_(ScarabEntity.this.m_142538_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (ScarabEntity.this.moveTargetPoint.f_82480_ > ScarabEntity.this.m_20186_() && !ScarabEntity.this.f_19853_.m_46859_(ScarabEntity.this.m_142538_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)ScarabEntity.this.anchorPoint)) {
                ScarabEntity.this.anchorPoint = ScarabEntity.this.m_142538_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            ScarabEntity.this.moveTargetPoint = Vec3.m_82528_((Vec3i)ScarabEntity.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class PhantomAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = PhantomAttackPlayerTargetGoal.m_186073_((int)20);

        PhantomAttackPlayerTargetGoal() {
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = PhantomAttackPlayerTargetGoal.m_186073_((int)60);
            List list = ScarabEntity.this.f_19853_.m_45955_(this.attackTargeting, (LivingEntity)ScarabEntity.this, ScarabEntity.this.m_142469_().m_82377_(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!ScarabEntity.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) continue;
                    ScarabEntity.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = ScarabEntity.this.m_5448_();
            return livingentity != null ? ScarabEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }
    }

    abstract class PhantomMoveTargetGoal
    extends Goal {
        public PhantomMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return ScarabEntity.this.moveTargetPoint.m_82531_(ScarabEntity.this.m_20185_(), ScarabEntity.this.m_20186_(), ScarabEntity.this.m_20189_()) < 4.0;
        }
    }
}

