/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.guardian.helper;

import com.google.gson.annotations.Expose;
import iskallia.vault.entity.entity.guardian.AbstractGuardianEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;

public abstract class GuardianStats {
    public void onTick(AbstractGuardianEntity guardian) {
    }

    public void onHurt(AbstractGuardianEntity guardian, DamageSource source, float amount) {
    }

    public static class Bruiser
    extends GuardianStats {
        @Expose
        private ItemStack meleeItem;

        public Bruiser(ItemStack meleeItem) {
            this.meleeItem = meleeItem;
        }

        @Override
        public void onTick(AbstractGuardianEntity guardian) {
            if (guardian.m_21205_().m_41619_()) {
                guardian.m_8061_(EquipmentSlot.MAINHAND, this.meleeItem.m_41777_());
            }
        }
    }

    public static class Arbalist
    extends GuardianStats {
        @Expose
        private ItemStack meleeItem;
        @Expose
        private ItemStack rangedItem;
        @Expose
        private MeleeActivation meleeActivation;
        @Expose
        private double meleeActivationRange;
        @Expose
        private double meleeDeactivationRange;
        @Expose
        private double meleeActivationChance;

        public Arbalist(ItemStack meleeItem, ItemStack rangedItem, MeleeActivation meleeActivation, double meleeActivationRange, double meleeDeactivationRange, double meleeActivationChance) {
            this.meleeItem = meleeItem;
            this.rangedItem = rangedItem;
            this.meleeActivation = meleeActivation;
            this.meleeActivationRange = meleeActivationRange;
            this.meleeDeactivationRange = meleeDeactivationRange;
            this.meleeActivationChance = meleeActivationChance;
        }

        @Override
        public void onTick(AbstractGuardianEntity guardian) {
            if (guardian.m_21205_().m_41619_()) {
                guardian.m_8061_(EquipmentSlot.MAINHAND, this.rangedItem.m_41777_());
            }
            if (this.meleeActivation == MeleeActivation.ALWAYS && guardian.m_5448_() != null && (double)guardian.m_5448_().m_20270_((Entity)guardian) <= this.meleeActivationChance) {
                guardian.m_8061_(EquipmentSlot.MAINHAND, this.meleeItem.m_41777_());
                guardian.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)guardian.m_5448_());
            }
            LivingEntity target = guardian.m_5448_();
            LivingEntity temp = guardian.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
            if (target == null || temp != null && target.m_20270_((Entity)guardian) > temp.m_20270_((Entity)guardian)) {
                target = temp;
            }
            if (target != null && (double)target.m_20270_((Entity)guardian) > this.meleeDeactivationRange) {
                guardian.m_8061_(EquipmentSlot.MAINHAND, this.rangedItem.m_41777_());
            }
        }

        @Override
        public void onHurt(AbstractGuardianEntity guardian, DamageSource source, float amount) {
            LivingEntity attacker;
            Entity entity;
            if (this.meleeActivation != MeleeActivation.ON_HIT) {
                return;
            }
            if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity && (double)(attacker = (LivingEntity)entity).m_20270_((Entity)guardian) <= this.meleeActivationRange) {
                guardian.m_8061_(EquipmentSlot.MAINHAND, this.meleeItem.m_41777_());
                guardian.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)attacker);
                guardian.m_6710_(attacker);
            }
        }

        public static enum MeleeActivation {
            NEVER,
            ON_HIT,
            ALWAYS;

        }
    }

    public static class Empty
    extends GuardianStats {
    }
}

