/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.pet;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientDiscoveredEntriesData;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.trait.IPetTrait;
import iskallia.vault.entity.entity.pet.trait.PetTraitRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.world.data.CompanionVariantUnlockData;
import iskallia.vault.www.Reward;
import iskallia.vault.www.RewardsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class PetHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static boolean isClientUnlocked(@NotNull PetVariant variant) {
        return ClientDiscoveredEntriesData.CompanionVariants.isUnlocked(variant.type());
    }

    private static boolean isVariantUnlocked(UUID playerId, PetVariant variant) {
        if (!variant.requiresUnlock()) {
            return true;
        }
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            return PetHelper.isClientUnlocked(variant);
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return false;
        }
        return CompanionVariantUnlockData.get(server).isUnlocked(playerId, variant.type());
    }

    public static Optional<PetVariant> getVariant(String petType) {
        for (PetModelType model : PetModelType.values()) {
            for (PetVariant variant : model.getVariants()) {
                if (!variant.type().equalsIgnoreCase(petType)) continue;
                return Optional.of(variant);
            }
        }
        return Optional.empty();
    }

    public static Optional<PetModelType> getModel(String petType) {
        for (PetModelType model : PetModelType.values()) {
            for (PetVariant variant : model.getVariants()) {
                if (!variant.type().equalsIgnoreCase(petType)) continue;
                return Optional.of(model);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public static PetVariant rollVariant() {
        double totalWeight = 0.0;
        for (PetModelType model : PetModelType.values()) {
            for (PetVariant variant : model.getVariants()) {
                if (variant.requiresRewards() || variant.requiresUnlock()) continue;
                totalWeight += variant.getWeight();
            }
        }
        double randomValue = Math.random() * totalWeight;
        for (PetModelType model : PetModelType.values()) {
            for (PetVariant variant : model.getVariants()) {
                if (variant.requiresRewards() || variant.requiresUnlock() || !((randomValue -= variant.getWeight()) <= 0.0)) continue;
                return variant;
            }
        }
        return PetModelType.PUG.getVariants()[0];
    }

    public record PetVariant(String type, String displayName, EntityType<PetEntity> entityType, boolean requiresRewards, boolean requiresUnlock, @Nullable PetTrait traits) {
        public static final Cache<String, ItemStack> CACHE_DISPLAY_ITEM = CacheBuilder.newBuilder().build();

        public double getWeight() {
            return ModConfigs.COMPANIONS.getPetWeight(this.type);
        }

        public ItemStack displayItem() {
            try {
                return (ItemStack)CACHE_DISPLAY_ITEM.get((Object)this.type(), () -> {
                    ItemStack stack = new ItemStack((ItemLike)ModItems.COMPANION);
                    CompanionItem.setPetSeries(stack, CompanionSeries.PET);
                    CompanionItem.setPetType(stack, this.type());
                    return stack;
                });
            }
            catch (Exception e) {
                return new ItemStack((ItemLike)ModItems.COMPANION_EGG);
            }
        }
    }

    public static enum PetModelType {
        HUSKY(new PetVariant("venus", "Venus", ModEntities.HUSKY_PET, false, false, PetTrait.Builder.defaultPet().build()), new PetVariant("skeleton_husky", "Skeleton Husky", ModEntities.SKELETON_HUSKY, false, true, PetTrait.Builder.defaultPet().build())),
        UNICORN(new PetVariant("unicorn", "Unicorn", ModEntities.UNICORN_PET, false, false, PetTrait.Builder.defaultPet().build()), new PetVariant("dino", "Dino", ModEntities.DINO_PET, true, false, PetTrait.Builder.defaultPet().addSleep().addBlink().addDance().build())),
        ELEPHANT(new PetVariant("elephant", "Elephant", ModEntities.ELEPHANT_PET, false, false, PetTrait.Builder.defaultPet().addSleep().build())),
        MOOSE(new PetVariant("moose", "Moose", ModEntities.MOOSE_PET, false, false, PetTrait.Builder.defaultPet().addSleep().build())),
        PUG(new PetVariant("pug", "Wrinkles", ModEntities.PUG_PET, false, false, PetTrait.Builder.defaultPet().addSleep().build())),
        RACCOON(new PetVariant("raccoon", "Raccoon", ModEntities.RACCOON_PET, false, false, PetTrait.Builder.defaultPet().build())),
        SHIBA(new PetVariant("shiba", "Shiba", ModEntities.SHIBA_PET, false, false, PetTrait.Builder.defaultPet().build())),
        BABY_CREEPER(new PetVariant("baby_creeper", "Baby Creeper", ModEntities.BABY_CREEPER_PET, false, false, PetTrait.Builder.defaultPet().addSleep().build()), new PetVariant("baby_creeper_gold", "Gold Baby Creeper", ModEntities.GOLD_BABY_CREEPER_PET, true, false, PetTrait.Builder.defaultPet().addSleep().build()), new PetVariant("baby_creeper_pog", "POG Baby Creeper", ModEntities.BABY_CREEPER_POG_PET, true, false, PetTrait.Builder.defaultPet().addSleep().build())),
        CAT(new PetVariant("black_cat", "Black Cat", ModEntities.BLACK_CAT_PET, false, false, PetTrait.Builder.defaultPet().build()), new PetVariant("white_cat", "White Cat", ModEntities.WHITE_CAT_PET, false, false, PetTrait.Builder.defaultPet().build())),
        PANDA(new PetVariant("panda", "Panda", ModEntities.PANDA_PET, false, false, PetTrait.Builder.defaultPet().addSleep().build())),
        PAPILLON(new PetVariant("papillon", "Papillon", ModEntities.PAPILLON_PET, false, false, PetTrait.Builder.defaultPet().build())),
        PENGUIN(new PetVariant("penguin", "Penguin", ModEntities.PENGUIN_PET, false, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build()), new PetVariant("dylan_penguin", "Dylan's Penguin", ModEntities.DYLAN_PENGUIN_PET, true, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build())),
        DYLAN(new PetVariant("dylan", "Dylan", ModEntities.DYLAN, false, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build()), new PetVariant("dylan_pink", "Pink Dylan", ModEntities.DYLAN_PINK, true, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build()), new PetVariant("carrot", "Carrot", ModEntities.CARROT, true, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build()), new PetVariant("bumbo_cactoni", "Bumbo Cactoni", ModEntities.BUMBO_CACTONI, true, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build()), new PetVariant("golden_bumbo_cactoni", "Golden Bumbo Cactoni", ModEntities.BUMBO_CACTONI_GOLDEN, true, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build()), new PetVariant("bumbo_pumpkini", "Bumbo Pumpkini", ModEntities.BUMBO_PUMPKINI, true, false, PetTrait.Builder.defaultPet().addSleep().addBlink().build()));

        private final PetVariant[] variants;

        private PetModelType(PetVariant ... variants) {
            this.variants = variants;
        }

        public PetVariant[] getVariants() {
            return this.variants;
        }

        public List<PetVariant> getVariants(@NotNull UUID playerId) {
            ArrayList<PetVariant> variants = new ArrayList<PetVariant>();
            Reward rewards = RewardsManager.getInstance().getRewardData(playerId);
            for (PetVariant variant : this.variants) {
                boolean hasReward;
                boolean bl = hasReward = !variant.requiresRewards || rewards.hasModel(Reward.ArmorPiece.COMPANION, VaultMod.id(variant.type));
                if (!hasReward || !PetHelper.isVariantUnlocked(playerId, variant)) continue;
                variants.add(variant);
            }
            return variants;
        }
    }

    public record PetTrait(Map<String, CompoundTag> traits) {
        public void apply(PetEntity pet) {
            for (Map.Entry<String, CompoundTag> entry : this.traits().entrySet()) {
                String key = entry.getKey();
                CompoundTag value = entry.getValue();
                PetTraitRegistry.createTrait(key, pet, value).ifPresent(petTrait -> pet.addTrait(key, (IPetTrait)petTrait));
            }
        }

        public static class Builder {
            private Map<String, CompoundTag> traits;

            public static Builder create() {
                return new Builder();
            }

            public static Builder defaultPet() {
                return new Builder().addBlink();
            }

            public Builder setTraits(Map<String, CompoundTag> traits) {
                this.traits = traits;
                return this;
            }

            public Builder addTrait(String traitName, CompoundTag traitData) {
                if (this.traits == null) {
                    this.traits = new HashMap<String, CompoundTag>();
                }
                this.traits.put(traitName, traitData);
                return this;
            }

            public Builder addBlink() {
                return this.addTrait("blink", new CompoundTag());
            }

            public Builder addSleep() {
                return this.addTrait("sleep_action", new CompoundTag());
            }

            public Builder addDance() {
                return this.addTrait("Dance");
            }

            public Builder addTrait(String traitName) {
                return this.addTrait(traitName, new CompoundTag());
            }

            public Builder addTrait(IPetTrait trait) {
                return this.addTrait(trait.getType(), trait.serializeNBT());
            }

            public PetTrait build() {
                return new PetTrait(this.traits);
            }
        }
    }
}

