/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.pet.trait;

import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.trait.IPetTrait;
import net.minecraft.nbt.CompoundTag;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class AnimationControllerTrait
implements IPetTrait {
    public static final String TYPE = "custom_animation";
    private String controllerName = "Custom";
    private String animation = "idle";
    private int transitionLength = 5;

    public static AnimationControllerTrait of(String controllerName, String animation, int transitionLength) {
        AnimationControllerTrait trait = new AnimationControllerTrait();
        trait.controllerName = controllerName;
        trait.animation = animation;
        trait.transitionLength = transitionLength;
        return trait;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Controller", this.controllerName);
        nbt.m_128359_("Animation", this.animation);
        nbt.m_128405_("Transition", this.transitionLength);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, PetEntity pet) {
        if (nbt.m_128441_("Controller")) {
            this.controllerName = nbt.m_128461_("Controller");
        }
        if (nbt.m_128441_("Animation")) {
            this.animation = nbt.m_128461_("Animation");
        }
        if (nbt.m_128441_("Transition")) {
            this.transitionLength = nbt.m_128451_("Transition");
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void registerControllers(PetEntity pet, AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)pet, this.controllerName, (float)this.transitionLength, this::predicate));
    }

    private PlayState predicate(AnimationEvent<PetEntity> event) {
        PetEntity pet = (PetEntity)event.getAnimatable();
        if (pet.m_5803_()) {
            return PlayState.STOP;
        }
        if ("dance".equals(this.animation) && pet.isDancing()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dance", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animation, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }
}

