/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.pet.trait;

import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.trait.IPetTrait;
import net.minecraft.nbt.CompoundTag;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;

public class BlinkPetTrait
implements IPetTrait {
    public static final String TYPE = "blink";
    private int interval;
    private int cooldown;

    public BlinkPetTrait() {
        this.cooldown = this.interval = 40;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("interval", this.interval);
        nbt.m_128405_("cooldown", this.cooldown);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, PetEntity pet) {
        if (nbt.m_128441_("interval")) {
            this.interval = nbt.m_128451_("interval");
        }
        this.cooldown = nbt.m_128441_("cooldown") ? nbt.m_128451_("cooldown") : this.interval;
    }

    @Override
    public void registerControllers(PetEntity pet, AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)pet, "Blink", 0.0f, event -> PlayState.STOP));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void tick(PetEntity pet) {
        if (pet.m_5803_()) {
            return;
        }
        if (--this.cooldown <= 0) {
            AnimationData data = pet.getFactory().getOrCreateAnimationData(pet.m_142049_());
            AnimationController controller = (AnimationController)data.getAnimationControllers().get("Blink");
            if (controller != null) {
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation(TYPE, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
            this.cooldown = this.interval;
        }
    }

    @Override
    public void addStack(IPetTrait trait) {
        if (trait instanceof BlinkPetTrait) {
            BlinkPetTrait other = (BlinkPetTrait)trait;
            this.interval = Math.min(this.interval, other.interval);
        }
    }
}

