/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.pet.trait;

import com.google.common.collect.ImmutableMap;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.trait.AnimationControllerTrait;
import iskallia.vault.entity.entity.pet.trait.BlinkPetTrait;
import iskallia.vault.entity.entity.pet.trait.EmptyPetTrait;
import iskallia.vault.entity.entity.pet.trait.IPetTrait;
import iskallia.vault.entity.entity.pet.trait.SleepPetTrait;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class PetTraitRegistry {
    private static final Map<String, IPetTraitFactory> TRAIT_FACTORIES = new ImmutableMap.Builder().put((Object)"blink", pet -> new BlinkPetTrait()).put((Object)"custom_animation", pet -> new AnimationControllerTrait()).put((Object)"sleep_action", pet -> new SleepPetTrait()).put((Object)"Dance", pet -> new EmptyPetTrait("Dance")).build();

    public static Optional<IPetTrait> createTrait(String type, PetEntity pet, CompoundTag nbt) {
        if (!TRAIT_FACTORIES.containsKey(type)) {
            return Optional.empty();
        }
        IPetTrait trait = TRAIT_FACTORIES.get(type).create(pet);
        trait.deserializeNBT(nbt, pet);
        return Optional.of(trait);
    }

    public static List<IPetTrait> getAll(PetEntity entity) {
        return TRAIT_FACTORIES.values().stream().map(factory -> factory.create(entity)).toList();
    }

    public static interface IPetTraitFactory {
        public IPetTrait create(PetEntity var1);
    }
}

