/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.pet.trait;

import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.trait.IPetTrait;
import net.minecraft.nbt.CompoundTag;

public class SleepPetTrait
implements IPetTrait {
    public static final String TYPE = "sleep_action";
    private int idleTicks;
    private double lastX;
    private double lastY;
    private double lastZ;

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("IdleTicks", this.idleTicks);
        nbt.m_128347_("LastX", this.lastX);
        nbt.m_128347_("LastY", this.lastY);
        nbt.m_128347_("LastZ", this.lastZ);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, PetEntity pet) {
        this.idleTicks = nbt.m_128451_("IdleTicks");
        this.lastX = nbt.m_128441_("LastX") ? nbt.m_128459_("LastX") : pet.m_20185_();
        this.lastY = nbt.m_128441_("LastY") ? nbt.m_128459_("LastY") : pet.m_20186_();
        this.lastZ = nbt.m_128441_("LastZ") ? nbt.m_128459_("LastZ") : pet.m_20189_();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(PetEntity pet) {
        this.lastX = pet.m_20185_();
        this.lastY = pet.m_20186_();
        this.lastZ = pet.m_20189_();
    }

    @Override
    public void tick(PetEntity pet) {
        double dz;
        double dy;
        if (pet.isDancing()) {
            return;
        }
        double dx = pet.m_20185_() - this.lastX;
        boolean moving = dx * dx + (dy = pet.m_20186_() - this.lastY) * dy + (dz = pet.m_20189_() - this.lastZ) * dz > 1.0E-4;
        this.lastX = pet.m_20185_();
        this.lastY = pet.m_20186_();
        this.lastZ = pet.m_20189_();
        if (moving) {
            this.idleTicks = 0;
            if (pet.m_5803_()) {
                pet.setSleeping(false);
            }
        } else if (!pet.m_5803_() && ++this.idleTicks >= 100) {
            pet.setSleeping(true);
        }
    }
}

