/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.tank;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.entity.entity.tank.BaseTankEntity;
import iskallia.vault.init.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class OvergrownTankEntity
extends BaseTankEntity
implements IAnimatable {
    private int throwAnimationTick;
    protected static final AnimationBuilder LOOK_ANIM = new AnimationBuilder().addAnimation("animation.overgrown_tank.look", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder STAND_ANIM = new AnimationBuilder().addAnimation("animation.overgrown_tank.stand", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder WALKING_ANIM = new AnimationBuilder().addAnimation("animation.overgrown_tank.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder PUNCH_ANIM = new AnimationBuilder().addAnimation("animation.overgrown_tank.punch", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder THROW_ANIM = new AnimationBuilder().addAnimation("animation.overgrown_tank.throw", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public OvergrownTankEntity(EntityType<OvergrownTankEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
    }

    public int getThrowAnimationTick() {
        return this.throwAnimationTick;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Idle", 0.0f, this::idleAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 0.0f, this::walkingAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Punch", 0.0f, this::punchAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Throw", 0.0f, this::throwAnimController));
    }

    private PlayState idleAnimController(AnimationEvent<OvergrownTankEntity> event) {
        if (!event.isMoving() && (float)this.getAttackAnimationTick() == 0.0f) {
            event.getController().setAnimation(STAND_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState walkingAnimController(AnimationEvent<OvergrownTankEntity> event) {
        if (event.isMoving() && (float)this.getAttackAnimationTick() == 0.0f) {
            event.getController().setAnimation(WALKING_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState punchAnimController(AnimationEvent<OvergrownTankEntity> event) {
        if (this.getAttackAnimationTick() != 0) {
            event.getController().setAnimation(PUNCH_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState throwAnimController(AnimationEvent<OvergrownTankEntity> event) {
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSounds.STONEWARDEN_DEATH;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return ModSounds.STONEWARDEN_HURT;
    }

    protected float m_6121_() {
        return 0.45f;
    }

    public static class ThrowFireballGoal
    extends Goal {
        protected final OvergrownTankEntity mob;
        protected int throwTick;

        public ThrowFireballGoal(OvergrownTankEntity mob) {
            this.mob = mob;
        }

        public void m_8056_() {
            this.mob.throwAnimationTick = this.throwTick = 12;
        }

        public void m_8037_() {
            LivingEntity target;
            --this.throwTick;
            this.mob.throwAnimationTick = this.throwTick;
            if (this.throwTick <= 0 && (target = this.mob.m_5448_()) != null) {
                double distanceToSqr = this.mob.m_20280_((Entity)target);
                double vectorX = target.m_20185_() - this.mob.m_20185_();
                double vectorY = target.m_20227_(0.5) - this.mob.m_20227_(0.5);
                double vectorZ = target.m_20189_() - this.mob.m_20189_();
                double inaccuracy = Math.sqrt(Math.sqrt(distanceToSqr)) * 0.1;
                LargeFireball fireball = new LargeFireball(this.mob.f_19853_, (LivingEntity)this.mob, vectorX + this.mob.m_21187_().nextGaussian() * inaccuracy, vectorY, vectorZ + this.mob.m_21187_().nextGaussian() * inaccuracy, 0);
                fireball.m_6034_(fireball.m_20185_(), this.mob.m_20227_(0.5) + 0.6, fireball.m_20189_());
                this.mob.f_19853_.m_7967_((Entity)fireball);
                this.mob.f_19853_.m_5594_(null, this.mob.m_142538_(), SoundEvents.f_11874_, SoundSource.HOSTILE, 1.0f, 0.4f / (this.mob.f_19853_.f_46441_.nextFloat() * 0.4f + 0.8f));
                this.throwTick = IntRoll.ofUniform(40, 100).get(JavaRandom.ofNanoTime());
            }
        }

        public boolean m_8036_() {
            return true;
        }
    }
}

