/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.tank;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.entity.entity.CannonBallEntity;
import iskallia.vault.entity.entity.tank.BaseTankEntity;
import iskallia.vault.init.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class PirateGuardianTankEntity
extends BaseTankEntity
implements IAnimatable {
    private int animationTick;
    protected static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("animation.pirate_guardian_tank.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder WALKING_ANIM = new AnimationBuilder().addAnimation("animation.pirate_guardian_tank.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder ATTACK_ANIM = new AnimationBuilder().addAnimation("animation.pirate_guardian_tank.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public PirateGuardianTankEntity(EntityType<PirateGuardianTankEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int m_8100_() {
        return 160;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12000_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12006_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12003_;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.animationTick > 0) {
            --this.animationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Idle", 0.0f, this::idleAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 0.0f, this::walkingAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Attack", 0.0f, this::attackAnimController));
    }

    private PlayState idleAnimController(AnimationEvent<PirateGuardianTankEntity> event) {
        if (!event.isMoving() && this.animationTick == 0) {
            event.getController().setAnimation(IDLE_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState walkingAnimController(AnimationEvent<PirateGuardianTankEntity> event) {
        if (event.isMoving() && this.animationTick == 0) {
            event.getController().setAnimation(WALKING_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState attackAnimController(AnimationEvent<PirateGuardianTankEntity> event) {
        if (this.animationTick != 0) {
            event.getController().setAnimation(ATTACK_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private void playAttackAnimation() {
        this.attackAnimationTick = 30;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class AttackGoal
    extends Goal {
        protected final PirateGuardianTankEntity mob;
        protected int attackTick;

        public AttackGoal(PirateGuardianTankEntity mob) {
            this.mob = mob;
        }

        public void m_8056_() {
            this.attackTick = 25;
        }

        public void m_8037_() {
            LivingEntity target;
            --this.attackTick;
            if (this.attackTick <= 0 && (target = this.mob.m_5448_()) != null) {
                double distanceToSqr = this.mob.m_20280_((Entity)target);
                double vectorX = target.m_20185_() - this.mob.m_20185_();
                double vectorY = target.m_20227_(0.5) - this.mob.m_20227_(0.5);
                double vectorZ = target.m_20189_() - this.mob.m_20189_();
                double inaccuracy = Math.sqrt(Math.sqrt(distanceToSqr)) * 0.1;
                CannonBallEntity fireball = new CannonBallEntity(this.mob.f_19853_, (LivingEntity)this.mob);
                fireball.m_6034_(fireball.m_20185_(), this.mob.m_20227_(0.5) + 0.6, fireball.m_20189_());
                fireball.m_6686_(vectorX, vectorY, vectorZ, 1.6f, 0.0f);
                this.mob.f_19853_.m_7967_((Entity)fireball);
                this.mob.f_19853_.m_5594_(null, this.mob.m_142538_(), ModSounds.CANNON_EXPLOSION, SoundSource.HOSTILE, 1.0f, 0.4f / (this.mob.f_19853_.f_46441_.nextFloat() * 0.4f + 0.8f));
                this.attackTick = IntRoll.ofUniform(25, 35).get(JavaRandom.ofNanoTime());
                this.mob.playAttackAnimation();
            }
        }

        public boolean m_8036_() {
            return true;
        }
    }
}

