/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity.wraith;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class VaultWraithEntity
extends Zombie {
    private static final List<String> VALID_WRAITH_SOUNDS = List.of("entity.sheep.ambient|entity.sheep.hurt|entity.sheep.death", "entity.cow.ambient|entity.cow.hurt|entity.cow.death", "entity.pig.ambient|entity.pig.hurt|entity.pig.death", "entity.chicken.ambient|entity.chicken.hurt|entity.chicken.death", "entity.horse.ambient|entity.horse.hurt|entity.horse.death", "entity.cat.ambient|entity.cat.hurt|entity.cat.death", "entity.wolf.ambient|entity.wolf.hurt|entity.wolf.death", "entity.villager.ambient|entity.villager.hurt|entity.villager.death", "entity.polar_bear.ambient|entity.polar_bear.hurt|entity.polar_bear.death", "entity.zombie.ambient|entity.zombie.hurt|entity.zombie.death", "entity.skeleton.ambient|entity.skeleton.hurt|entity.skeleton.death", "entity.spider.ambient|entity.spider.hurt|entity.spider.death", "|entity.creeper.hurt|entity.creeper.death", "entity.endermen.ambient|entity.endermen.hurt|entity.endermen.death", "entity.zombie_pig.ambient|entity.zombie_pig.hurt|entity.zombie_pig.death", "entity.witch.ambient|entity.witch.hurt|entity.witch.death", "entity.blaze.ambient|entity.blaze.hurt|entity.blaze.death", "entity.llama.ambient|entity.llama.hurt|entity.llama.death");
    private static final EntityDataAccessor<String> IDLE_SOUND = SynchedEntityData.m_135353_(VaultWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> HURT_SOUND = SynchedEntityData.m_135353_(VaultWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DEATH_SOUND = SynchedEntityData.m_135353_(VaultWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String TAG_IDLE_SOUND = "IdleSound";
    private static final String TAG_HURT_SOUND = "HurtSound";
    private static final String TAG_DEATH_SOUND = "DeathSound";

    public VaultWraithEntity(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IDLE_SOUND, (Object)"");
        this.f_19804_.m_135372_(HURT_SOUND, (Object)"");
        this.f_19804_.m_135372_(DEATH_SOUND, (Object)"");
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22287_, 0.0);
    }

    protected void m_6851_(@Nonnull DifficultyInstance difficulty) {
    }

    protected SoundEvent m_7515_() {
        return this.getSound(IDLE_SOUND);
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return this.getSound(HURT_SOUND);
    }

    protected SoundEvent m_5592_() {
        return this.getSound(DEATH_SOUND);
    }

    public float m_6100_() {
        return this.f_19796_.nextFloat() * 0.1f + 0.75f;
    }

    public SoundEvent getSound(EntityDataAccessor<String> param) {
        if (((String)this.f_19804_.m_135370_(param)).isEmpty()) {
            return null;
        }
        ResourceLocation loc = new ResourceLocation((String)this.f_19804_.m_135370_(param));
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(loc);
    }

    public void m_8119_() {
        super.m_8119_();
        AABB aabb = this.m_142469_();
        double x = aabb.f_82288_ + Math.random() * (aabb.f_82291_ - aabb.f_82288_);
        double y = aabb.f_82289_ + Math.random() * (aabb.f_82292_ - aabb.f_82289_);
        double z = aabb.f_82290_ + Math.random() * (aabb.f_82293_ - aabb.f_82290_);
        this.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, x, y, z, 0.0, 0.0, 0.0);
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        int idx = this.f_19796_.nextInt(VALID_WRAITH_SOUNDS.size());
        String sound = VALID_WRAITH_SOUNDS.get(idx);
        String[] split = sound.split("\\|");
        this.f_19804_.m_135381_(IDLE_SOUND, (Object)split[0]);
        this.f_19804_.m_135381_(HURT_SOUND, (Object)split[1]);
        this.f_19804_.m_135381_(DEATH_SOUND, (Object)split[2]);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_142535_(float distance, float damageMultiplier, @Nonnull DamageSource source) {
        return false;
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_(TAG_IDLE_SOUND, (String)this.f_19804_.m_135370_(IDLE_SOUND));
        compound.m_128359_(TAG_HURT_SOUND, (String)this.f_19804_.m_135370_(HURT_SOUND));
        compound.m_128359_(TAG_DEATH_SOUND, (String)this.f_19804_.m_135370_(DEATH_SOUND));
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(IDLE_SOUND, (Object)compound.m_128461_(TAG_IDLE_SOUND));
        this.f_19804_.m_135381_(HURT_SOUND, (Object)compound.m_128461_(TAG_HURT_SOUND));
        this.f_19804_.m_135381_(DEATH_SOUND, (Object)compound.m_128461_(TAG_DEATH_SOUND));
    }

    public void m_6863_(boolean childZombie) {
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (!super.m_6469_(source, amount)) {
            return false;
        }
        return this.f_19853_ instanceof ServerLevel;
    }

    protected void m_34339_(float difficulty) {
    }
}

