/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.eternal;

import iskallia.vault.init.ModConfigs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class EternalAttributes
implements INBTSerializable<CompoundTag> {
    public static final String HEALTH = "health";
    public static final String DAMAGE = "damage";
    public static final String MOVEMENT_SPEED = "movespeed";
    private final Map<Attribute, Float> attributes = new HashMap<Attribute, Float>();

    public EternalAttributes() {
    }

    private EternalAttributes(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public static EternalAttributes fromNBT(CompoundTag tag) {
        return new EternalAttributes(tag);
    }

    void initializeAttributes() {
        ModConfigs.ETERNAL_ATTRIBUTES.createAttributes().forEach(this.attributes::put);
    }

    public Optional<Float> getAttributeValue(Attribute attribute) {
        return Optional.ofNullable(this.attributes.get(attribute));
    }

    public Map<Attribute, Float> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    private void setAttributeValue(Attribute attribute, float value) {
        this.attributes.put(attribute, Float.valueOf(value));
    }

    void addAttributeValue(Attribute attribute, float value) {
        float existing = this.getAttributeValue(attribute).orElse(Float.valueOf(0.0f)).floatValue();
        this.setAttributeValue(attribute, existing + value);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.attributes.forEach((attribute, value) -> tag.m_128350_(attribute.getRegistryName().toString(), value.floatValue()));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.attributes.clear();
        tag.m_128431_().forEach(attributeKey -> {
            Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeKey));
            if (attr != null) {
                this.attributes.put(attr, Float.valueOf(tag.m_128457_(attributeKey)));
            }
        });
    }
}

