/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.eternal;

import iskallia.vault.world.data.EternalsData;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;

public interface EternalDataAccess {
    public UUID getId();

    public long getSeed();

    public int getLevel();

    public int getMaxLevel();

    public String getName();

    public boolean isAlive();

    public boolean isAncient();

    public EternalsData.EternalVariant getVariant();

    public boolean isUsingPlayerSkin();

    public Map<EquipmentSlot, ItemStack> getEquipment();

    public Map<Attribute, Float> getEntityAttributes();

    @Nullable
    public String getAbilityName();

    default public Random getSeededRand() {
        long seed = this.getSeed();
        seed ^= this.getId().getMostSignificantBits();
        return new Random(seed ^= this.getId().getLeastSignificantBits());
    }
}

