/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class FighterModel
extends HumanoidModel<LivingEntity> {
    private final List<ModelPart> parts;
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;
    private final ModelPart cloak;
    private final ModelPart ear;
    private final boolean slim;

    public FighterModel(ModelPart pRoot, boolean pSlim) {
        super(pRoot, RenderType::m_110473_);
        this.slim = pSlim;
        this.ear = pRoot.m_171324_("ear");
        this.cloak = pRoot.m_171324_("cloak");
        this.leftSleeve = pRoot.m_171324_("left_sleeve");
        this.rightSleeve = pRoot.m_171324_("right_sleeve");
        this.leftPants = pRoot.m_171324_("left_pants");
        this.rightPants = pRoot.m_171324_("right_pants");
        this.jacket = pRoot.m_171324_("jacket");
        this.parts = (List)pRoot.m_171331_().filter(p_170824_ -> !p_170824_.m_171326_()).collect(ImmutableList.toImmutableList());
    }

    public static LayerDefinition createBodyLayer() {
        return FighterModel.createBodyLayer(new CubeDeformation(0.0f));
    }

    public static LayerDefinition createBodyLayerT3() {
        return FighterModel.createBodyLayerT3(new CubeDeformation(0.0f));
    }

    public static LayerDefinition createBodyLayerT4() {
        return FighterModel.createBodyLayerT4(new CubeDeformation(0.0f));
    }

    public static LayerDefinition createBodyLayerT5() {
        return FighterModel.createBodyLayerT5(new CubeDeformation(0.0f));
    }

    public static LayerDefinition createBodyLayer(CubeDeformation pCubeDeformation) {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)pCubeDeformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, pCubeDeformation), PartPose.f_171404_);
        partdefinition.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, pCubeDeformation, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBodyLayerT3(CubeDeformation pCubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition sword = Body.m_171599_("sword", CubeListBuilder.m_171558_().m_171514_(35, 100).m_171488_(0.0f, 2.75f, 1.65f, 1.0f, 2.0f, 2.0f, pCubeDeformation).m_171514_(35, 100).m_171488_(0.0f, 1.75f, 0.65f, 1.0f, 2.0f, 2.0f, pCubeDeformation).m_171514_(12, 117).m_171488_(0.0f, 1.75f, 6.65f, 1.0f, 2.0f, 2.0f, pCubeDeformation).m_171514_(3, 111).m_171488_(0.0f, 7.75f, 0.65f, 1.0f, 2.0f, 2.0f, pCubeDeformation).m_171514_(19, 83).m_171488_(0.0f, 2.75f, 4.65f, 1.0f, 2.0f, 3.0f, pCubeDeformation).m_171514_(2, 88).m_171488_(0.0f, 5.75f, 1.65f, 1.0f, 3.0f, 2.0f, pCubeDeformation).m_171514_(12, 93).m_171488_(0.0f, 3.75f, 2.65f, 1.0f, 4.0f, 4.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 12.75f, 11.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 11.75f, 10.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 10.75f, 9.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 9.75f, 8.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 8.75f, 7.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 7.75f, 6.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 6.75f, 5.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(92, 49).m_171488_(0.0f, 5.75f, 4.65f, 1.0f, 3.0f, 3.0f, pCubeDeformation).m_171514_(74, 77).m_171488_(0.0f, -0.25f, -1.35f, 1.0f, 3.0f, 3.0f, pCubeDeformation), PartPose.m_171423_((float)-0.5f, (float)5.5f, (float)-12.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = Body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(75, 70).m_171488_(-5.5f, -1.0f, 1.5f, 1.0f, 16.0f, 16.0f, pCubeDeformation), PartPose.m_171423_((float)5.0f, (float)8.05f, (float)-13.975f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(32, 56).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(48, 28).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, pCubeDeformation), PartPose.f_171404_);
        partdefinition.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, pCubeDeformation, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(44, 44).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static LayerDefinition createBodyLayerT4(CubeDeformation pCubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, pCubeDeformation).m_171514_(16, 60).m_171488_(-3.5f, 3.0f, -1.0f, 7.0f, 7.0f, 2.0f, pCubeDeformation).m_171514_(0, 0).m_171488_(-3.25f, 6.0f, 0.0f, 2.0f, 1.0f, 1.0f, pCubeDeformation).m_171514_(0, 0).m_171488_(1.25f, 6.0f, 0.0f, 2.0f, 1.0f, 1.0f, pCubeDeformation).m_171514_(0, 0).m_171488_(0.75f, 8.0f, 0.0f, 2.0f, 1.0f, 1.0f, pCubeDeformation).m_171514_(14, 88).m_171488_(-2.75f, 8.0f, 0.0f, 2.0f, 1.0f, 1.0f, pCubeDeformation).m_171514_(0, 0).m_171488_(0.75f, 4.25f, 0.0f, 2.0f, 1.0f, 1.0f, pCubeDeformation).m_171514_(0, 0).m_171488_(-2.75f, 4.25f, 0.0f, 2.0f, 1.0f, 1.0f, pCubeDeformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(52, 28).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(36, 44).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(44, 12).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation.m_171469_(0.5f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1047f, (float)0.0873f, (float)0.0f));
        partdefinition.m_171599_("ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, pCubeDeformation), PartPose.f_171404_);
        partdefinition.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, pCubeDeformation, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(52, 44).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(20, 44).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static LayerDefinition createBodyLayerT5(CubeDeformation pCubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 3).m_171488_(1.25f, -5.0f, -4.3f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.29f)).m_171514_(0, 3).m_171480_().m_171488_(-2.25f, -5.0f, -4.3f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.29f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("headwear", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-3.5f, 3.0f, -1.0f, 7.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 48).m_171488_(-4.0f, 0.0f, 2.3f, 8.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.75f, (float)8.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.25f, (float)6.75f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.25f, (float)6.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        body.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.75f, (float)5.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        body.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.75f, (float)5.25f, (float)0.0f, (float)-0.1739f, (float)0.0151f, (float)0.0859f));
        body.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.75f, (float)8.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(24, 32).m_171488_(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation.m_171469_(0.5f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1047f, (float)0.0873f, (float)0.0f));
        partdefinition.m_171599_("ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, pCubeDeformation), PartPose.f_171404_);
        partdefinition.m_171599_("cloak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171496_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, pCubeDeformation, 1.0f, 0.5f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(52, 44).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(20, 44).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, pCubeDeformation.m_171469_(0.25f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.leftPants, (Object)this.rightPants, (Object)this.leftSleeve, (Object)this.rightSleeve, (Object)this.jacket));
    }

    public void m_6973_(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.leftPants.m_104315_(this.f_102814_);
        this.rightPants.m_104315_(this.f_102813_);
        this.leftSleeve.m_104315_(this.f_102812_);
        this.rightSleeve.m_104315_(this.f_102811_);
        this.jacket.m_104315_(this.f_102810_);
        this.cloak.f_104207_ = false;
        this.ear.f_104207_ = false;
        String path = pEntity.m_6095_().getRegistryName().m_135815_();
        switch (path = path.substring(path.length() - 1)) {
            case "3": {
                boolean bl = false;
                break;
            }
            default: {
                boolean bl = this.f_102809_.f_104207_ = true;
            }
        }
        if (pEntity.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            if (pEntity.m_6047_()) {
                this.cloak.f_104202_ = 1.4f;
                this.cloak.f_104201_ = 1.85f;
            } else {
                this.cloak.f_104202_ = 0.0f;
                this.cloak.f_104201_ = 0.0f;
            }
        } else if (pEntity.m_6047_()) {
            this.cloak.f_104202_ = 0.3f;
            this.cloak.f_104201_ = 0.8f;
        } else {
            this.cloak.f_104202_ = -1.1f;
            this.cloak.f_104201_ = -0.85f;
        }
    }

    public void m_8009_(boolean pVisible) {
        super.m_8009_(pVisible);
        this.leftSleeve.f_104207_ = pVisible;
        this.rightSleeve.f_104207_ = pVisible;
        this.leftPants.f_104207_ = pVisible;
        this.rightPants.f_104207_ = pVisible;
        this.jacket.f_104207_ = pVisible;
        this.cloak.f_104207_ = pVisible;
        this.ear.f_104207_ = pVisible;
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        ModelPart modelpart = this.m_102851_(pSide);
        if (this.slim) {
            float f = 0.5f * (float)(pSide == HumanoidArm.RIGHT ? 1 : -1);
            modelpart.f_104200_ += f;
            modelpart.m_104299_(pPoseStack);
            modelpart.f_104200_ -= f;
        } else {
            modelpart.m_104299_(pPoseStack);
        }
    }

    public ModelPart getRandomModelPart(Random pRandom) {
        return this.parts.get(pRandom.nextInt(this.parts.size()));
    }
}

