/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.model;

import iskallia.vault.client.gui.helper.Easing;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.entity.entity.SwampZombieEntity;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.IScalablePart;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SwampZombieModel
extends ZombieModel<SwampZombieEntity> {
    protected ModelPart shroom;

    public SwampZombieModel(ModelPart root) {
        super(root);
        this.shroom = root.m_171324_("head").m_171324_("shroom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(-3.0f, 7.0f, -5.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(-3.0f, 7.0f, -6.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(1.0f, 7.0f, -6.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(2.0f, 7.0f, -5.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(1.0f, 9.0f, -5.75f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(2.0f, 9.0f, -4.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(-3.0f, 9.0f, -5.75f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(-3.0f, 9.0f, -4.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(1.0f, 7.0f, -6.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(2.0f, 7.0f, -5.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(-3.0f, 7.0f, -6.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(-3.0f, 7.0f, -5.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(1.0f, 5.0f, -7.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(-3.0f, 5.0f, -6.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(-3.0f, 5.0f, -7.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(2.0f, 5.0f, -6.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body_r1 = body.m_171599_("Body_r1", CubeListBuilder.m_171558_().m_171514_(32, 18).m_171488_(-4.0f, -6.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)-2.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition Head_r1 = head.m_171599_("Head_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -4.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-2.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition shroom = head.m_171599_("shroom", CubeListBuilder.m_171558_().m_171514_(36, 15).m_171488_(-3.0f, -1.0f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(50, 10).m_171488_(0.0f, -4.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(50, 0).m_171488_(-2.0f, -3.0f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(46, 34).m_171488_(-2.0f, -5.0f, -3.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-5.0f, (float)-6.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(18, 34).m_171488_(-2.0f, 1.0f, -5.0f, 3.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 49).m_171488_(-3.0f, 5.0f, -6.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(50, 6).m_171488_(-2.5f, 7.0f, -5.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(46, 41).m_171488_(-1.0f, 1.0f, -5.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(-1.5f, 0.0f, -5.5f, 4.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(32, 34).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull SwampZombieEntity entity, float pLimbSwing, float pLimbSwingAmount, float ageInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_((Monster)entity, pLimbSwing, pLimbSwingAmount, ageInTicks, pNetHeadYaw, pHeadPitch);
        this.f_102811_.m_171327_(0.0f, 0.0f, 0.0f);
        this.f_102812_.m_171327_(0.0f, 0.0f, 0.0f);
        this.f_102809_.f_104207_ = false;
        Level level = entity.f_19853_;
        float range = 2.0f;
        List<Player> nearbyPlayers = EntityHelper.getNearby((LevelAccessor)level, (Vec3i)entity.m_142538_(), range, Player.class);
        int now = (int)ClientScheduler.INSTANCE.getTick();
        float shroomScale = nearbyPlayers.size() == 0 ? 1.0f : 0.75f + Easing.EASE_IN_OUT_SINE.calc((float)now / 5.0f) * 0.4f;
        ((IScalablePart)this.shroom).getScale().m_122245_(1.0f, shroomScale, 1.0f);
        if (((long)now - entity.prevPuffTick) % 10L != 0L) {
            return;
        }
        entity.prevPuffTick = now;
        if (nearbyPlayers.size() > 0) {
            double dist = 1.25;
            Vec3 dir = new Vec3((double)(this.shroom.f_104200_ / 16.0f), (double)(-this.shroom.f_104201_ / 16.0f), (double)(-this.shroom.f_104202_ / 16.0f)).m_82520_(0.0, 0.5, 0.0).m_82496_(-this.f_102808_.f_104203_).m_82524_(this.f_102808_.f_104204_).m_82524_(-((float)Math.toRadians(entity.m_146908_()))).m_82541_().m_82542_(dist, dist, dist);
            Vec3 offset = entity.m_20299_(Minecraft.m_91087_().m_91297_());
            Vec3 pos = offset.m_82549_(dir);
            int particleCount = 15;
            for (int i = 0; i < particleCount; ++i) {
                int particleColor = 10725632;
                float red = (float)(particleColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(particleColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(particleColor & 0xFF) / 255.0f;
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, pos.f_82479_, pos.f_82480_ + (double)(entity.m_21187_().nextFloat() * 0.15f) - 0.25, pos.f_82481_, (double)red, (double)green, (double)blue);
            }
        }
    }
}

