/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.entity.entity.wraith.VaultWraithEntity;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class VaultWraithModel
extends HumanoidModel<VaultWraithEntity> {
    public final ModelPart f_102810_;
    public final ModelPart f_102811_;
    public final ModelPart f_102812_;
    private double offset;
    private float alphaMult;

    public VaultWraithModel(ModelPart root) {
        super(root, RenderType::m_110473_);
        this.f_102810_ = root.m_171324_("body");
        this.f_102811_ = root.m_171324_("right_arm");
        this.f_102812_ = root.m_171324_("left_arm");
    }

    public static LayerDefinition small() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -6.0f, -5.0f, 10.0f, 23.0f, 10.0f), PartPose.f_171404_);
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171481_(-2.0f, 3.5f, 20.0f, 4.0f, 8.0f, 2.0f).m_171514_(0, 33).m_171481_(-3.0f, 7.5f, 14.0f, 6.0f, 7.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)-7.5f, (float)1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(24, 33).m_171481_(-4.0f, -2.0f, -2.0f, 5.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-1.0f, -2.0f, -2.0f, 5.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public static LayerDefinition wide() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-6.0f, -6.0f, -6.0f, 12.0f, 23.0f, 12.0f), PartPose.f_171404_);
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(48, 18).m_171481_(-3.0f, 3.5f, 19.0f, 6.0f, 8.0f, 4.0f).m_171514_(0, 35).m_171481_(-4.0f, 7.5f, 13.0f, 8.0f, 7.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-7.5f, (float)1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(32, 35).m_171481_(-5.0f, -2.0f, -3.0f, 7.0f, 12.0f, 6.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171481_(-2.0f, -2.0f, -3.0f, 7.0f, 12.0f, 6.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(VaultWraithEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Random rng = new Random(entity.m_142049_());
        float time = ageInTicks + (float)rng.nextInt(10000000);
        this.f_102812_.f_104203_ = (float)Math.toRadians(-50.0f + rng.nextFloat() * 20.0f);
        this.f_102811_.f_104203_ = (float)Math.toRadians(-50.0f + rng.nextFloat() * 20.0f);
        this.f_102812_.f_104205_ = (float)Math.toRadians(-110.0f + (float)Math.cos(time / (float)(8 + rng.nextInt(2))) * (8.0f + rng.nextFloat() * 8.0f));
        this.f_102811_.f_104205_ = (float)Math.toRadians(110.0f + (float)Math.cos((time + 300.0f) / (float)(8 + rng.nextInt(2))) * (8.0f + rng.nextFloat() * 8.0f));
        this.offset = Math.sin(time / 16.0f) * 0.1 + 0.15;
        this.alphaMult = 0.5f + (float)Math.sin(time / 20.0f) * 0.3f;
    }

    public void m_7695_(PoseStack matrix, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrix.m_85836_();
        matrix.m_85837_(0.0, this.offset, 0.0);
        this.f_102810_.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha *= this.alphaMult);
        this.f_102812_.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.f_102811_.m_104306_(matrix, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrix.m_85849_();
    }
}

