/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.model.elite;

import iskallia.vault.client.gui.helper.Easing;
import iskallia.vault.util.IScalablePart;
import javax.annotation.Nonnull;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Monster;

public class EliteSpiderModel<T extends Monster>
extends SpiderModel<T> {
    private final ModelPart body1;
    private final ModelPart egg1;
    private final ModelPart egg2;

    public EliteSpiderModel(ModelPart root) {
        super(root);
        this.body1 = root.m_171324_("body1");
        this.egg1 = this.body1.m_171324_("egg1");
        this.egg2 = this.body1.m_171324_("egg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-3.0f));
        PartDefinition body0 = partdefinition.m_171599_("body0", CubeListBuilder.m_171558_().m_171514_(32, 34).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition body1 = partdefinition.m_171599_("body1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)9.0f));
        PartDefinition body4_r1 = body1.m_171599_("body4_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -21.0f, 14.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -20.0f, 4.0f, 14.0f, 15.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-9.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition egg1 = body1.m_171599_("egg1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)-14.8041f, (float)-0.9616f));
        PartDefinition egg1_r1 = egg1.m_171599_("egg1_r1", CubeListBuilder.m_171558_().m_171514_(43, 0).m_171488_(-3.5f, -1.5f, -3.0f, 7.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition egg2 = body1.m_171599_("egg2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)-13.5584f, (float)-4.2704f));
        PartDefinition egg2_r1 = egg2.m_171599_("egg2_r1", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-2.5f, -1.0f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)-0.7854f));
        PartDefinition left_hind_leg = partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)15.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.7854f));
        PartDefinition right_middle_hind_leg = partdefinition.m_171599_("right_middle_hind_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)1.0f, (float)0.0f, (float)0.2618f, (float)-0.6109f));
        PartDefinition left_middle_hind_leg = partdefinition.m_171599_("left_middle_hind_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)15.0f, (float)1.0f, (float)0.0f, (float)-0.2618f, (float)0.6109f));
        PartDefinition right_middle_front_leg = partdefinition.m_171599_("right_middle_front_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)-0.6109f));
        PartDefinition left_middle_front_leg = partdefinition.m_171599_("left_middle_front_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)15.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.6109f));
        PartDefinition right_front_leg = partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)-0.7854f, (float)-0.7854f));
        PartDefinition left_front_leg = partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)0.7854f, (float)0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@Nonnull T pEntity, float limbSwing, float pLimbSwingAmount, float ageInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, limbSwing, pLimbSwingAmount, ageInTicks, pNetHeadYaw, pHeadPitch);
        this.body1.f_104203_ = -(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.15f) * pLimbSwingAmount;
        this.body1.f_104205_ = -(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.15f) * pLimbSwingAmount;
        float egg1Scale = (Easing.EASE_IN_OUT_SINE.calc(ageInTicks / 20.0f) + 3.5f) / 4.0f;
        float egg1Scale2 = (Easing.EASE_IN_OUT_SINE.calc(ageInTicks / 5.0f) + 4.5f) / 4.0f;
        ((IScalablePart)this.egg1).getScale().m_122245_(egg1Scale, egg1Scale2, egg1Scale);
        float egg2Scale = (Easing.EASE_IN_OUT_SINE.calc(ageInTicks / 10.0f + (float)pEntity.m_142049_()) + 4.0f) / 4.0f;
        float egg2Scale2 = (Easing.EASE_IN_OUT_SINE.calc(ageInTicks / 3.0f + (float)pEntity.m_142049_()) + 4.0f) / 4.0f;
        ((IScalablePart)this.egg2).getScale().m_122245_(egg2Scale, egg2Scale2, egg2Scale);
    }
}

