/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.model.plastic;

import com.mojang.math.Vector3f;
import iskallia.vault.entity.entity.plastic.PlasticSkeletonEntity;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class AdjustableSkeletonModel
extends SkeletonModel<PlasticSkeletonEntity> {
    protected Vector3f headPos = Vector3f.f_176763_;
    protected Vector3f hatPos = Vector3f.f_176763_;
    protected Vector3f bodyPos = Vector3f.f_176763_;
    protected Vector3f rightArmPos = new Vector3f(-5.0f, 2.0f, 0.0f);
    protected Vector3f leftArmPos = new Vector3f(5.0f, 2.0f, 0.0f);
    protected Vector3f rightLegPos = new Vector3f(0.0f, 12.0f, 0.0f);
    protected Vector3f leftLegPos = new Vector3f(0.0f, 12.0f, 0.0f);

    public AdjustableSkeletonModel(ModelPart root) {
        super(root);
    }

    public AdjustableSkeletonModel setHeadPos(Vector3f headPos) {
        this.headPos = headPos;
        return this;
    }

    public AdjustableSkeletonModel setHatPos(Vector3f hatPos) {
        this.hatPos = hatPos;
        return this;
    }

    public AdjustableSkeletonModel setBodyPos(Vector3f bodyPos) {
        this.bodyPos = bodyPos;
        return this;
    }

    public AdjustableSkeletonModel setRightArmPos(Vector3f rightArmPos) {
        this.rightArmPos = rightArmPos;
        return this;
    }

    public AdjustableSkeletonModel setLeftArmPos(Vector3f leftArmPos) {
        this.leftArmPos = leftArmPos;
        return this;
    }

    public AdjustableSkeletonModel setRightLegPos(Vector3f rightLegPos) {
        this.rightLegPos = rightLegPos;
        return this;
    }

    public AdjustableSkeletonModel setLeftLegPos(Vector3f leftLegPos) {
        this.leftLegPos = leftLegPos;
        return this;
    }

    public void setupAnim(@NotNull PlasticSkeletonEntity skeleton, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch) {
        boolean isAggressiveWithoutBow;
        boolean isRightArm;
        this.f_102808_.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102811_.f_104200_ = this.rightArmPos.m_122239_();
        this.f_102811_.f_104202_ = this.rightArmPos.m_122269_();
        this.f_102812_.f_104200_ = this.leftArmPos.m_122239_();
        this.f_102812_.f_104202_ = this.leftArmPos.m_122269_();
        float limbSwingFactor = 0.6662f;
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * limbSwingFactor + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * limbSwingFactor)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * limbSwingFactor)) * 1.4f * limbSwingAmount;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * limbSwingFactor + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        this.f_102813_.f_104205_ = 0.0f;
        this.f_102814_.f_104205_ = 0.0f;
        if (this.f_102609_) {
            this.f_102811_.f_104203_ += -0.62831855f;
            this.f_102812_.f_104203_ += -0.62831855f;
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = 0.31415927f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = -0.31415927f;
            this.f_102814_.f_104205_ = -0.07853982f;
        }
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        boolean bl = isRightArm = skeleton.m_5737_() == HumanoidArm.RIGHT;
        if (skeleton.m_6117_()) {
            boolean isMainHand;
            boolean bl2 = isMainHand = skeleton.m_7655_() == InteractionHand.MAIN_HAND;
            if (isMainHand == isRightArm) {
                this.poseRightArm();
            } else {
                this.poseLeftArm();
            }
        } else {
            boolean isMainHand;
            boolean bl3 = isMainHand = isRightArm ? this.f_102815_.m_102897_() : this.f_102816_.m_102897_();
            if (isRightArm != isMainHand) {
                this.poseLeftArm();
                this.poseRightArm();
            } else {
                this.poseRightArm();
                this.poseLeftArm();
            }
        }
        this.m_7884_((LivingEntity)skeleton, age);
        this.resetModel();
        AnimationUtils.m_170341_((ModelPart)this.f_102811_, (float)age, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.f_102812_, (float)age, (float)-1.0f);
        this.f_102809_.m_104315_(this.f_102808_);
        ItemStack itemInHand = skeleton.m_21205_();
        boolean bl4 = isAggressiveWithoutBow = skeleton.m_5912_() && (itemInHand.m_41619_() || !itemInHand.m_150930_(Items.f_42411_));
        if (isAggressiveWithoutBow) {
            this.attackWithHands(age);
        }
    }

    private void resetModel() {
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102808_.f_104201_ = this.headPos.m_122260_();
        this.f_102810_.f_104201_ = this.bodyPos.m_122260_();
        this.f_102811_.f_104201_ = this.rightArmPos.m_122260_();
        this.f_102812_.f_104201_ = this.leftArmPos.m_122260_();
        this.f_102813_.f_104201_ = this.rightLegPos.m_122260_();
        this.f_102813_.f_104202_ = this.rightLegPos.m_122269_();
        this.f_102814_.f_104201_ = this.leftLegPos.m_122260_();
        this.f_102814_.f_104202_ = this.leftLegPos.m_122269_();
    }

    private void attackWithHands(float age) {
        float swingProgress = Mth.m_14031_((float)((float)((double)this.f_102608_ * Math.PI)));
        float maxSwing = Mth.m_14031_((float)((float)((double)(1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * Math.PI)));
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102811_.f_104204_ = -(0.1f - swingProgress * 0.6f);
        this.f_102812_.f_104204_ = 0.1f - swingProgress * 0.6f;
        this.f_102811_.f_104203_ = -1.5707964f;
        this.f_102812_.f_104203_ = -1.5707964f;
        ModelPart rightArm = this.f_102811_;
        rightArm.f_104203_ -= swingProgress * 1.2f - maxSwing * 0.4f;
        rightArm = this.f_102812_;
        rightArm.f_104203_ -= swingProgress * 1.2f - maxSwing * 0.4f;
        AnimationUtils.m_102082_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (float)age);
    }

    private void poseRightArm() {
        switch (this.f_102816_) {
            case EMPTY: {
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_;
                this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_ + 0.4f;
                this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
            }
        }
    }

    private void poseLeftArm() {
        switch (this.f_102815_) {
            case EMPTY: {
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_ - 0.4f;
                this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_;
                this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
            }
        }
    }
}

