/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.model.tank;

import iskallia.vault.entity.entity.tank.BloodTankEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BloodTankModel
extends HierarchicalModel<BloodTankEntity> {
    protected Map<Float, List<ModelPart>> breakParts = new HashMap<Float, List<ModelPart>>();
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public BloodTankModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        for (float threshold = 0.75f; threshold > 0.0f; threshold -= 0.25f) {
            int i = (int)(4.0f - threshold / 0.25f);
            List parts = this.breakParts.computeIfAbsent(Float.valueOf(threshold), v -> new ArrayList());
            parts.add(this.head.m_171324_("headbreak" + i));
            parts.add(this.body.m_171324_("bodybreak" + i));
            parts.add(this.rightArm.m_171324_("rarmbreak" + i));
            parts.add(this.leftArm.m_171324_("larmbreak" + i));
            parts.add(this.rightLeg.m_171324_("rlegbreak" + i));
            parts.add(this.leftLeg.m_171324_("llegbreak" + i));
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 72).m_171488_(-2.5f, 9.0f, -2.0f, 5.0f, 0.25f, 4.0f, new CubeDeformation(0.5f)).m_171514_(18, 78).m_171488_(-7.5f, 3.0f, 2.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171514_(17, 82).m_171488_(-7.5f, 3.0f, -4.0f, 6.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171514_(45, 11).m_171488_(-7.5f, 3.0f, -3.0f, 0.0f, 0.25f, 4.0f, new CubeDeformation(0.5f)).m_171514_(18, 78).m_171488_(-7.5f, 5.0f, 2.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171514_(45, 11).m_171488_(-7.5f, 5.0f, -3.0f, 0.0f, 0.25f, 4.0f, new CubeDeformation(0.5f)).m_171514_(29, 80).m_171488_(-7.5f, 5.0f, -4.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171514_(18, 78).m_171488_(-7.5f, 7.0f, 2.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171514_(45, 11).m_171488_(-7.5f, 7.0f, -3.0f, 0.0f, 0.25f, 4.0f, new CubeDeformation(0.5f)).m_171514_(17, 80).m_171488_(-7.5f, 7.0f, -4.0f, 4.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171514_(18, 78).m_171480_().m_171488_(2.5f, 3.0f, 2.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(45, 11).m_171480_().m_171488_(7.5f, 3.0f, -3.0f, 0.0f, 0.25f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(17, 82).m_171480_().m_171488_(1.5f, 3.0f, -4.0f, 6.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(29, 80).m_171480_().m_171488_(2.5f, 5.0f, -4.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(45, 11).m_171480_().m_171488_(7.5f, 5.0f, -3.0f, 0.0f, 0.25f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(18, 78).m_171480_().m_171488_(2.5f, 5.0f, 2.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(45, 11).m_171480_().m_171488_(7.5f, 7.0f, -3.0f, 0.0f, 0.25f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(18, 78).m_171480_().m_171488_(2.5f, 7.0f, 2.0f, 5.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(17, 80).m_171480_().m_171488_(3.5f, 7.0f, -4.0f, 4.0f, 0.25f, 0.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(0, 72).m_171488_(-2.0f, 2.0f, -1.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).m_171514_(0, 64).m_171488_(6.5f, -1.75f, -3.0f, 2.5f, 1.75f, 6.0f, new CubeDeformation(0.5f)).m_171514_(0, 64).m_171480_().m_171488_(-9.0f, -1.75f, -3.0f, 2.5f, 1.75f, 6.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(0, 51).m_171488_(-5.5f, -1.75f, -5.0f, 11.0f, 3.0f, 10.0f, new CubeDeformation(0.5f)).m_171514_(30, 73).m_171488_(2.0f, 15.0f, -3.0f, 4.5f, 0.25f, 5.0f, new CubeDeformation(0.5f)).m_171514_(33, 53).m_171488_(-6.5f, 15.0f, -3.0f, 4.5f, 0.25f, 5.0f, new CubeDeformation(0.5f)).m_171514_(0, 83).m_171488_(-6.5f, 10.25f, -3.0f, 13.0f, 3.75f, 5.0f, new CubeDeformation(0.5f)).m_171514_(0, 51).m_171488_(-7.0f, 10.25f, -3.0f, -0.5f, 3.75f, 5.0f, new CubeDeformation(0.5f)).m_171514_(0, 51).m_171480_().m_171488_(7.5f, 10.25f, -3.0f, -0.5f, 3.75f, 5.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition bodybreak1 = body.m_171599_("bodybreak1", CubeListBuilder.m_171558_().m_171514_(84, 41).m_171488_(-8.1f, 4.0f, -5.0f, 7.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodybreak2 = body.m_171599_("bodybreak2", CubeListBuilder.m_171558_().m_171514_(84, 41).m_171480_().m_171488_(1.1f, 4.0f, -5.0f, 7.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(84, 19).m_171488_(-8.25f, -2.3f, -6.0f, 8.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(53, 56).m_171488_(1.0f, 13.0f, -4.0f, 7.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodybreak3 = body.m_171599_("bodybreak3", CubeListBuilder.m_171558_().m_171514_(53, 46).m_171488_(1.0f, 10.0f, -4.0f, 7.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(49, 33).m_171488_(-8.0f, 10.0f, -4.0f, 9.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(84, 19).m_171480_().m_171488_(0.25f, -2.3f, -6.0f, 8.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(89, 24).m_171480_().m_171488_(-3.75f, -2.3f, -1.0f, 8.0f, 7.0f, 7.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = bodybreak3.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -12.0f, -5.5f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(64, 0).m_171488_(-4.0f, -12.0f, -5.5f, 8.0f, 9.2f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-2.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -3.0f, -7.5f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.7f, (float)2.2f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition headbreak1 = head.m_171599_("headbreak1", CubeListBuilder.m_171558_().m_171514_(64, 101).m_171488_(3.0f, -12.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(59, 93).m_171488_(-5.25f, -8.75f, -6.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(93, 92).m_171488_(1.48f, -11.1f, -4.2f, 2.77f, 5.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headbreak2 = head.m_171599_("headbreak2", CubeListBuilder.m_171558_().m_171514_(73, 117).m_171488_(-4.75f, -12.35f, -6.2f, 9.0f, 2.0f, 9.0f, new CubeDeformation(-0.02f)).m_171514_(65, 116).m_171488_(-0.5f, -11.0f, -6.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(72, 93).m_171488_(2.1f, -14.0f, -6.1f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headbreak3 = head.m_171599_("headbreak3", CubeListBuilder.m_171558_().m_171514_(72, 104).m_171488_(-3.9f, -13.0f, -3.1f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(86, 109).m_171488_(-5.9f, -11.0f, 0.9f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(99, 109).m_171488_(3.1f, -11.0f, 0.9f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(45, 102).m_171488_(-0.75f, -12.1f, -4.2f, 5.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(44, 116).m_171488_(-4.75f, -11.1f, -4.2f, 6.25f, 5.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-15.0f, -2.5f, -3.0f, 6.0f, 30.0f, 6.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition rarmbreak1 = right_arm.m_171599_("rarmbreak1", CubeListBuilder.m_171558_().m_171514_(67, 67).m_171488_(-15.0f, 1.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rarmbreak2 = right_arm.m_171599_("rarmbreak2", CubeListBuilder.m_171558_().m_171514_(20, 66).m_171488_(-18.0f, -4.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rarmbreak3 = right_arm.m_171599_("rarmbreak3", CubeListBuilder.m_171558_().m_171514_(47, 18).m_171480_().m_171488_(-15.0f, 19.5f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(43, 72).m_171488_(-16.0f, -2.5f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171480_().m_171488_(9.0f, -2.5f, -3.0f, 6.0f, 30.0f, 6.0f, new CubeDeformation(-0.4f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition larmbreak1 = left_arm.m_171599_("larmbreak1", CubeListBuilder.m_171558_().m_171514_(20, 66).m_171480_().m_171488_(11.0f, -4.0f, -1.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition larmbreak2 = left_arm.m_171599_("larmbreak2", CubeListBuilder.m_171558_().m_171514_(47, 18).m_171488_(9.0f, 19.5f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition larmbreak3 = left_arm.m_171599_("larmbreak3", CubeListBuilder.m_171558_().m_171514_(43, 72).m_171480_().m_171488_(8.0f, -2.5f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(67, 67).m_171480_().m_171488_(9.0f, 1.0f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(24, 15).m_171480_().m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(-0.4f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)11.0f, (float)0.0f));
        PartDefinition rlegbreak1 = right_leg.m_171599_("rlegbreak1", CubeListBuilder.m_171558_().m_171514_(25, 37).m_171488_(-3.5f, 6.0f, -3.0f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rlegbreak2 = right_leg.m_171599_("rlegbreak2", CubeListBuilder.m_171558_().m_171514_(71, 19).m_171480_().m_171488_(-3.5f, -2.0f, -3.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rlegbreak3 = right_leg.m_171599_("rlegbreak3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(24, 15).m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        PartDefinition llegbreak1 = left_leg.m_171599_("llegbreak1", CubeListBuilder.m_171558_().m_171514_(71, 19).m_171488_(-3.5f, -2.0f, -3.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition llegbreak2 = left_leg.m_171599_("llegbreak2", CubeListBuilder.m_171558_().m_171514_(25, 37).m_171480_().m_171488_(-3.5f, 6.0f, -3.0f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition llegbreak3 = left_leg.m_171599_("llegbreak3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(@NotNull BloodTankEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.rightLeg.f_104203_ = -1.5f * Mth.m_14156_((float)pLimbSwing, (float)13.0f) * pLimbSwingAmount;
        this.leftLeg.f_104203_ = 1.5f * Mth.m_14156_((float)pLimbSwing, (float)13.0f) * pLimbSwingAmount;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        float healthPercentage = entity.m_21223_() / entity.m_21233_();
        this.breakParts.forEach((threshold, modelParts) -> modelParts.forEach(part -> {
            part.f_104207_ = healthPercentage > threshold.floatValue();
        }));
    }

    public void prepareMobModel(BloodTankEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        int i = pEntity.getAttackAnimationTick();
        if (i > 0) {
            this.rightArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - pPartialTick), (float)10.0f);
            this.leftArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - pPartialTick), (float)10.0f);
        }
    }
}

