/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.ElixirOrbEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ElixirOrbRenderer
extends EntityRenderer<ElixirOrbEntity> {
    private static final ResourceLocation EXPERIENCE_ORB_LOCATION = VaultMod.id("textures/entity/elixir_orb.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110467_((ResourceLocation)EXPERIENCE_ORB_LOCATION);

    public ElixirOrbRenderer(EntityRendererProvider.Context p_174110_) {
        super(p_174110_);
        this.f_114477_ = 0.15f;
        this.f_114478_ = 0.75f;
    }

    protected int getBlockLightLevel(ElixirOrbEntity pEntity, BlockPos pPos) {
        return Mth.m_14045_((int)(super.m_6086_((Entity)pEntity, pPos) + 7), (int)0, (int)15);
    }

    public void render(ElixirOrbEntity orb, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        int i = Math.abs(orb.getSize());
        float f = (float)(i % 4 * 16 + 0) / 64.0f;
        float f1 = (float)(i % 4 * 16 + 16) / 64.0f;
        float f2 = (float)(i / 4 * 16 + 0) / 64.0f;
        float f3 = (float)(i / 4 * 16 + 16) / 64.0f;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        float f7 = 255.0f;
        float f8 = ((float)orb.f_19797_ + pPartialTicks) / 2.0f;
        int j = (int)((Mth.m_14031_((float)(f8 + 0.0f)) + 1.0f) * 0.5f * 255.0f);
        int k = 255;
        int l = (int)((Mth.m_14031_((float)(f8 + 4.1887903f)) + 1.0f) * 0.1f * 255.0f);
        if (orb.getSize() >= 0) {
            j = 194;
            k = 19;
            l = 231;
        } else {
            j = 255;
            k = 0;
            l = 0;
        }
        pMatrixStack.m_85837_(0.0, (double)0.1f, 0.0);
        pMatrixStack.m_85845_(this.f_114476_.m_114470_());
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        float f9 = 0.3f;
        pMatrixStack.m_85841_(0.3f, 0.3f, 0.3f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RENDER_TYPE);
        PoseStack.Pose posestack$pose = pMatrixStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_85861_();
        Matrix3f matrix3f = posestack$pose.m_85864_();
        ElixirOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, -0.5f, -0.25f, j, k, l, f, f3, pPackedLight, Math.min(orb.getAge() * 6, 128));
        ElixirOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 0.5f, -0.25f, j, k, l, f1, f3, pPackedLight, Math.min(orb.getAge() * 6, 128));
        ElixirOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 0.5f, 0.75f, j, k, l, f1, f2, pPackedLight, Math.min(orb.getAge() * 6, 128));
        ElixirOrbRenderer.vertex(vertexconsumer, matrix4f, matrix3f, -0.5f, 0.75f, j, k, l, f, f2, pPackedLight, Math.min(orb.getAge() * 6, 128));
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)orb, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    private static void vertex(VertexConsumer pBuffer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight, int alpha) {
        pBuffer.m_85982_(pMatrix, pX, pY, 0.0f).m_6122_(pRed, pGreen, pBlue, alpha).m_7421_(pTexU, pTexV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(pMatrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(ElixirOrbEntity pEntity) {
        return EXPERIENCE_ORB_LOCATION;
    }
}

