/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.IceBoltEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IceBoltRenderer
extends EntityRenderer<IceBoltEntity> {
    public static final ResourceLocation ARROW_TEXTURE = VaultMod.id("textures/entity/blizzard_shard.png");
    public static final ResourceLocation CHUNK_TEXTURE = VaultMod.id("textures/entity/ice_bolt_chunk.png");
    private final ChunkModel chunk = new ChunkModel(ChunkModel.getMesh().m_171564_());

    public IceBoltRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(IceBoltEntity entity) {
        return null;
    }

    public void render(IceBoltEntity entity, float yaw, float partialTicks, PoseStack matrices, MultiBufferSource buffers, int light) {
        if (entity.getModel() == IceBoltEntity.Model.ARROW) {
            this.renderArrow(entity, partialTicks, matrices, buffers, light);
        } else if (entity.getModel() == IceBoltEntity.Model.CHUNK) {
            matrices.m_85836_();
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()) - 90.0f));
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_()) + 90.0f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)((float)(entity.f_19797_ - 1) * 15.0f), (float)((float)entity.f_19797_ * 15.0f))));
            VertexConsumer buffer = buffers.m_6299_(RenderType.m_110473_((ResourceLocation)CHUNK_TEXTURE));
            this.chunk.m_7695_(matrices, buffer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.4f);
            matrices.m_85849_();
        }
        super.m_7392_((Entity)entity, yaw, partialTicks, matrices, buffers, light);
    }

    private void renderArrow(IceBoltEntity entity, float partialTicks, PoseStack matrices, MultiBufferSource buffers, int light) {
        matrices.m_85836_();
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()) - 90.0f));
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        float elapsed = (float)entity.f_36706_ - partialTicks;
        if (elapsed > 0.0f) {
            float f10 = -Mth.m_14031_((float)(elapsed * 3.0f)) * elapsed;
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(f10));
        }
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
        matrices.m_85841_(0.05625f, 0.05625f, 0.05625f);
        matrices.m_85837_(-4.0, 0.0, 0.0);
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110452_((ResourceLocation)ARROW_TEXTURE));
        PoseStack.Pose last = matrices.m_85850_();
        Matrix4f matrix4f = last.m_85861_();
        Matrix3f matrix3f = last.m_85864_();
        this.vertex(matrix4f, matrix3f, buffer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, light);
        this.vertex(matrix4f, matrix3f, buffer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, light);
        this.vertex(matrix4f, matrix3f, buffer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, light);
        this.vertex(matrix4f, matrix3f, buffer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, light);
        this.vertex(matrix4f, matrix3f, buffer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, light);
        this.vertex(matrix4f, matrix3f, buffer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, light);
        this.vertex(matrix4f, matrix3f, buffer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, light);
        this.vertex(matrix4f, matrix3f, buffer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, light);
        for (int j = 0; j < 4; ++j) {
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            this.vertex(matrix4f, matrix3f, buffer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, light);
            this.vertex(matrix4f, matrix3f, buffer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, light);
            this.vertex(matrix4f, matrix3f, buffer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, light);
            this.vertex(matrix4f, matrix3f, buffer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, light);
        }
        matrices.m_85849_();
    }

    public void vertex(Matrix4f pose, Matrix3f normal, VertexConsumer buffer, int x, int y, int z, float u, float v, int normalX, int normalZ, int normalY, int light) {
        buffer.m_85982_(pose, (float)x, (float)y, (float)z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normal, (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }

    public static class ChunkModel
    extends Model {
        protected final ModelPart main;

        public ChunkModel(ModelPart root) {
            super(RenderType::m_110458_);
            this.main = root.m_171324_("main");
        }

        public void m_7695_(PoseStack matrices, VertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha) {
            this.main.m_104306_(matrices, buffer, light, overlay, red, green, blue, alpha);
        }

        public static LayerDefinition getMesh() {
            MeshDefinition data = new MeshDefinition();
            PartDefinition root = data.m_171576_();
            root.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -12.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 36).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(26, 10).m_171488_(-3.0f, -11.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(40, 38).m_171488_(-3.0f, 1.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(40, 26).m_171488_(-3.0f, -5.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)data, (int)64, (int)64);
        }
    }
}

