/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.renderer.PlayerSkinUpdater;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.mixin.AccessorAgeableListModel;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PetRenderer
extends EntityRenderer<PetEntity> {
    private final EntityRendererProvider.Context renderContext;
    private final PetPlayerRenderer stevePetRenderer;
    private final PetPlayerRenderer alexPetRenderer;

    public PetRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.renderContext = context;
        PlayerPetModel steveModel = new PlayerPetModel(context.m_174027_().m_171103_(ModelLayers.f_171162_), false);
        this.stevePetRenderer = new PetPlayerRenderer(context, steveModel, ModelLayers.f_171164_, ModelLayers.f_171165_);
        PlayerPetModel alexModel = new PlayerPetModel(context.m_174027_().m_171103_(ModelLayers.f_171166_), true);
        this.alexPetRenderer = new PetPlayerRenderer(context, alexModel, ModelLayers.f_171164_, ModelLayers.f_171165_);
    }

    public void render(PetEntity pet, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        CompanionSeries series = pet.getPetSeries();
        if (series == CompanionSeries.LEGEND) {
            (pet.hasSlimSkin() ? this.alexPetRenderer : this.stevePetRenderer).m_7392_((LivingEntity)pet, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    protected boolean shouldShowName(PetEntity entity) {
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        return options.getCompanionNametagMode() != IVaultOptions.CompanionNametagMode.NEVER && this.f_114476_.f_114359_ == entity;
    }

    public ResourceLocation getTextureLocation(PetEntity entity) {
        return DefaultPlayerSkin.m_118626_();
    }

    private static void setHeadScale(HumanoidModel<?> playerModel) {
        if (playerModel instanceof AccessorAgeableListModel) {
            AccessorAgeableListModel accessor = (AccessorAgeableListModel)playerModel;
            accessor.setHeadScale(true);
            accessor.setBabyHeadScale(1.0f);
            accessor.setBabyYHeadOffset(8.0f);
        }
    }

    static class PlayerPetModel
    extends PlayerModel<PetEntity> {
        private float red = 1.0f;
        private float green = 1.0f;
        private float blue = 1.0f;

        public PlayerPetModel(ModelPart root, boolean slim) {
            super(root, slim);
            this.f_102610_ = true;
            PlayerPetModel playerPetModel = this;
            if (playerPetModel instanceof AccessorAgeableListModel) {
                AccessorAgeableListModel accessor = (AccessorAgeableListModel)((Object)playerPetModel);
                accessor.setHeadScale(true);
                accessor.setBabyHeadScale(1.0f);
                accessor.setBabyYHeadOffset(8.0f);
            }
        }

        protected Iterable<ModelPart> m_5607_() {
            return List.of(this.f_102808_, this.f_102809_);
        }

        public void setColor(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            super.m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, this.red, this.green, this.blue, pAlpha);
        }
    }

    private static class PetPlayerRenderer
    extends LivingEntityRenderer<PetEntity, PlayerPetModel> {
        private PlayerSkinUpdater playerSkinUpdater = new PlayerSkinUpdater();

        public PetPlayerRenderer(EntityRendererProvider.Context context, PlayerPetModel model, ModelLayerLocation innerArmorLayer, ModelLayerLocation outerArmorLayer) {
            super(context, (EntityModel)model, 0.5f);
            HumanoidModel innerArmorModel = new HumanoidModel(context.m_174023_(innerArmorLayer));
            PetRenderer.setHeadScale(innerArmorModel);
            HumanoidModel outerArmorModel = new HumanoidModel(context.m_174023_(outerArmorLayer));
            PetRenderer.setHeadScale(outerArmorModel);
            this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, innerArmorModel, outerArmorModel));
            this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        }

        public ResourceLocation getTextureLocation(PetEntity pet) {
            CompanionSeries series = pet.getPetSeries();
            if (series == CompanionSeries.LEGEND) {
                return pet.getSkinLocation().orElseGet(() -> pet.getGameProfile().map(gp -> this.playerSkinUpdater.updatePlayerSkin(pet, (GameProfile)gp)).orElse(DefaultPlayerSkin.m_118626_()));
            }
            return DefaultPlayerSkin.m_118626_();
        }

        protected void scale(PetEntity entity, PoseStack poseStack, float partialTickTime) {
            if (entity.getPetSeries().equals((Object)CompanionSeries.LEGEND)) {
                if (entity.getPetType().equalsIgnoreCase("minion")) {
                    poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                } else if (entity.getPetType().equalsIgnoreCase("antlion")) {
                    poseStack.m_85841_(0.1667f, 0.1667f, 0.1667f);
                } else if (entity.getPetType().equalsIgnoreCase("giant")) {
                    poseStack.m_85841_(1.5f, 1.5f, 1.5f);
                }
            }
        }

        protected boolean shouldShowName(PetEntity entity) {
            IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
            IVaultOptions.CompanionNametagMode mode = options.getCompanionNametagMode();
            if (mode == IVaultOptions.CompanionNametagMode.NEVER) {
                return false;
            }
            return this.f_114476_.f_114359_ == entity && super.m_6512_((LivingEntity)entity);
        }

        protected void renderNameTag(PetEntity pEntity, Component pDisplayName, PoseStack pose, MultiBufferSource pBuffer, int pPackedLight) {
            pose.m_85836_();
            if (pEntity.getPetSeries().equals((Object)CompanionSeries.LEGEND)) {
                if (pEntity.getPetType().equalsIgnoreCase("minion")) {
                    pose.m_85837_(0.0, -0.5, 0.0);
                } else if (pEntity.getPetType().equalsIgnoreCase("antlion")) {
                    pose.m_85837_(0.0, -1.0, 0.0);
                } else if (pEntity.getPetType().equalsIgnoreCase("giant")) {
                    pose.m_85837_(0.0, 1.0, 0.0);
                }
            }
            super.m_7649_((Entity)pEntity, pDisplayName, pose, pBuffer, pPackedLight);
            pose.m_85849_();
        }
    }
}

