/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import iskallia.vault.entity.IPlayerSkinHolder;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class PlayerSkinUpdater {
    public ResourceLocation updatePlayerSkin(IPlayerSkinHolder entity, GameProfile gameProfile) {
        if (entity.isUpdatingSkin()) {
            return DefaultPlayerSkin.m_118626_();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (gameProfile.getProperties().containsKey((Object)"textures")) {
            this.setSkinData(minecraft, gameProfile, entity);
            return entity.getSkinLocation().orElse(DefaultPlayerSkin.m_118626_());
        }
        entity.startUpdatingSkin();
        SkullBlockEntity.m_155738_((GameProfile)gameProfile, gp -> {
            entity.setGameProfile((GameProfile)gp);
            if (!gp.getProperties().containsKey((Object)"textures")) {
                entity.setSkinLocation(DefaultPlayerSkin.m_118626_());
            } else {
                this.setSkinData(minecraft, (GameProfile)gp, entity);
            }
            entity.stopUpdatingSkin();
        });
        return DefaultPlayerSkin.m_118626_();
    }

    private void setSkinData(Minecraft minecraft, GameProfile gameProfile, IPlayerSkinHolder entity) {
        SkinManager skinManager = minecraft.m_91109_();
        Map skinInfo = skinManager.m_118815_(gameProfile);
        if (skinInfo.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)skinInfo.get(MinecraftProfileTexture.Type.SKIN);
            entity.setSkinLocation(minecraft.m_91109_().m_118825_(profileTexture, MinecraftProfileTexture.Type.SKIN));
            String metadata = profileTexture.getMetadata("model");
            entity.setSlimSkin(metadata != null && !metadata.equals("default"));
        } else {
            entity.setSkinLocation(DefaultPlayerSkin.m_118626_());
            entity.setSlimSkin(false);
        }
    }
}

