/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.TeamTaskScoreboardEntity;
import iskallia.vault.world.data.TeamTaskData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class TeamTaskScoreboardRenderer
extends EntityRenderer<TeamTaskScoreboardEntity> {
    private static final ResourceLocation TEXTURE = VaultMod.id("textures/entity/team_task_scoreboard_front.png");
    private static final ResourceLocation BACK_TEXTURE = VaultMod.id("textures/entity/team_task_scoreboard_back.png");

    public TeamTaskScoreboardRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(TeamTaskScoreboardEntity scoreboard, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float f = 0.0625f;
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        this.renderBase(poseStack, buffer, scoreboard, scoreboard.m_7076_(), scoreboard.m_7068_());
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85845_(scoreboard.m_6350_().m_122406_());
        poseStack.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
        this.drawStandings(poseStack, scoreboard.m_183503_(), buffer, packedLight, scoreboard.m_7076_(), scoreboard.m_7068_());
        poseStack.m_85849_();
        super.m_7392_((Entity)scoreboard, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void drawStandings(PoseStack poseStack, Level level, MultiBufferSource buffer, int pPackedLight, int width, int height) {
        Font font = Minecraft.m_91087_().f_91062_;
        float left = (float)(-width) / 2.0f / 16.0f + 0.125f;
        float innerWidth = (float)width / 16.0f - 0.125f - 0.125f;
        float yOffset = (float)(-height) / 2.0f / 16.0f + (float)height / 16.0f - 0.125f;
        float innerHeight = (float)height / 16.0f - 0.125f - 0.125f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)left, (double)yOffset, 0.0313125);
        float scale = Math.min(0.025f, (float)width / 16.0f / 4.0f / 30.0f);
        poseStack.m_85841_(scale, -scale, scale);
        int padding = 2;
        poseStack.m_85837_((double)padding, (double)padding, 0.0);
        int innerFontPixels = (int)(innerWidth / scale) - padding * 2;
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        int y = 0;
        font.m_92841_((Component)new TextComponent("Team").m_130940_(ChatFormatting.GRAY), 0.0f, 0.0f, -1, false, pose, buffer, false, 0, pPackedLight);
        MutableComponent pointsLabel = new TextComponent("Points").m_130940_(ChatFormatting.GRAY);
        font.m_92841_((Component)pointsLabel, (float)(innerFontPixels - font.m_92852_((FormattedText)pointsLabel) + 1), 0.0f, -1, false, pose, buffer, false, 0, pPackedLight);
        Objects.requireNonNull(font);
        TeamTaskScoreboardRenderer.fill(poseStack.m_85850_().m_85861_(), buffer.m_6299_(RenderType.m_110502_()), -1, y += 9, innerFontPixels + 1, y + 1, ChatFormatting.GRAY.m_126665_() | 0xFF000000);
        Objects.requireNonNull(font);
        y += 9 / 2;
        TeamTaskData teamTaskData = TeamTaskData.get();
        int i = 0;
        Scoreboard scoreboard = level.m_6188_();
        for (TeamTaskData.TeamScore teamScore : teamTaskData.getTeamScores()) {
            Style pointsColor = switch (i) {
                case 0 -> Style.f_131099_.m_178520_(16766720);
                case 1 -> Style.f_131099_.m_178520_(0xC0C0C0);
                case 2 -> Style.f_131099_.m_178520_(13467442);
                default -> Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY);
            };
            MutableComponent points = new TextComponent(String.valueOf(teamScore.completedTasks().size())).m_130948_(pointsColor);
            PlayerTeam playerTeam = scoreboard.m_83489_(teamScore.teamName());
            if (playerTeam == null) continue;
            FormattedCharSequence team = Language.m_128107_().m_5536_(font.m_92854_((FormattedText)playerTeam.m_83364_().m_6881_().m_130940_(playerTeam.m_7414_()), innerFontPixels - 3 * font.m_92895_("0")));
            font.m_92733_(team, 0.0f, (float)y, -1, false, pose, buffer, false, 0, pPackedLight);
            font.m_92841_((Component)points, (float)(innerFontPixels - font.m_92852_((FormattedText)points) + 1), (float)y, -1, false, pose, buffer, false, 0, pPackedLight);
            Objects.requireNonNull(font);
            y += 9;
            ++i;
            Objects.requireNonNull(font);
            if (!((float)(y + 9) * scale > innerHeight)) continue;
            break;
        }
        poseStack.m_85849_();
        RenderSystem.m_69482_();
    }

    private static void fill(Matrix4f matrix, VertexConsumer buffer, int minX, int minY, int maxX, int maxY, int color) {
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_69465_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_85982_(matrix, (float)minX, (float)maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        buffer.m_85982_(matrix, (float)maxX, (float)maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        buffer.m_85982_(matrix, (float)maxX, (float)minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        buffer.m_85982_(matrix, (float)minX, (float)minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
    }

    private void renderBase(PoseStack poseStack, MultiBufferSource buffer, TeamTaskScoreboardEntity scoreboard, int width, int height) {
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_85861_();
        Matrix3f matrix3f = posestack$pose.m_85864_();
        float xOffset = (float)(-width) / 2.0f;
        float yOffset = (float)(-height) / 2.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f9 = 0.0f;
        float f10 = 0.0625f;
        float f11 = 0.0f;
        float f12 = 0.0625f;
        float f13 = 0.0f;
        float f14 = 1.0f;
        int blockWidth = width / 16;
        int blockHeight = height / 16;
        VertexConsumer backVertexConsumer = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)BACK_TEXTURE));
        for (int blockColumnIndex = 0; blockColumnIndex < blockWidth; ++blockColumnIndex) {
            for (int blockRowIndex = 0; blockRowIndex < blockHeight; ++blockRowIndex) {
                float f15 = xOffset + (float)((blockColumnIndex + 1) * 16);
                float f16 = xOffset + (float)(blockColumnIndex * 16);
                float f17 = yOffset + (float)((blockRowIndex + 1) * 16);
                float f18 = yOffset + (float)(blockRowIndex * 16);
                int lightColor = TeamTaskScoreboardRenderer.getLightColor(scoreboard, f17, f18, f15, f16);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f17, f4, f5, 0.5f, 0, 0, 1, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f17, f3, f5, 0.5f, 0, 0, 1, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f18, f3, f6, 0.5f, 0, 0, 1, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f18, f4, f6, 0.5f, 0, 0, 1, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f17, f7, f9, -0.5f, 0, 1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f17, f8, f9, -0.5f, 0, 1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f17, f8, f10, 0.5f, 0, 1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f17, f7, f10, 0.5f, 0, 1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f18, f7, f9, 0.5f, 0, -1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f18, f8, f9, 0.5f, 0, -1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f18, f8, f10, -0.5f, 0, -1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f18, f7, f10, -0.5f, 0, -1, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f17, f12, f13, 0.5f, -1, 0, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f18, f12, f14, 0.5f, -1, 0, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f18, f11, f14, -0.5f, -1, 0, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f15, f17, f11, f13, -0.5f, -1, 0, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f17, f12, f13, -0.5f, 1, 0, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f18, f12, f14, -0.5f, 1, 0, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f18, f11, f14, 0.5f, 1, 0, 0, lightColor);
                this.vertex(matrix4f, matrix3f, backVertexConsumer, f16, f17, f11, f13, 0.5f, 1, 0, 0, lightColor);
            }
        }
        VertexConsumer frontVertexConsumer = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(scoreboard)));
        float singleBlockQuadHeightPartial = Math.min((float)blockHeight / 2.0f, 1.0f);
        float singleBlockQuadWidthPartial = Math.min((float)blockWidth / 2.0f, 1.0f);
        for (int blockColumnIndex = 0; blockColumnIndex < blockWidth; ++blockColumnIndex) {
            for (int blockRowIndex = 0; blockRowIndex < blockHeight; ++blockRowIndex) {
                boolean lastHorizontal = blockColumnIndex > 0 && blockColumnIndex == blockWidth - 1;
                boolean lastVertical = blockRowIndex > 0 && blockRowIndex == blockHeight - 1;
                float minU = lastHorizontal ? 0.75f : (float)(blockColumnIndex * 16) / 64.0f;
                float maxU = lastHorizontal ? 1.0f : (float)((blockColumnIndex + 1) * 16) / 64.0f * singleBlockQuadWidthPartial;
                float minV = lastVertical ? 0.75f : (float)(blockRowIndex * 16) / 64.0f;
                float maxV = lastVertical ? 1.0f : (float)((blockRowIndex + 1) * 16) / 64.0f * singleBlockQuadHeightPartial;
                this.renderFrontQuad(scoreboard, xOffset, yOffset, matrix4f, matrix3f, frontVertexConsumer, blockColumnIndex * 16, (float)((blockColumnIndex + 1) * 16) * singleBlockQuadWidthPartial, blockRowIndex * 16, (float)((blockRowIndex + 1) * 16) * singleBlockQuadHeightPartial, minU, maxU, minV, maxV);
                if (singleBlockQuadHeightPartial < 1.0f) {
                    this.renderFrontQuad(scoreboard, xOffset, yOffset, matrix4f, matrix3f, frontVertexConsumer, blockColumnIndex * 16, (float)((blockColumnIndex + 1) * 16) * singleBlockQuadWidthPartial, 8.0f, 16.0f, minU, maxU, 0.875f, 1.0f);
                }
                if (singleBlockQuadWidthPartial < 1.0f) {
                    this.renderFrontQuad(scoreboard, xOffset, yOffset, matrix4f, matrix3f, frontVertexConsumer, 8.0f, 16.0f, blockRowIndex * 16, (float)((blockRowIndex + 1) * 16) * singleBlockQuadHeightPartial, 0.875f, 1.0f, minV, maxV);
                }
                if (!(singleBlockQuadWidthPartial < 1.0f) || !(singleBlockQuadHeightPartial < 1.0f)) continue;
                this.renderFrontQuad(scoreboard, xOffset, yOffset, matrix4f, matrix3f, frontVertexConsumer, 8.0f, 16.0f, 8.0f, 16.0f, 0.875f, 1.0f, 0.875f, 1.0f);
            }
        }
    }

    private void renderFrontQuad(TeamTaskScoreboardEntity scoreboard, float xOffset, float yOffset, Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer frontVertexConsumer, float minxXOffset, float maxXOffset, float minYOffset, float maxYOffset, float minU, float maxU, float minV, float maxV) {
        float maxX = xOffset + maxXOffset;
        float minX = xOffset + minxXOffset;
        float maxY = yOffset + maxYOffset;
        float minY = yOffset + minYOffset;
        int lightColor = TeamTaskScoreboardRenderer.getLightColor(scoreboard, maxY, minY, maxX, minX);
        this.vertex(matrix4f, matrix3f, frontVertexConsumer, minX, minY, minU, minV, -0.5f, 0, 0, -1, lightColor);
        this.vertex(matrix4f, matrix3f, frontVertexConsumer, minX, maxY, minU, maxV, -0.5f, 0, 0, -1, lightColor);
        this.vertex(matrix4f, matrix3f, frontVertexConsumer, maxX, maxY, maxU, maxV, -0.5f, 0, 0, -1, lightColor);
        this.vertex(matrix4f, matrix3f, frontVertexConsumer, maxX, minY, maxU, minV, -0.5f, 0, 0, -1, lightColor);
    }

    private static int getLightColor(TeamTaskScoreboardEntity scoreboard, float maxY, float minY, float maxX, float minX) {
        int i1 = scoreboard.m_146903_();
        int j1 = Mth.m_14107_((double)(scoreboard.m_20186_() + (double)((maxY + minY) / 2.0f / 16.0f)));
        int k1 = scoreboard.m_146907_();
        Direction direction = scoreboard.m_6350_();
        if (direction == Direction.NORTH) {
            i1 = Mth.m_14107_((double)(scoreboard.m_20185_() + (double)((maxX + minX) / 2.0f / 16.0f)));
        }
        if (direction == Direction.WEST) {
            k1 = Mth.m_14107_((double)(scoreboard.m_20189_() - (double)((maxX + minX) / 2.0f / 16.0f)));
        }
        if (direction == Direction.SOUTH) {
            i1 = Mth.m_14107_((double)(scoreboard.m_20185_() - (double)((maxX + minX) / 2.0f / 16.0f)));
        }
        if (direction == Direction.EAST) {
            k1 = Mth.m_14107_((double)(scoreboard.m_20189_() + (double)((maxX + minX) / 2.0f / 16.0f)));
        }
        int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)scoreboard.f_19853_, (BlockPos)new BlockPos(i1, j1, k1));
        return lightColor;
    }

    private void vertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float p_115540_, float p_115541_, float p_115542_, float p_115543_, float p_115544_, int p_115545_, int p_115546_, int p_115547_, int p_115548_) {
        vertexConsumer.m_85982_(matrix4f, p_115540_, p_115541_, p_115544_).m_6122_(255, 255, 255, 255).m_7421_(p_115542_, p_115543_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_115548_).m_85977_(matrix3f, (float)p_115545_, (float)p_115546_, (float)p_115547_).m_5752_();
    }

    public ResourceLocation getTextureLocation(TeamTaskScoreboardEntity pEntity) {
        return TEXTURE;
    }
}

