/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.VaultThrownJavelin;
import iskallia.vault.entity.model.PiercingJavelinModel;
import iskallia.vault.entity.model.ScatterJavelinModel;
import iskallia.vault.entity.model.ScrappyJavelinModel;
import iskallia.vault.entity.model.SightJavelinModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ThrownJavelinRenderer
extends EntityRenderer<VaultThrownJavelin> {
    public static final ResourceLocation JAVELIN_LOCATION = VaultMod.id("textures/entity/scrappy_javelin.png");
    public static final ResourceLocation SIGHT_JAVELIN_LOCATION = VaultMod.id("textures/entity/sight_javelin.png");
    public static final ResourceLocation PIERCING_JAVELIN_LOCATION = VaultMod.id("textures/entity/piercing_javelin.png");
    public static final ResourceLocation SCATTER_JAVELIN_LOCATION = VaultMod.id("textures/entity/scatter_javelin.png");
    private final ScrappyJavelinModel model;
    private final ScatterJavelinModel scatterModel;
    private final SightJavelinModel sightModel;
    private final PiercingJavelinModel piercingModel;

    public ThrownJavelinRenderer(EntityRendererProvider.Context p_174420_) {
        super(p_174420_);
        this.model = new ScrappyJavelinModel(p_174420_.m_174023_(ScrappyJavelinModel.MODEL_LOCATION));
        this.scatterModel = new ScatterJavelinModel(p_174420_.m_174023_(ScatterJavelinModel.MODEL_LOCATION));
        this.sightModel = new SightJavelinModel(p_174420_.m_174023_(SightJavelinModel.MODEL_LOCATION));
        this.piercingModel = new PiercingJavelinModel(p_174420_.m_174023_(PiercingJavelinModel.MODEL_LOCATION));
    }

    public void render(VaultThrownJavelin pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        Model model;
        float alpha = (float)(VaultThrownJavelin.MAX_AGE - pEntity.getAge()) / (float)VaultThrownJavelin.MAX_AGE;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19859_, (float)pEntity.m_146908_()) - 90.0f));
        pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19860_, (float)pEntity.m_146909_()) + 90.0f));
        float scale = 1.1f;
        pMatrixStack.m_85841_(scale, scale, scale);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pEntity)));
        float red = 1.0f;
        if (pEntity.getIsGhost()) {
            red = 0.0f;
            alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)0.35f);
        }
        if ((model = this.getModel(pEntity)) != null) {
            model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, red, 1.0f, 1.0f, alpha);
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public Model getModel(VaultThrownJavelin pEntity) {
        switch (pEntity.getJavelinType()) {
            case BASE: {
                return this.model;
            }
            case SCATTER: {
                return this.scatterModel;
            }
            case PIERCING: {
                return this.piercingModel;
            }
            case SIGHT: {
                return this.sightModel;
            }
        }
        return null;
    }

    public ResourceLocation getTextureLocation(VaultThrownJavelin pEntity) {
        switch (pEntity.getJavelinType()) {
            case BASE: {
                return JAVELIN_LOCATION;
            }
            case SCATTER: {
                return SCATTER_JAVELIN_LOCATION;
            }
            case PIERCING: {
                return PIERCING_JAVELIN_LOCATION;
            }
            case SIGHT: {
                return SIGHT_JAVELIN_LOCATION;
            }
        }
        return JAVELIN_LOCATION;
    }
}

