/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.TreasureGoblinEntity;
import iskallia.vault.entity.model.ModModelLayers;
import iskallia.vault.entity.model.TreasureGoblinModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class TreasureGoblinRenderer
extends LivingEntityRenderer<TreasureGoblinEntity, TreasureGoblinModel> {
    public static final ResourceLocation TREASURE_GOBLIN_TEXTURES = VaultMod.id("textures/entity/treasure_goblin.png");

    public TreasureGoblinRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new TreasureGoblinModel(context.m_174023_(ModModelLayers.TREASURE_GOBLIN)), 0.5f);
    }

    public ResourceLocation getTextureLocation(TreasureGoblinEntity entity) {
        return TREASURE_GOBLIN_TEXTURES;
    }

    protected void scale(TreasureGoblinEntity entity, PoseStack matrixStack, float partialTickTime) {
        float f = 0.75f;
        matrixStack.m_85841_(f, f, f);
    }

    public Vec3 getRenderOffset(TreasureGoblinEntity entityIn, float partialTicks) {
        return entityIn.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)entityIn, partialTicks);
    }

    public void render(TreasureGoblinEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        this.setModelVisibilities(entity);
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
    }

    protected void renderNameTag(TreasureGoblinEntity entityIn, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
    }

    protected boolean shouldShowName(TreasureGoblinEntity entity) {
        return false;
    }

    private void setModelVisibilities(TreasureGoblinEntity entity) {
        TreasureGoblinModel model = (TreasureGoblinModel)this.m_7200_();
        if (entity.m_5833_()) {
            model.m_8009_(false);
            model.f_102808_.f_104207_ = true;
            model.f_102809_.f_104207_ = true;
        } else {
            model.m_8009_(true);
            model.f_102817_ = entity.m_6047_();
            HumanoidModel.ArmPose bipedmodel$armpose = TreasureGoblinRenderer.getArmPose(entity, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose bipedmodel$armpose1 = TreasureGoblinRenderer.getArmPose(entity, InteractionHand.OFF_HAND);
            if (bipedmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = entity.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                model.f_102816_ = bipedmodel$armpose;
                model.f_102815_ = bipedmodel$armpose1;
            } else {
                model.f_102816_ = bipedmodel$armpose1;
                model.f_102815_ = bipedmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(TreasureGoblinEntity entity, InteractionHand hand) {
        return HumanoidModel.ArmPose.EMPTY;
    }

    protected void setupRotations(TreasureGoblinEntity entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.m_20998_(partialTicks);
        if (entityLiving.m_21255_()) {
            super.m_7523_((LivingEntity)entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.m_21256_() + partialTicks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.m_21209_()) {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - entityLiving.m_146909_())));
            }
            Vec3 vector3d = entityLiving.m_20252_(partialTicks);
            Vec3 vector3d1 = entityLiving.m_20184_();
            double d0 = vector3d1.m_165925_();
            double d1 = vector3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                matrixStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks);
            float f3 = entityLiving.m_20069_() ? -90.0f - entityLiving.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            if (entityLiving.m_6067_()) {
                matrixStack.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks);
        }
    }
}

