/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer.companion;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.item.CompanionSeries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class LevelScaledPetRenderer
extends GeoEntityRenderer<PetEntity> {
    public LevelScaledPetRenderer(EntityRendererProvider.Context context, AnimatedGeoModel<PetEntity> model) {
        super(context, model);
        this.f_114477_ = 0.4f;
    }

    public void render(PetEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.applyLevelScale(entity, poseStack);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public boolean shouldShowName(PetEntity entity) {
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        IVaultOptions.CompanionNametagMode mode = options.getCompanionNametagMode();
        if (mode == IVaultOptions.CompanionNametagMode.NEVER) {
            return false;
        }
        return this.f_114476_.f_114359_ == entity && super.shouldShowName((LivingEntity)entity);
    }

    protected void applyLevelScale(PetEntity pet, PoseStack poseStack) {
        if (pet.getPetSeries() != CompanionSeries.LEGEND) {
            int level = pet.getCompanionLevel();
            float scale = 1.0f + (float)(level - 1) * 0.01f;
            poseStack.m_85841_(scale, scale, scale);
        }
    }
}

