/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.renderer.plastic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.plastic.PlasticSlimeEntity;
import iskallia.vault.entity.model.ModModelLayers;
import iskallia.vault.entity.model.plastic.PlasticSlimeModel;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class PlasticSlimeRenderer
extends MobRenderer<PlasticSlimeEntity, PlasticSlimeModel> {
    public static final Map<Integer, ResourceLocation> TEXTURES = Map.of(1, VaultMod.id("textures/entity/plastic/slime/slime_plastic_t1.png"), 2, VaultMod.id("textures/entity/plastic/slime/slime_plastic_t2.png"), 3, VaultMod.id("textures/entity/plastic/slime/slime_plastic_t3.png"), 4, VaultMod.id("textures/entity/plastic/slime/slime_plastic_t4.png"));

    public PlasticSlimeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlasticSlimeModel(context.m_174023_(ModModelLayers.PLASTIC_SLIME)), 0.25f);
        this.m_115326_(new PlasticSlimeOuterLayer((RenderLayerParent<PlasticSlimeEntity, PlasticSlimeModel>)this, context.m_174027_()));
    }

    public void render(PlasticSlimeEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = 0.25f * (float)entity.m_33632_();
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(PlasticSlimeEntity slime, PoseStack poseStack, float partialTicks) {
        float scale = 0.999f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(0.0, (double)0.001f, 0.0);
        float size = slime.m_33632_();
        float squishAmount = Mth.m_14179_((float)partialTicks, (float)slime.f_33585_, (float)slime.f_33584_) / (size * 0.5f + 1.0f);
        float squishFactor = 1.0f / (squishAmount + 1.0f);
        poseStack.m_85841_(squishFactor * size, 1.0f / squishFactor * size, squishFactor * size);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull PlasticSlimeEntity slime) {
        return TEXTURES.get(slime.getTier());
    }

    public static class PlasticSlimeOuterLayer
    extends RenderLayer<PlasticSlimeEntity, PlasticSlimeModel> {
        private final EntityModel<PlasticSlimeEntity> model;

        public PlasticSlimeOuterLayer(RenderLayerParent<PlasticSlimeEntity, PlasticSlimeModel> renderer, EntityModelSet modelSet) {
            super(renderer);
            this.model = new PlasticSlimeModel(modelSet.m_171103_(ModModelLayers.PLASTIC_SLIME_OUTER));
        }

        public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull PlasticSlimeEntity slime, float limbSwing, float limbSwingAmount, float partialTicks, float age, float headYaw, float headPitch) {
            boolean isGlowingAndInvisible;
            Minecraft minecraft = Minecraft.m_91087_();
            boolean isInvisible = slime.m_20145_();
            boolean bl = isGlowingAndInvisible = minecraft.m_91314_((Entity)slime) && isInvisible;
            if (!isInvisible || isGlowingAndInvisible) {
                VertexConsumer vertexConsumer = isGlowingAndInvisible ? buffer.m_6299_(RenderType.m_110491_((ResourceLocation)this.m_117347_((Entity)slime))) : buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_117347_((Entity)slime)));
                ((PlasticSlimeModel)this.m_117386_()).m_102624_(this.model);
                this.model.m_6839_((Entity)slime, limbSwing, limbSwingAmount, partialTicks);
                this.model.m_6973_((Entity)slime, limbSwing, limbSwingAmount, age, headYaw, headPitch);
                this.model.m_7695_(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)slime, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

