/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.config.entry.EnchantedBookEntry;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.LegacyMagnetItem;
import iskallia.vault.item.tool.PaxelItem;
import iskallia.vault.util.EnchantmentUtil;
import iskallia.vault.util.OverlevelEnchantHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnvilEvents {
    @SubscribeEvent
    public static void onPreventEnchantmentApply(AnvilUpdateEvent event) {
        Map enchantmentsToApply = EnchantmentHelper.m_44831_((ItemStack)event.getRight());
        for (Enchantment ench : enchantmentsToApply.keySet()) {
            if (!EnchantmentUtil.isEnchantmentBlocked(ench, event.getLeft())) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack equipment = event.getLeft();
        ItemStack enchantedBook = event.getRight();
        if (equipment.m_41720_() == Items.f_42690_) {
            return;
        }
        if (enchantedBook.m_41720_() != Items.f_42690_) {
            return;
        }
        ItemStack upgradedEquipment = equipment.m_41777_();
        Map<Enchantment, Integer> equipmentEnchantments = OverlevelEnchantHelper.getEnchantments(equipment);
        Map<Enchantment, Integer> bookEnchantments = OverlevelEnchantHelper.getEnchantments(enchantedBook);
        int overlevels = OverlevelEnchantHelper.getOverlevels(enchantedBook);
        if (overlevels == -1) {
            return;
        }
        HashMap<Enchantment, Integer> enchantmentsToApply = new HashMap<Enchantment, Integer>(equipmentEnchantments);
        for (Enchantment bookEnchantment : bookEnchantments.keySet()) {
            int bookLevel;
            if (!equipmentEnchantments.containsKey(bookEnchantment)) continue;
            int currentLevel = equipmentEnchantments.getOrDefault(bookEnchantment, 0);
            int nextLevel = currentLevel == (bookLevel = bookEnchantments.get(bookEnchantment).intValue()) ? currentLevel + 1 : Math.max(currentLevel, bookLevel);
            enchantmentsToApply.put(bookEnchantment, nextLevel);
        }
        EnchantmentHelper.m_44865_(enchantmentsToApply, (ItemStack)upgradedEquipment);
        if (upgradedEquipment.equals(equipment, true)) {
            event.setCanceled(true);
        } else {
            EnchantedBookEntry bookTier = ModConfigs.OVERLEVEL_ENCHANT.getTier(overlevels);
            event.setOutput(upgradedEquipment);
            event.setCost(bookTier == null ? 1 : bookTier.getLevelNeeded());
        }
    }

    @SubscribeEvent
    public static void onRepairDeny(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof LegacyMagnetItem && event.getRight().m_41720_() instanceof LegacyMagnetItem) {
            event.setCanceled(true);
        } else if (event.getLeft().m_41720_() instanceof PaxelItem && event.getRight().m_41720_() instanceof PaxelItem) {
            event.setCanceled(true);
        }
        if (event.getLeft().m_41720_() instanceof VaultGearItem && event.getRight().m_41720_() instanceof VaultGearItem && !event.getRight().m_150930_((Item)ModItems.JEWEL)) {
            event.setOutput(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent
    public static void onApplyMending(AnvilUpdateEvent event) {
        ItemStack out = event.getOutput();
        if (!(out.m_41720_() instanceof ShieldItem)) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)out) > 0) {
            event.setCanceled(true);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44972_, (ItemStack)out) > 0) {
            event.setCanceled(true);
        }
    }
}

