/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import iskallia.vault.client.ClientActiveEternalData;
import iskallia.vault.client.ClientDamageData;
import iskallia.vault.client.ClientPartyData;
import iskallia.vault.client.VaultSoundOptions;
import iskallia.vault.client.gui.component.OpenSupportersButton;
import iskallia.vault.client.render.healthbar.HealthbarRenderer;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.world.loot.LootTableInfo;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.TextUtil;
import iskallia.vault.www.RewardsManager;
import iskallia.vault.www.patreon.PatreonManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void cleanupHealthTexture(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ClientActiveEternalData.clearClientCache();
        ClientDamageData.clearClientCache();
        ClientPartyData.clearClientCache();
        PatreonManager.getInstance().clearCache();
        RewardsManager.getInstance().clearCache();
        HealthbarRenderer.clearCaches();
        VaultSoundOptions.getInstance().save();
        ClientVaults.ACTIVE.releaseClient();
    }

    @SubscribeEvent
    public static void onConnect(ClientPlayerNetworkEvent.LoggedInEvent event) {
        if (event.getPlayer() != null) {
            PatreonManager.getInstance().getPlayerData(event.getPlayer().m_142081_());
            RewardsManager.getInstance().getRewardData(event.getPlayer().m_142081_());
        }
        PatreonManager.getInstance().getAllPlayers();
        HealthbarRenderer.clearCaches();
    }

    @SubscribeEvent
    public static void onDeathReset(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.f_19853_.f_46443_) {
            return;
        }
        if (entity instanceof Player) {
            return;
        }
        if (!entity.m_21224_()) {
            entity.f_20919_ = 0;
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ModConfigs.TOOLTIP.getTooltipString(event.getItemStack().m_41720_()).ifPresent(str -> {
            List tooltip = event.getToolTip();
            List added = Lists.reverse((List)Lists.newArrayList((Object[])str.split("\n")));
            if (added.isEmpty()) {
                return;
            }
            tooltip.add(1, TextComponent.f_131282_);
            for (String newStr : added) {
                tooltip.add(1, TextUtil.applyColorTags(newStr).m_130940_(ChatFormatting.GRAY));
            }
        });
        ItemStack current = event.getItemStack();
        if (!current.m_41619_()) {
            int value;
            Item item = current.m_41720_();
            if (ModConfigs.VAULT_DIFFUSER.contains(current) && (value = ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().get(item.getRegistryName()).intValue()) > 0) {
                if (Screen.m_96638_()) {
                    event.getToolTip().add(1, new TextComponent("Soul Value: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(value + " [" + current.m_41613_() * value + "]").m_130940_(ChatFormatting.DARK_PURPLE)));
                } else {
                    event.getToolTip().add(1, new TextComponent("Soul Value: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("" + value).m_130940_(ChatFormatting.DARK_PURPLE)));
                }
            }
            ClientEvents.addLootTableInfoToTooltip(current, event.getToolTip());
            if (event.getFlags().m_7050_()) {
                ClientEvents.removeVanillaDurabilityLineFromVaultGearTooltip(current, event.getToolTip());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiInit(ScreenEvent.InitScreenEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            String targetMessage = I18n.m_118938_((String)"menu.options", (Object[])new Object[0]);
            MutableObject toAdd = new MutableObject(null);
            event.getListenersList().stream().filter(w -> w instanceof AbstractWidget).map(w -> (AbstractWidget)w).filter(w -> w.m_6035_().getString().equals(targetMessage)).findFirst().ifPresent(w -> toAdd.setValue((Object)new OpenSupportersButton(w.f_93620_, w.f_93621_ - 72 + 48)));
            if (toAdd.getValue() != null) {
                event.addListener((GuiEventListener)toAdd.getValue());
            }
        }
    }

    private static void removeVanillaDurabilityLineFromVaultGearTooltip(ItemStack itemStack, List<Component> tooltip) {
        Item item = itemStack.m_41720_();
        if (item instanceof VaultGearItem) {
            for (int i = tooltip.size() - 1; i >= 0; --i) {
                TranslatableComponent translatableComponent;
                Component component = tooltip.get(i);
                if (!(component instanceof TranslatableComponent) || !"item.durability".equals((translatableComponent = (TranslatableComponent)component).m_131328_())) continue;
                tooltip.remove(i);
                break;
            }
        }
    }

    private static void addLootTableInfoToTooltip(ItemStack itemStack, List<Component> toolTip) {
        VaultGearState state;
        Item item = itemStack.m_41720_();
        if (item instanceof VaultGearItem && (state = VaultGearData.read(itemStack).getState()) != VaultGearState.UNIDENTIFIED) {
            return;
        }
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null && LootTableInfo.containsInfoForItem(registryName)) {
            List lootTableItems = LootTableInfo.getLootTableKeysForItem(registryName).stream().flatMap(resourceLocation -> ModConfigs.LOOT_INFO_CONFIG.getTooltipLines(item).stream()).distinct().toList();
            if (lootTableItems.isEmpty()) {
                return;
            }
            if (Screen.m_96638_()) {
                toolTip.add((Component)new TextComponent("Found in:").m_130940_(ChatFormatting.GRAY));
                lootTableItems.forEach(name -> toolTip.add((Component)new TextComponent("  - " + name).m_130940_(ChatFormatting.GRAY)));
            } else {
                toolTip.add((Component)new TextComponent("Hold").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TextComponent(" <SHIFT>").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(" for Vault Loot Info").m_130940_(ChatFormatting.DARK_GRAY)));
            }
        }
    }
}

