/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityDamageBlockEvent;
import iskallia.vault.core.event.common.PlayerStatEvent;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModEffects;
import iskallia.vault.mana.Mana;
import iskallia.vault.mana.ManaAction;
import iskallia.vault.util.calc.PlayerStat;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EtchingEvents {
    private static void onLuckyHitChance(PlayerStatEvent.Data data) {
        LivingEntity entity = data.getEntity();
        if (entity == null) {
            return;
        }
        EtchingHelper.getEtchings(entity, EtchingGearAttributes.LUCKY_LOW_HEALTH).stream().findFirst().ifPresent(stack -> {
            float threshold = ((Float)((Pair)stack.getValue()).getSecond()).floatValue();
            if (entity.m_21223_() < entity.m_21233_() * threshold) {
                float chance = ((Float)((Pair)stack.getValue()).getFirst()).floatValue();
                data.setValue(data.getValue() + chance);
            }
        });
    }

    private static void onBlock(EntityDamageBlockEvent.Data data) {
        LivingEntity livingEntity = data.getAttacked();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.BLOCKING_MANA).stream().findFirst().ifPresent(stack -> {
            int mana = (Integer)stack.getValue();
            Mana.increase((Player)player, ManaAction.PLAYER_ACTION, mana);
        });
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!ActiveFlags.IS_IMPLODE_ATTACKING.isSet()) {
            return;
        }
        EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.IMPLODE_MANA_REGEN).stream().findFirst().ifPresent(stack -> {
            float regen = ((Float)stack.getValue()).floatValue();
            ImplodeManaRegenEffect.addTo(player, regen);
        });
    }

    static {
        CommonEvents.PLAYER_STAT.of(PlayerStat.LUCKY_HIT_CHANCE).register(EtchingEvents.class, EtchingEvents::onLuckyHitChance);
        CommonEvents.ENTITY_DAMAGE_BLOCK.blockSucceeded().register(EtchingEvents.class, EtchingEvents::onBlock);
    }

    public static class ImplodeManaRegenEffect
    extends MobEffect {
        private static final UUID UUID = java.util.UUID.fromString("c659ab5c-4e2d-4d51-9814-52eea3f1c1d5");

        public ImplodeManaRegenEffect(int color, ResourceLocation id) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(id);
        }

        public static void addTo(ServerPlayer player, float regenPercent) {
            float total = regenPercent;
            MobEffectInstance current = player.m_21124_((MobEffect)ModEffects.IMPLODE_MANA_REGEN);
            if (current instanceof ImplodeManaRegenMobEffectInstance) {
                ImplodeManaRegenMobEffectInstance inst = (ImplodeManaRegenMobEffectInstance)current;
                total += inst.manaRegen;
            }
            player.m_7292_((MobEffectInstance)new ImplodeManaRegenMobEffectInstance(ModEffects.IMPLODE_MANA_REGEN, 200, 0, false, false, true, total));
        }

        public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            AttributeInstance attribute = player.m_21051_(ModAttributes.MANA_REGEN);
            if (attribute == null) {
                return;
            }
            MobEffectInstance mobEffectInstance = player.m_21124_((MobEffect)this);
            if (!(mobEffectInstance instanceof ImplodeManaRegenMobEffectInstance)) {
                attribute.m_22120_(UUID);
                return;
            }
            ImplodeManaRegenMobEffectInstance inst = (ImplodeManaRegenMobEffectInstance)mobEffectInstance;
            AttributeModifier modifier = new AttributeModifier(UUID, "implode_mana_regen", (double)inst.manaRegen, AttributeModifier.Operation.MULTIPLY_BASE);
            attribute.m_22118_(modifier);
        }

        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            AttributeInstance attribute = player.m_21051_(ModAttributes.MANA_REGEN);
            if (attribute != null) {
                attribute.m_22120_(UUID);
            }
        }
    }

    public static class ImplodeManaRegenMobEffectInstance
    extends MobEffectInstance {
        public final float manaRegen;

        public ImplodeManaRegenMobEffectInstance(MobEffect effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon, float manaRegen) {
            super(effect, duration, amplifier, ambient, visible, showIcon);
            this.manaRegen = manaRegen;
        }
    }
}

