/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.world.data.VaultPartyData;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PartyEvents {
    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        VaultPartyData.Party party;
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        LivingEntity attacked = event.getEntityLiving();
        Level world = attacked.m_20193_();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sWorld = (ServerLevel)world;
        UUID attackerUUID = attacker.m_142081_();
        if (attacker instanceof EternalEntity) {
            attackerUUID = (UUID)((EternalEntity)attacker).getOwner().map(Function.identity(), Entity::m_142081_);
        }
        UUID attackedUUID = attacked.m_142081_();
        if (attacked instanceof EternalEntity) {
            attackerUUID = (UUID)((EternalEntity)attacked).getOwner().map(Function.identity(), Entity::m_142081_);
        }
        if ((party = (VaultPartyData.Party)VaultPartyData.get(sWorld).getParty(attackerUUID).orElse(null)) != null && party.hasMember(attackedUUID)) {
            Optional<Vault> vaultOpt = VaultUtils.getVault((Level)sWorld);
            if (vaultOpt.isPresent() && VaultUtils.isPvPVault(vaultOpt.get())) {
                return;
            }
            event.setCanceled(true);
        }
    }
}

