/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.VaultMod;
import iskallia.vault.block.AnimatrixBlock;
import iskallia.vault.block.CoinPileDecorBlock;
import iskallia.vault.block.base.IAllowZone;
import iskallia.vault.block.entity.AnimatrixTileEntity;
import iskallia.vault.block.entity.BreakableCrateTileEntity;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityDamageEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.ThemeBlockRetriever;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.storage.WorldZone;
import iskallia.vault.entity.entity.AncientCopperConduitItemEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.FighterEntity;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.ActiveFlagsCheck;
import iskallia.vault.event.event.BountyCompleteEvent;
import iskallia.vault.event.event.CraftCrystalEvent;
import iskallia.vault.event.event.ForgeGearEvent;
import iskallia.vault.event.event.GearModificationEvent;
import iskallia.vault.event.event.VaultJoinEvent;
import iskallia.vault.event.event.VaultLeaveEvent;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.attribute.custom.HitHeartsAttribute;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.DamageImmunityTrinket;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.AnimalJarItem;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionPetManager;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.gear.VoidStoneItem;
import iskallia.vault.mana.Mana;
import iskallia.vault.mana.ManaAction;
import iskallia.vault.network.message.FighterSizeMessage;
import iskallia.vault.network.message.InvalidConfigsMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.CompanionCooldownExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.AdvancementHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.PlayerRelentlessStrikeHelper;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.VaultMode;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.RoyaleInventorySnapshotData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultJoinSnapshotData;
import iskallia.vault.www.RewardsManager;
import iskallia.vault.www.patreon.PatreonManager;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.theillusivec4.curios.api.event.CurioEquipEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEvents {
    private static final String RESTORE_FLAG = "the_vault_restore_pvp_join";

    @SubscribeEvent
    public static void onTossItem(EntityJoinWorldEvent event) {
        ItemEntity item;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && !((item = (ItemEntity)entity) instanceof AncientCopperConduitItemEntity) && item.m_32055_().m_41720_() == ModBlocks.ANCIENT_COPPER_CONDUIT_BLOCK_ITEM) {
            AncientCopperConduitItemEntity ancientCopperConduitItemEntity = new AncientCopperConduitItemEntity(item.f_19853_, item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_32055_());
            CompoundTag tag = new CompoundTag();
            item.m_20223_(tag);
            ancientCopperConduitItemEntity.m_20258_(tag);
            if (!event.getWorld().f_46443_) {
                event.getWorld().m_7967_((Entity)ancientCopperConduitItemEntity);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target.f_19853_.f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (target instanceof FighterEntity) {
            ModNetwork.CHANNEL.sendTo((Object)new FighterSizeMessage(target, ((FighterEntity)target).sizeMultiplier), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        if (target instanceof EternalEntity) {
            ModNetwork.CHANNEL.sendTo((Object)new FighterSizeMessage(target, ((EternalEntity)target).sizeMultiplier), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onAttack(AttackEntityEvent event) {
        VaultGearData data;
        Player attacker = event.getPlayer();
        if (attacker.f_19853_.m_5776_()) {
            return;
        }
        int playerLevel = PlayerVaultStatsData.get((ServerLevel)attacker.f_19853_).getVaultStats(attacker).getVaultLevel();
        ItemStack stack = attacker.m_21205_();
        if (stack.m_41720_() instanceof VaultGearItem && playerLevel < (data = VaultGearData.read(stack)).getItemLevel()) {
            event.setCanceled(true);
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            EntityHelper.getNearby((LevelAccessor)attacker.f_19853_, (Vec3i)attacker.m_142538_(), 9.0f, EternalEntity.class).forEach(eternal -> eternal.m_6710_(target));
        }
    }

    @SubscribeEvent
    public static void customTrinketAndVoidStoneCurioEquip(CurioEquipEvent event) {
        CharmItem charmItem;
        TrinketItem trinketItem;
        ItemStack stack = event.getStack();
        if (!(stack.m_41720_() instanceof TrinketItem || stack.m_41720_() instanceof CharmItem || stack.m_41720_() instanceof VoidStoneItem)) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof TrinketItem && (trinketItem = (TrinketItem)item).canEquip(event.getSlotContext(), stack)) {
            event.setResult(Event.Result.ALLOW);
        }
        if ((item = stack.m_41720_()) instanceof CharmItem && (charmItem = (CharmItem)item).canEquip(event.getSlotContext(), stack)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick2(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_6060_()) {
            if (player.m_21023_(MobEffects.f_19607_)) {
                player.m_20095_();
            }
            if (TrinketHelper.getTrinkets((LivingEntity)player, DamageImmunityTrinket.class).stream().filter(trinket -> trinket.isUsable(player)).map(TrinketHelper.TrinketStack::trinket).anyMatch(DamageImmunityTrinket::isFireDamage)) {
                player.m_20095_();
            }
        }
        if (player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                sPlayer.f_8917_ = player.m_21223_();
            }
        }
    }

    @SubscribeEvent
    public static void despawnCompanionWhenUnequipped(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        if (CompanionPetManager.getSpawnedPetId(sPlayer.m_142081_()) != null && CompanionItem.getCompanion((LivingEntity)sPlayer).isEmpty()) {
            CompanionPetManager.despawnPet(sPlayer);
        }
    }

    @SubscribeEvent
    public static void blockInteractRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity tileEntity;
        Level world = event.getWorld();
        Block block = world.m_8055_(event.getPos()).m_60734_();
        if (block instanceof CoinPileDecorBlock) {
            event.setUseBlock(Event.Result.ALLOW);
        } else if (block instanceof AnimatrixBlock && (tileEntity = world.m_7702_(event.getPos())) instanceof AnimatrixTileEntity) {
            AnimatrixTileEntity animatrixTileEntity = (AnimatrixTileEntity)tileEntity;
            ItemStack itemStack = event.getItemStack();
            if (itemStack.m_41720_() instanceof SpawnEggItem) {
                if (animatrixTileEntity.getItemHandler().isItemValid(0, itemStack)) {
                    event.setUseBlock(Event.Result.ALLOW);
                }
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void preventArtifactFraming(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().m_5776_()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_() || stack.m_41720_() != ModBlocks.VAULT_ARTIFACT.m_5456_()) {
            return;
        }
        Block clicked = event.getWorld().m_8055_(event.getPos()).m_60734_();
        ResourceLocation id = clicked.getRegistryName();
        if (id != null && id.m_135827_().contains("blockcarpentry")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void itemInteractionForEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player;
        if (!event.getWorld().m_5776_() && event.getTarget() instanceof Animal && !(event.getTarget() instanceof Player) && (player = event.getPlayer()).m_6047_() && player.m_21120_(event.getHand()).m_41720_() == ModItems.ANIMAL_JAR && (entity = event.getTarget()) instanceof Animal) {
            Horse horse;
            TamableAnimal tamableAnimal;
            Animal animal = (Animal)entity;
            if (!AnimalJarItem.canAddEntity(event.getItemStack(), (LivingEntity)animal)) {
                player.m_5661_((Component)new TextComponent("Cannot add to jar."), true);
                return;
            }
            if (animal.m_6162_()) {
                player.m_5661_((Component)new TextComponent("This animal is too small to fit in this jar.."), true);
                return;
            }
            Entity entity2 = event.getTarget();
            if (entity2 instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity2).m_142480_() != null) {
                player.m_5661_((Component)new TextComponent("Cannot jar up tamed animals"), true);
                return;
            }
            entity2 = event.getTarget();
            if (entity2 instanceof Horse && (horse = (Horse)entity2).m_30614_()) {
                player.m_5661_((Component)new TextComponent("Cannot jar up tamed animals"), true);
                return;
            }
            if (player.m_21120_(event.getHand()).m_41613_() > 1) {
                ItemStack jar = event.getItemStack().m_41777_();
                event.getItemStack().m_41774_(1);
                jar.m_41764_(1);
                ItemStack output = AnimalJarItem.AddEntity(jar, (LivingEntity)animal);
                player.m_150109_().m_36054_(output);
            } else {
                AnimalJarItem.AddEntity(event.getItemStack(), (LivingEntity)animal);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void fillLootOnBreak(BlockEvent.BreakEvent event) {
        if (event.getWorld().m_5776_() || !(event.getWorld() instanceof ServerLevel)) {
            return;
        }
        BlockEntity tile = event.getWorld().m_7702_(event.getPos());
        if (tile instanceof RandomizableContainerBlockEntity) {
            if (tile instanceof VaultChestTileEntity) {
                ((VaultChestTileEntity)tile).generateChestLoot(event.getPlayer(), true);
            } else if (tile instanceof BreakableCrateTileEntity) {
                BreakableCrateTileEntity te = (BreakableCrateTileEntity)tile;
                te.generateChestLoot(event.getPlayer(), true);
            } else {
                ((RandomizableContainerBlockEntity)tile).m_59640_(event.getPlayer());
            }
        }
        if (tile instanceof VaultChestTileEntity) {
            Random rand = event.getWorld().m_5822_();
            VaultRarity rarity = ((VaultChestTileEntity)tile).getRarity();
            if (rarity == VaultRarity.EPIC) {
                event.getWorld().m_5594_(null, event.getPos(), ModSounds.VAULT_CHEST_EPIC_OPEN, SoundSource.BLOCKS, 0.2f, rand.nextFloat() * 0.1f + 0.9f);
            } else if (rarity == VaultRarity.OMEGA) {
                event.getWorld().m_5594_(null, event.getPos(), ModSounds.VAULT_CHEST_OMEGA_OPEN, SoundSource.BLOCKS, 0.2f, rand.nextFloat() * 0.1f + 0.9f);
            } else if (rarity == VaultRarity.RARE) {
                event.getWorld().m_5594_(null, event.getPos(), ModSounds.VAULT_CHEST_RARE_OPEN, SoundSource.BLOCKS, 0.3f, rand.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterVault(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (ServerVaults.get(serverPlayer.f_19853_).isPresent()) {
                AdvancementHelper.grantCriterion(serverPlayer, VaultMod.id("main/root"), "entered_vault");
                AdvancementHelper.grantCriterion(serverPlayer, VaultMod.id("armors/root"), "entered_vault");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveVault(VaultLeaveEvent event) {
        ServerPlayer player = event.getPlayer();
        AdvancementHelper.grantCriterion(player, VaultMod.id("main/root"), "left_vault");
        StatCollector stats = event.getVault().get(Vault.STATS).get(player.m_142081_());
        if (stats != null && stats.getCompletion() == Completion.COMPLETED) {
            AdvancementHelper.grantCriterion(player, VaultMod.id("main/root"), "completed_vault");
        }
    }

    @SubscribeEvent
    public static void onVaultJoin(VaultJoinEvent event) {
        event.getPlayers().forEach(player -> AdvancementHelper.grantCriterion(player, VaultMod.id("main/root"), "joined_vault"));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onVaultJoinApplyCompanion(VaultJoinEvent event) {
        Vault vault = event.getVault();
        ServerPlayer player = event.getPlayer();
        CompanionItem.getCompanion((LivingEntity)player).ifPresent(stack -> {
            String petName = CompanionItem.getPetName(stack);
            boolean onCd = CompanionItem.isOnCooldown(stack);
            CompanionItem.setActive(stack, !onCd);
            if (onCd) {
                player.m_6352_((Component)new TextComponent("<" + petName + "> I'm resting and cannot help you"), player.m_142081_());
                return;
            }
            if (VaultUtils.allowTemporal(vault)) {
                player.m_6352_((Component)new TextComponent("<" + petName + "> My relics don\u2019t seem to work in this vault"), player.m_142081_());
                return;
            }
            if (VaultUtils.isSpecialVault(vault)) {
                player.m_6352_((Component)new TextComponent("<" + petName + "> I am too weak to modify this vault"), player.m_142081_());
                return;
            }
            if (CompanionItem.getCompanionHearts(stack) > 0 && CompanionItem.isActive(stack)) {
                CompanionItem.getAllRelics(stack).values().forEach(list -> ((List)list.getSecond()).forEach(id -> {
                    Object modifier = VaultModifierRegistry.get(id);
                    if (modifier != null) {
                        vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)modifier, 1, true, JavaRandom.ofNanoTime());
                    }
                }));
            }
        });
    }

    @SubscribeEvent
    public static void onVaultLeaveCompanionCooldown(VaultLeaveEvent event) {
        ServerPlayer player = event.getPlayer();
        Vault vault = event.getVault();
        if (VaultUtils.isSpecialVault(vault)) {
            return;
        }
        if (player != null) {
            CompanionItem.getCompanion((LivingEntity)player).ifPresent(stack -> {
                int current;
                int reduceBy;
                if (CompanionItem.getCompanionHearts(stack) <= 0) {
                    return;
                }
                CompanionItem.startCompanionCooldown(stack);
                float reduction = 0.0f;
                ExpertiseTree expertises = PlayerExpertisesData.get(player.m_183503_()).getExpertises((Player)player);
                for (CompanionCooldownExpertise exp : expertises.getAll(CompanionCooldownExpertise.class, Skill::isUnlocked)) {
                    reduction += exp.getCooldownReduction();
                }
                if (reduction > 0.0f && (reduceBy = Mth.m_14143_((float)((float)(current = CompanionItem.getCurrentCooldown(stack)) * reduction))) > 0) {
                    CompanionItem.reduceCooldown(stack, reduceBy);
                }
                CompanionItem.incrementVaultRuns(stack);
            });
        }
    }

    @SubscribeEvent
    public static void onBountyComplete(BountyCompleteEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AdvancementHelper.grantCriterion(player2, VaultMod.id("main/root"), "bounty_completed");
            VaultMod.LOGGER.debug("Granted bounty_completed to {}", (Object)player2.m_6302_());
        }
    }

    @SubscribeEvent
    public static void onCrystalCraft(CraftCrystalEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AdvancementHelper.grantCriterion(player2, VaultMod.id("main/root"), "crafted_crystal");
            VaultMod.LOGGER.debug("Granted crafted_crystal to {}", (Object)player2.m_6302_());
        }
    }

    @SubscribeEvent
    public static void onForgeGear(ForgeGearEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AdvancementHelper.grantCriterion(player2, VaultMod.id("main/root"), "gear_forged");
            VaultMod.LOGGER.debug("Granted gear_forged to {}", (Object)player2.m_6302_());
        }
    }

    @SubscribeEvent
    public static void onGearModification(GearModificationEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AdvancementHelper.grantCriterion(player2, VaultMod.id("main/root"), "gear_modified");
            VaultMod.LOGGER.debug("Granted gear_modified to {}", (Object)player2.m_6302_());
        }
    }

    @SubscribeEvent
    public static void disableMendingVault(PlayerXpEvent.PickupXp event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel world = player2.m_183503_();
        if (ServerVaults.get((Level)world).isEmpty()) {
            return;
        }
        event.setCanceled(true);
        ExperienceOrb orb = event.getOrb();
        int xpValue = orb.m_20801_();
        player2.m_6756_(xpValue);
        orb.m_146870_();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onVaultPendantUse(EntityItemPickupEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemEntity itemEntity = event.getItem();
        ItemStack stack = itemEntity.m_32055_();
        if (stack.m_41619_()) {
            return;
        }
        ServerLevel world = player2.m_183503_();
        if (ServerVaults.get((Level)world).isEmpty()) {
            return;
        }
        Vault vault = ServerVaults.get((Level)world).get();
        if (MagnetItem.getMagnet((LivingEntity)player2, MagnetItem.PickupState.VOID).isPresent() || VaultUtils.isRoyaleVault(vault)) {
            ResourceLocation theme = vault.get(Vault.WORLD).get(WorldManager.THEME);
            if (!ThemeBlockRetriever.shouldVoidItem(player2, itemEntity, world, theme)) {
                return;
            }
            event.setCanceled(true);
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            world.m_5594_(null, player2.m_142538_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 1.4f + 2.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        player2.m_21219_();
        RoyaleInventorySnapshotData.get(player2.m_183503_()).restoreSnapshot((Player)player2);
    }

    @SubscribeEvent
    public static void onManaRegen(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        event.player.m_21051_(ModAttributes.MANA_MAX).m_22100_((double)ModConfigs.MANA.getManaMax());
        event.player.m_21051_(ModAttributes.MANA_REGEN).m_22100_((double)ModConfigs.MANA.getManaRegenPerSecond());
        Mana.increase(event.player, ManaAction.MANA_REGENERATION, Mana.getRegenPerSecond(event.player) * 0.05f);
    }

    @SubscribeEvent
    public static void onInvalidConfigs(PlayerEvent.PlayerLoggedInEvent event) {
        if (ModConfigs.INVALID_CONFIGS.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetwork.CHANNEL.sendTo((Object)new InvalidConfigsMessage(ModConfigs.INVALID_CONFIGS), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onPvPVaultRelog(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerVaults.get(player2.f_19853_).ifPresent(vault -> {
            if (!VaultUtils.isPvPVault(vault)) {
                return;
            }
            boolean completed = vault.get(Vault.STATS).getMap().values().stream().anyMatch(stats -> stats.getCompletion() == Completion.COMPLETED);
            if (!completed) {
                return;
            }
            if (!vault.get(Vault.LISTENERS).contains(player2.m_142081_())) {
                return;
            }
            Listener listener = vault.get(Vault.LISTENERS).get(player2.m_142081_());
            if (!(listener instanceof Runner)) {
                return;
            }
            VaultMod.LOGGER.info("Player {} rejoined completed PvP vault, kicking", (Object)player2.m_142081_());
            ServerVaults.getWorld(vault).ifPresent(world -> vault.get(Vault.LISTENERS).remove((VirtualWorld)((Object)((Object)world)), (Vault)vault, listener));
        });
    }

    @SubscribeEvent
    public static void onPatreonLoad(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        if (sPlayer.m_20194_() == null || !sPlayer.m_20194_().m_129797_()) {
            return;
        }
        PatreonManager.getInstance().getPatreonTiers(event.getPlayer().m_142081_());
        RewardsManager.getInstance().getRewardData(event.getPlayer().m_142081_());
    }

    @SubscribeEvent
    public static void clearPatreonCache(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer sPlayer;
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer) || (sPlayer = (ServerPlayer)player).m_20194_() == null) {
            return;
        }
        CompanionPetManager.cleanupPlayer(sPlayer, sPlayer.m_183503_());
        PatreonManager.getInstance().clearCache(event.getPlayer().m_142081_());
        RewardsManager.getInstance().clearCache(event.getPlayer().m_142081_());
    }

    @SubscribeEvent
    public static void cleanupCompanionOnDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.m_20194_() == null) {
            return;
        }
        ServerLevel fromLevel = serverPlayer.m_20194_().m_129880_(event.getFrom());
        if (fromLevel != null) {
            CompanionPetManager.cleanupPlayer(serverPlayer, fromLevel);
            PlayerRelentlessStrikeHelper.clearEffects(serverPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDrops(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void on(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PlayerAbilitiesData.deactivateAllAbilities(player);
        ServerLevel level = player.m_183503_();
        ServerVaults.get((Level)level).ifPresent(vault -> {
            VaultMode mode = ((VaultMode.GameRuleValue)level.m_46469_().m_46170_(ModGameRules.MODE)).get();
            boolean specialVault = VaultUtils.isSpecialVault(vault);
            if (mode != VaultMode.CASUAL && !specialVault) {
                CompanionItem.getCompanion((LivingEntity)player).ifPresent(stack -> {
                    int hearts = CompanionItem.getCompanionHearts(stack);
                    if (hearts > 0) {
                        CompanionItem.setCompanionHearts(stack, hearts - 1);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public static void on(PlayerEvent.Clone event) {
        ServerPlayer player;
        block3: {
            block2: {
                Player player2 = event.getPlayer();
                if (!(player2 instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!event.isWasDeath()) break block3;
            }
            return;
        }
        Mana.set((Player)player, ManaAction.SYSTEM, Mana.get(event.getOriginal()));
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemStack pickedUpStack;
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        Inventory inventory = player.m_150109_();
        if (CoinPouchItem.interceptPlayerInventoryItemAddition(inventory, pickedUpStack = event.getItem().m_32055_())) {
            event.getItem().m_32045_(ItemStack.f_41583_);
            event.setCanceled(true);
            player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (player.f_19853_.f_46441_.nextFloat() - player.f_19853_.f_46441_.nextFloat()) * 1.4f + 2.0f);
            return;
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (ServerVaults.get((Level)player2.m_183503_()).isPresent() && event.getEntityItem().m_32055_().m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void safeZone(LivingAttackEvent event) {
        if (!(event.getSource().m_7639_() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!(player.m_20193_() instanceof ServerLevel)) {
            return;
        }
        if (VaultUtils.isInStartRoom(player.m_142538_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void pauseVaultTimerOnLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (!(player2 instanceof ServerPlayer) || (player = (ServerPlayer)player2).m_20194_() == null) {
            return;
        }
        ServerLevel level = player.m_183503_();
        if (!ServerVaults.isInVault((Level)level)) {
            return;
        }
        ServerVaults.get((Level)level).ifPresent(vault -> {
            boolean anyOnline = vault.get(Vault.LISTENERS).getAll().stream().filter(l -> l instanceof Runner).anyMatch(Listener::isOnline);
            if (!anyOnline) {
                vault.get(Vault.CLOCK).set(TickClock.PAUSED);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ServerLevel level = player.m_183503_();
        ServerVaults.get((Level)level).ifPresent(vault -> {
            if (!VaultUtils.isPvPVault(vault)) {
                return;
            }
            InventoryUtil.makeItemsRotten((Player)player);
            InventoryUtil.removeRoyaleItems((Player)player);
            player.m_150109_().m_6211_();
            player.m_19880_().add(RESTORE_FLAG);
            player.getPersistentData().m_128379_(RESTORE_FLAG, true);
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        Player player2 = event.player;
        if (!(player2 instanceof ServerPlayer) || !(player = (ServerPlayer)player2).m_6084_()) {
            return;
        }
        boolean hasRestoreFlag = player.m_19880_().contains(RESTORE_FLAG);
        boolean persistentRestoreFlag = player.getPersistentData().m_128471_(RESTORE_FLAG);
        if (!hasRestoreFlag && !persistentRestoreFlag) {
            return;
        }
        ServerLevel level = player.m_183503_();
        VaultJoinSnapshotData.get(level).getLastSnapshot(player.m_142081_()).ifPresent(snapshot -> snapshot.apply((Player)player));
        player.m_20137_(RESTORE_FLAG);
        if (persistentRestoreFlag) {
            player.getPersistentData().m_128473_(RESTORE_FLAG);
        }
        VaultMod.LOGGER.info("Restored PvP inventory for {}", (Object)player.m_6302_());
    }

    static {
        CommonEvents.PLAYER_MINE.register(PlayerEvents.class, event -> {
            if (event.getWorld().m_8055_(event.getPos()).m_60734_() instanceof IAllowZone) {
                return;
            }
            IZonedWorld proxy = IZonedWorld.of(event.getWorld()).orElse(null);
            if (proxy == null) {
                return;
            }
            List<WorldZone> zones = proxy.getZones().get(event.getPos());
            if (zones.isEmpty()) {
                return;
            }
            for (WorldZone zone : zones) {
                if (zone.canModify() != Boolean.FALSE) continue;
                event.setCanceled(true);
                return;
            }
        });
        CommonEvents.ENTITY_PLACE.register(PlayerEvents.class, event -> {
            if (event.getWorld().m_8055_(event.getPos()).m_60734_() instanceof IAllowZone) {
                return;
            }
            IZonedWorld proxy = IZonedWorld.of(event.getWorld()).orElse(null);
            if (proxy == null) {
                return;
            }
            List<WorldZone> zones = proxy.getZones().get(event.getPos());
            if (zones.isEmpty()) {
                return;
            }
            for (WorldZone zone : zones) {
                if (zone.canModify() != Boolean.FALSE) continue;
                event.setCanceled(true);
                return;
            }
        });
        CommonEvents.PLAYER_STAT.of(PlayerStat.RELENTLESS_STRIKE).register(PlayerEvents.class, data -> {
            Player player;
            ItemStack stack;
            LivingEntity patt6459$temp = data.getEntity();
            if (patt6459$temp instanceof Player && (stack = (player = (Player)patt6459$temp).m_21205_()).m_41720_() instanceof VaultGearItem) {
                VaultGearData gearData = VaultGearData.read(stack);
                gearData.getFirstValue(ModGearAttributes.RELENTLESS_STRIKE).ifPresent(relentlessStrikeDamage -> data.setValue(data.getValue() + relentlessStrikeDamage.floatValue()));
                gearData.getFirstValue(ModGearAttributes.RELENTLESS_STRIKE_ATTRIBUTE).ifPresent(relentlessStrikeAttribute -> data.setValue(data.getValue() + relentlessStrikeAttribute.getAttackDamageIncrease()));
            }
        });
        ((EntityDamageEvent)CommonEvents.ENTITY_DAMAGE.filter(event -> event.getEntity() instanceof Player)).register(PlayerEvents.class, data -> {
            Entity patt7593$temp = data.getEntity();
            if (patt7593$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt7593$temp;
                for (ItemStack stack : player.m_6168_()) {
                    Item patt7748$temp = stack.m_41720_();
                    if (!(patt7748$temp instanceof VaultGearItem)) continue;
                    VaultGearItem gearItem = (VaultGearItem)patt7748$temp;
                    VaultGearData gearData = VaultGearData.read(stack);
                    gearData.getFirstValue(ModGearAttributes.ABILITY_ON_DAMAGE).ifPresent(abilityTriggerOnDamageAttribute -> abilityTriggerOnDamageAttribute.trigger(player, JavaRandom.ofNanoTime()));
                }
            }
        });
        CommonEvents.LISTENER_JOIN.register(PlayerEvents.class, data -> {
            Vault vault = data.getVault();
            if (!VaultUtils.isPvPVault(vault)) {
                return;
            }
            Listener listener = data.getListener();
            if (!(listener instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)listener;
            runner.getPlayer().ifPresent(player -> player.m_7292_(new MobEffectInstance(ModEffects.PVP_PROTECTION, 9999999, 0, true, false, false)));
        });
        CommonEvents.LISTENER_LEAVE.register(PlayerEvents.class, data -> {
            Vault vault = data.getVault();
            if (!VaultUtils.isPvPVault(vault)) {
                return;
            }
            Listener listener = data.getListener();
            if (!(listener instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)listener;
            runner.getPlayer().ifPresent(player -> player.m_21195_(ModEffects.PVP_PROTECTION));
        });
        CommonEvents.ENTITY_DEATH.register(HitHeartsAttribute.class, event -> {
            Optional<Float> attribute;
            VaultGearData data;
            Player player;
            ItemStack stack;
            LivingEntity deather = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (ActiveFlagsCheck.isAnyFlagActiveLuckyHit()) {
                return;
            }
            if (!VaultUtils.isVaultLevel(deather.f_19853_)) {
                return;
            }
            Entity patt9427$temp = source.m_7639_();
            if (patt9427$temp instanceof Player && (stack = (player = (Player)patt9427$temp).m_21205_()).m_41720_() instanceof VaultGearItem && (data = VaultGearData.read(stack)).hasAttribute(ModGearAttributes.HIT_HEARTS) && (attribute = data.getFirstValue(ModGearAttributes.HIT_HEARTS)).isPresent()) {
                float hitHeartsAttribute = attribute.get().floatValue();
                JavaRandom rand = JavaRandom.ofNanoTime();
                if (rand.nextFloat() < hitHeartsAttribute) {
                    ItemStack heartFragment = new ItemStack((ItemLike)ModItems.HEART_FRAGMENT);
                    FloatingItemEntity floatingItem = FloatingItemEntity.create(deather.f_19853_, new BlockPos(deather.m_20185_(), deather.m_20186_() + (double)0.4f, deather.m_20189_()), heartFragment).setDroppingParticles(true);
                    floatingItem.setColor(11540247, 0x750707);
                    deather.f_19853_.m_7967_((Entity)floatingItem);
                }
            }
        });
        CommonEvents.VAULT_LEVEL_UP.register(PlayerEvents.class, data -> {
            if (!ActiveFlags.IS_BURGER_XP.isSet()) {
                VaultGearHelper.grantLivingCompletion(data.getPlayer(), data.getNewLevel());
            }
        });
    }
}

