/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.world.data.PlayerTitlesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerTabNameEvent {
    private static final Set<UUID> IN_VAULT = new HashSet<UUID>();

    @SubscribeEvent
    public static void onTabListNameFormat(PlayerEvent.TabListNameFormat event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            int vaultLevel = PlayerVaultStatsData.get(player2.m_183503_()).getVaultStats((Player)player2).getVaultUncappedLevel();
            TextComponent display = new TextComponent("");
            MutableComponent level = new TextComponent(String.valueOf(vaultLevel)).m_130940_(ChatFormatting.YELLOW);
            TextComponent space = new TextComponent(" ");
            display.m_7220_((Component)level).m_7220_((Component)space);
            Component playerName = (Component)PlayerTitlesData.getCustomName(player2.m_142081_(), (Component)new TextComponent(player2.m_7755_().getString()), PlayerTitlesData.Type.TAB_LIST, false).orElse(player2.m_5446_().m_6881_());
            display.m_7220_(playerName);
            if (IN_VAULT.contains(player2.m_142081_())) {
                display.m_7220_((Component)new TextComponent(" (Vault)").m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                display.m_7220_((Component)new TextComponent(""));
            }
            event.setDisplayName((Component)display);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (event.phase != TickEvent.Phase.END && serverPlayer.f_8924_.m_129783_().m_46467_() % 100L != 0L) {
                return;
            }
            boolean updated = ServerVaults.get(serverPlayer.f_19853_).isPresent() ? IN_VAULT.add(serverPlayer.m_142081_()) : IN_VAULT.remove(serverPlayer.m_142081_());
            if (updated) {
                serverPlayer.refreshTabListName();
            }
        }
    }
}

