/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import com.mojang.serialization.Lifecycle;
import iskallia.vault.VaultMod;
import iskallia.vault.antique.Antique;
import iskallia.vault.antique.AntiqueRegistry;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.antique.condition.AntiqueConditionRegistry;
import iskallia.vault.antique.reward.AntiqueReward;
import iskallia.vault.antique.reward.AntiqueRewardTypeRegistry;
import iskallia.vault.core.SkyVaultsChunkGenerator;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.charm.CharmEffect;
import iskallia.vault.gear.charm.CharmEffectRegistry;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationRegistry;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModAntiques;
import iskallia.vault.init.ModArchetypes;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModCharms;
import iskallia.vault.init.ModContainers;
import iskallia.vault.init.ModDecorativeBlocks;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModFeatures;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModGearModifications;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModModels;
import iskallia.vault.init.ModRecipes;
import iskallia.vault.init.ModShaders;
import iskallia.vault.init.ModSounds;
import iskallia.vault.init.ModStructures;
import iskallia.vault.init.ModTrinkets;
import iskallia.vault.skill.archetype.AbstractArchetype;
import iskallia.vault.skill.archetype.ArchetypeRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEvents {
    @SubscribeEvent
    public static void onNewRegistryRegister(NewRegistryEvent event) {
        VaultGearAttributeRegistry.buildRegistry(event);
        TrinketEffectRegistry.buildRegistry(event);
        CharmEffectRegistry.buildRegistry(event);
        GearModificationRegistry.buildRegistry(event);
        ArchetypeRegistry.buildRegistry(event);
        AntiqueRegistry.buildRegistry(event);
        AntiqueConditionRegistry.buildRegistry(event);
        AntiqueRewardTypeRegistry.buildRegistry(event);
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        ModBlocks.registerBlocks(event);
        ModDecorativeBlocks.registerBlocks(event);
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        ModItems.registerItems(event);
        ModDynamicModels.initItemAssociations();
        ModDynamicModels.initCauldronWashables();
        ModBlocks.registerBlockItems(event);
        ModDecorativeBlocks.registerBlockItems(event);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        ModModels.setupRenderLayers();
        ModModels.ItemProperty.register();
        ModModels.ItemProperty.registerOverrides();
    }

    @SubscribeEvent
    public static void ohRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ModBlocks.registerTileEntityRenderers(event);
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) {
        ModShaders.register(event);
    }

    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.registerSounds(event);
    }

    @SubscribeEvent
    public static void onStructureRegister(RegistryEvent.Register<StructureFeature<?>> event) {
        ModStructures.register(event);
        ModFeatures.registerStructureFeatures();
    }

    @SubscribeEvent
    public static void onFeatureRegister(RegistryEvent.Register<Feature<?>> event) {
        ModFeatures.registerFeatures(event);
    }

    @SubscribeEvent
    public static void onContainerRegister(RegistryEvent.Register<MenuType<?>> event) {
        ModContainers.register(event);
    }

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.register(event);
    }

    @SubscribeEvent
    public static void onTileEntityRegister(RegistryEvent.Register<BlockEntityType<?>> event) {
        ModBlocks.registerTileEntities(event);
    }

    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<RecipeSerializer<?>> event) {
        ModRecipes.Serializer.register(event);
    }

    @SubscribeEvent
    public static void onEffectRegister(RegistryEvent.Register<MobEffect> event) {
        ModEffects.register(event);
        MobEffects.f_19598_.m_19485_().clear();
    }

    @SubscribeEvent
    public static void onAttributeRegister(RegistryEvent.Register<Attribute> event) {
        RangedAttribute attr;
        Attribute attribute = Attributes.f_22276_;
        if (attribute instanceof RangedAttribute) {
            attr = (RangedAttribute)attribute;
            attr.f_22308_ = Double.MAX_VALUE;
        }
        if ((attribute = Attributes.f_22284_) instanceof RangedAttribute) {
            attr = (RangedAttribute)attribute;
            attr.f_22308_ = Double.MAX_VALUE;
        }
        ModAttributes.register(event);
    }

    @SubscribeEvent
    public static void onGearAttributeRegistry(RegistryEvent.Register<VaultGearAttribute<?>> event) {
        ModGearAttributes.init(event);
        ModGearAttributes.registerAssociations();
        EtchingGearAttributes.init(event);
    }

    @SubscribeEvent
    public static void onTrinketRegistry(RegistryEvent.Register<TrinketEffect<?>> event) {
        ModTrinkets.init(event);
    }

    @SubscribeEvent
    public static void onCharmRegistry(RegistryEvent.Register<CharmEffect<?>> event) {
        ModCharms.init(event);
    }

    @SubscribeEvent
    public static void onModificationRegistry(RegistryEvent.Register<GearModification> event) {
        ModGearModifications.init(event);
    }

    @SubscribeEvent
    public static void onArchetypesRegistry(RegistryEvent.Register<AbstractArchetype<?>> event) {
        ModArchetypes.init(event);
    }

    @SubscribeEvent
    public static void onAntiqueRegistry(RegistryEvent.Register<Antique> event) {
        ModAntiques.registerAntiques(event);
    }

    @SubscribeEvent
    public static void onAntiqueConditionProviderRegistry(RegistryEvent.Register<AntiqueCondition.Provider> event) {
        ModAntiques.Conditions.registerAntiqueConditions(event);
    }

    @SubscribeEvent
    public static void onAntiqueRewardProviderRegistry(RegistryEvent.Register<AntiqueReward.Provider> event) {
        ModAntiques.Rewards.registerAntiqueRewards(event);
    }

    @SubscribeEvent
    public static void onForgeWorldPreset(RegistryEvent.Register<ForgeWorldPreset> event) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return;
        }
        event.getRegistry().register((IForgeRegistryEntry)((ForgeWorldPreset)new ForgeWorldPreset(new ForgeWorldPreset.IChunkGeneratorFactory(){

            public ChunkGenerator createChunkGenerator(RegistryAccess registryAccess, long l, String s) {
                throw new UnsupportedOperationException("Use generic world settings instead");
            }

            public WorldGenSettings createSettings(RegistryAccess dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest, String generatorSettings) {
                MappedRegistry stems = new MappedRegistry(Registry.f_122820_, Lifecycle.stable(), null);
                Registry dimensions = dynamicRegistries.m_175515_(Registry.f_122818_);
                Registry biomes = dynamicRegistries.m_175515_(Registry.f_122885_);
                Registry structures = dynamicRegistries.m_175515_(Registry.f_211073_);
                Registry settings = dynamicRegistries.m_175515_(Registry.f_122878_);
                Registry noises = dynamicRegistries.m_175515_(Registry.f_194568_);
                stems.m_203505_(LevelStem.f_63971_, (Object)new LevelStem(dimensions.m_203538_(DimensionType.f_63845_), (ChunkGenerator)new SkyVaultsChunkGenerator((Registry<StructureSet>)structures, (HolderSet<StructureSet>)HolderSet.m_205809_((Holder[])new Holder[0]), (Registry<NormalNoise.NoiseParameters>)noises, (BiomeSource)MultiNoiseBiomeSource.Preset.f_187087_.m_187104_(biomes, false), seed, (Holder<NoiseGeneratorSettings>)settings.m_203538_(NoiseGeneratorSettings.f_64432_))), Lifecycle.stable());
                return new WorldGenSettings(seed, generateStructures, bonusChest, (Registry)stems);
            }
        }).setRegistryName(VaultMod.id("sky_vaults"))));
    }
}

