/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.util.VaultDamageHelper;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class ServerDamageEventHandler {
    private static final Map<UUID, Long> CRITICAL_HITS = new ConcurrentHashMap<UUID, Long>();
    private static final long CRITICAL_HIT_TIMEOUT = 100L;

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (event != null && event.getEntity() != null) {
            Entity target = event.getTarget();
            if ((double)event.getDamageModifier() == 1.5 || event.isVanillaCritical()) {
                CRITICAL_HITS.put(target.m_142081_(), System.currentTimeMillis());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        Level level;
        LivingEntity entity = event.getEntityLiving();
        float damage = event.getAmount();
        if (!entity.f_19853_.f_46443_ && (level = entity.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity == event.getSource().m_7639_()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            Long criticalTime = CRITICAL_HITS.get(entity.m_142081_());
            if (criticalTime != null && currentTime - criticalTime < 100L) {
                VaultDamageHelper.spawnCriticalDamageNumber((Entity)entity, damage, serverLevel);
                CRITICAL_HITS.remove(entity.m_142081_());
            } else {
                VaultDamageHelper.spawnDamageNumber((Entity)entity, damage, event.getSource(), serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer serverInstance;
        if (event.phase == TickEvent.Phase.END && !CRITICAL_HITS.isEmpty() && (serverInstance = ServerLifecycleHooks.getCurrentServer()).m_129921_() % 20 == 0) {
            long currentTime = System.currentTimeMillis();
            CRITICAL_HITS.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 100L);
        }
    }

    public static void registerCriticalHit(Entity target) {
        if (target != null) {
            CRITICAL_HITS.put(target.m_142081_(), System.currentTimeMillis());
        }
    }
}

