/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event;

import iskallia.vault.init.ModKeybinds;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ServerboundStopSpectatorModeMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SpectatorClientEvents {
    private static int heldTicks = 0;
    private static final int REQUIRED_TICKS = 100;
    private static boolean wasHolding = false;
    private static boolean isVaultSpectating = false;

    public static void setVaultSpectating(boolean spectating) {
        isVaultSpectating = spectating;
        if (!spectating) {
            SpectatorClientEvents.resetHeldTicks();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (!isVaultSpectating || !player.m_5833_()) {
            SpectatorClientEvents.resetHeldTicks();
            return;
        }
        boolean isHolding = ModKeybinds.stopSpectatingKey.m_90857_();
        String keyName = ModKeybinds.stopSpectatingKey.m_90863_().getString();
        if (keyName.isEmpty() || keyName.equalsIgnoreCase("not bound")) {
            keyName = mc.f_91066_.f_92090_.m_90863_().getString();
        }
        if (isHolding || player.m_6144_()) {
            if (!wasHolding) {
                heldTicks = 0;
                wasHolding = true;
            } else {
                int remainingTicks = 100 - ++heldTicks;
                int remainingSeconds = Math.max(1, (remainingTicks + 19) / 20);
                if (heldTicks % 20 == 0 || heldTicks == 1) {
                    player.m_5661_((Component)new TextComponent("Exiting spectator mode in " + remainingSeconds + " seconds"), true);
                }
                if (heldTicks >= 100) {
                    SpectatorClientEvents.requestStopSpectating();
                    SpectatorClientEvents.resetHeldTicks();
                }
            }
        } else {
            if (wasHolding) {
                SpectatorClientEvents.resetHeldTicks();
            }
            player.m_5661_((Component)new TextComponent("Hold " + keyName + " for 5 seconds to exit spectator"), true);
        }
    }

    private static void resetHeldTicks() {
        heldTicks = 0;
        wasHolding = false;
    }

    private static void requestStopSpectating() {
        ModNetwork.CHANNEL.sendToServer((Object)new ServerboundStopSpectatorModeMessage());
    }
}

